/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.axiom;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.axiom.AxiomLintPattern;
import com.clarkparsia.pellint.lintpattern.axiom.DisjunctionSizeCollector;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.Severity;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class LargeDisjunctionPattern
extends AxiomLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();
    private int m_MaxAllowed = 10;
    private DisjunctionSizeCollector m_Visitor = new DisjunctionSizeCollector();

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxAllowed = " + this.m_MaxAllowed + ")";
    }

    @Override
    public String getDescription() {
        return "Too many disjuncts in a disjunction - maximum recommended is " + this.m_MaxAllowed;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxAllowed(int value) {
        this.m_MaxAllowed = value;
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)axiom);
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)axiom);
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)axiom);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.visitNaryClassAxiom((OWLClassAxiom)axiom);
    }

    private void visitNaryClassAxiom(OWLClassAxiom axiom) {
        this.m_Visitor.reset();
        axiom.accept((OWLObjectVisitor)this.m_Visitor);
        int disjunctionSize = this.m_Visitor.getDisjunctionSize();
        if (disjunctionSize > this.m_MaxAllowed) {
            Lint lint = this.makeLint();
            lint.addParticipatingAxiom(axiom);
            lint.setSeverity(new Severity(disjunctionSize));
            this.setLint(lint);
        }
    }
}

