/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.lintpattern.ontology;

import com.clarkparsia.pellint.format.LintFormat;
import com.clarkparsia.pellint.format.SimpleLintFormat;
import com.clarkparsia.pellint.lintpattern.ontology.ClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.ExistentialClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.NamedClassCollector;
import com.clarkparsia.pellint.lintpattern.ontology.OntologyLintPattern;
import com.clarkparsia.pellint.model.Lint;
import com.clarkparsia.pellint.model.LintFactory;
import com.clarkparsia.pellint.model.Severity;
import com.clarkparsia.pellint.util.OptimizedDirectedMultigraph;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.alg.StrongConnectivityInspector;
import org.jgrapht.alg.TransitiveClosure;
import org.jgrapht.ext.DOTExporter;
import org.jgrapht.ext.StringNameProvider;
import org.jgrapht.ext.VertexNameProvider;
import org.jgrapht.graph.DefaultWeightedEdge;
import org.jgrapht.graph.DirectedSubgraph;
import org.jgrapht.graph.EdgeReversedGraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class ExistentialExplosionPattern
implements OntologyLintPattern {
    private static final LintFormat DEFAULT_LINT_FORMAT = new SimpleLintFormat();
    private int m_MaxTreeSize = 10000;
    private List<Lint> m_AccumulatedLints;
    private LintFactory m_LintFactory;

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + " (MaxTreeSize = " + this.m_MaxTreeSize + ")";
    }

    @Override
    public String getDescription() {
        return "Concepts/Individuals are involved in a large some/min/exact value restrictions tree/loop - maximum recommended number of generated nodes is " + this.m_MaxTreeSize;
    }

    @Override
    public boolean isFixable() {
        return false;
    }

    @Override
    public LintFormat getDefaultLintFormat() {
        return DEFAULT_LINT_FORMAT;
    }

    public void setMaxTreeSize(int value) {
        this.m_MaxTreeSize = value;
    }

    @Override
    public List<Lint> match(OWLOntology ontology) {
        this.m_AccumulatedLints = new ArrayList<Lint>();
        this.m_LintFactory = new LintFactory(this, ontology);
        OptimizedDirectedMultigraph<OWLClass> existentialRestrictionGraph = ExistentialExplosionPattern.extractGraphFromSubsumptionAxiomsWith(ontology, new ExistentialClassCollector());
        this.estimateTreeSizesForCycles(existentialRestrictionGraph);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        OptimizedDirectedMultigraph<OWLClass> toldSubsumptionGraph = ExistentialExplosionPattern.extractGraphFromSubsumptionAxiomsWith(ontology, new NamedClassCollector());
        TransitiveClosure.INSTANCE.closeSimpleDirectedGraph(toldSubsumptionGraph);
        ExistentialExplosionPattern.addInheritedEdges(existentialRestrictionGraph, toldSubsumptionGraph);
        this.estimateTreeSizesForCycles(existentialRestrictionGraph);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        Map<OWLClass, Integer> individualCounts = ExistentialExplosionPattern.countIndividuals(ontology);
        this.estimateTreeSizesForCyclesWithIndividuals(existentialRestrictionGraph, toldSubsumptionGraph, individualCounts);
        if (!this.m_AccumulatedLints.isEmpty()) {
            return this.m_AccumulatedLints;
        }
        this.removeCyclesAndEstimateTreeSizesWithIndividuals(existentialRestrictionGraph, individualCounts);
        return this.m_AccumulatedLints;
    }

    private static <V, E> void printGraph(Graph<V, E> graph) {
        DOTExporter exp = new DOTExporter((VertexNameProvider)new StringNameProvider(), null, null);
        exp.export((Writer)new BufferedWriter(new PrintWriter(System.out)), graph);
    }

    private static OptimizedDirectedMultigraph<OWLClass> extractGraphFromSubsumptionAxiomsWith(OWLOntology ontology, ClassCollector visitor) {
        OptimizedDirectedMultigraph<OWLClass> graph = new OptimizedDirectedMultigraph<OWLClass>();
        for (OWLSubClassOfAxiom axiom : ontology.getAxioms(AxiomType.SUBCLASS_OF)) {
            ExistentialExplosionPattern.processSubsumption(graph, axiom.getSubClass(), axiom.getSuperClass(), visitor);
        }
        for (OWLSubClassOfAxiom axiom : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
            Set equivalences = axiom.getClassExpressions();
            for (OWLClassExpression equivalence1 : equivalences) {
                for (OWLClassExpression equivalence2 : equivalences) {
                    if (equivalence1 == equivalence2) continue;
                    ExistentialExplosionPattern.processSubsumption(graph, equivalence1, equivalence2, visitor);
                }
            }
        }
        return graph;
    }

    private static void processSubsumption(OptimizedDirectedMultigraph<OWLClass> graph, OWLClassExpression subDesc, OWLClassExpression superDesc, ClassCollector visitor) {
        if (subDesc.isAnonymous()) {
            return;
        }
        OWLClass subClass = subDesc.asOWLClass();
        visitor.reset();
        superDesc.accept((OWLClassExpressionVisitor)visitor);
        for (OWLClass superClass : visitor.getCollectedClasses()) {
            if (subClass.equals(superClass)) continue;
            graph.addVertex(subClass);
            graph.addVertex(superClass);
            graph.addEdge(subClass, superClass);
        }
    }

    private static void addInheritedEdges(OptimizedDirectedMultigraph<OWLClass> existentialRestrictionGraph, OptimizedDirectedMultigraph<OWLClass> toldSubsumptionGraph) {
        for (OWLClass superClass : toldSubsumptionGraph.vertexSet()) {
            if (!existentialRestrictionGraph.containsVertex(superClass)) continue;
            Set ancestorEdges = existentialRestrictionGraph.outgoingEdgesOf(superClass);
            for (DefaultWeightedEdge subClassEdge : toldSubsumptionGraph.incomingEdgesOf(superClass)) {
                OWLClass subClass = (OWLClass)toldSubsumptionGraph.getEdgeSource(subClassEdge);
                if (!existentialRestrictionGraph.containsVertex(subClass)) continue;
                for (DefaultWeightedEdge ancestorEdge : ancestorEdges) {
                    int ancestorEdgeCount = existentialRestrictionGraph.getEdgeMultiplicity(ancestorEdge);
                    OWLClass ancestorEdgeTarget = (OWLClass)existentialRestrictionGraph.getEdgeTarget(ancestorEdge);
                    if (subClass.equals(ancestorEdgeTarget)) continue;
                    existentialRestrictionGraph.addEdge(subClass, ancestorEdgeTarget, ancestorEdgeCount);
                }
            }
        }
    }

    private static Map<OWLClass, Integer> countIndividuals(OWLOntology ontology) {
        HashMap<OWLClass, Integer> individualCount = new HashMap<OWLClass, Integer>();
        for (OWLClassAssertionAxiom axiom : ontology.getAxioms(AxiomType.CLASS_ASSERTION)) {
            OWLClassExpression desc = axiom.getClassExpression();
            if (desc.isAnonymous()) continue;
            OWLClass assertedClass = desc.asOWLClass();
            Integer oldCount = (Integer)individualCount.get(assertedClass);
            if (oldCount == null) {
                oldCount = 0;
            }
            individualCount.put(assertedClass, oldCount + 1);
        }
        return individualCount;
    }

    private static int getMaxSizeOfCompleteGraphToIgnore(int maxTreeSize) {
        int i = 1;
        while (Math.pow(i - 1, i) < (double)maxTreeSize) {
            ++i;
        }
        return i - 1;
    }

    private void estimateTreeSizesForCycles(OptimizedDirectedMultigraph<OWLClass> existentialRestrictionGraph) {
        int maxSizeOfCompleteGraphToIgnore = ExistentialExplosionPattern.getMaxSizeOfCompleteGraphToIgnore(this.m_MaxTreeSize);
        StrongConnectivityInspector connectivityInspector = new StrongConnectivityInspector(existentialRestrictionGraph);
        for (Set connectedSet : connectivityInspector.stronglyConnectedSets()) {
            if (connectedSet.size() <= maxSizeOfCompleteGraphToIgnore) continue;
            DirectedSubgraph subgraph = new DirectedSubgraph(existentialRestrictionGraph, connectedSet, null);
            double estimatedTreeSize = 1.0;
            for (OWLClass owlClass : connectedSet) {
                estimatedTreeSize *= (double)subgraph.outDegreeOf((Object)owlClass);
            }
            if (!(estimatedTreeSize > (double)this.m_MaxTreeSize)) continue;
            Lint lint = this.m_LintFactory.make();
            lint.addAllParticipatingClasses(connectedSet);
            lint.setSeverity(new Severity(estimatedTreeSize));
            this.m_AccumulatedLints.add(lint);
        }
    }

    private void estimateTreeSizesForCyclesWithIndividuals(OptimizedDirectedMultigraph<OWLClass> existentialRestrictionGraph, OptimizedDirectedMultigraph<OWLClass> toldSubsumptionGraph, Map<OWLClass, Integer> individualCount) {
        StrongConnectivityInspector connectivityInspector = new StrongConnectivityInspector(existentialRestrictionGraph);
        for (Set connectedSet : connectivityInspector.stronglyConnectedSets()) {
            Object owlClass22;
            if (connectedSet.size() <= 1) continue;
            DirectedSubgraph subgraph = new DirectedSubgraph(existentialRestrictionGraph, connectedSet, null);
            double estimatedTreeSize = 1.0;
            for (Object owlClass22 : connectedSet) {
                estimatedTreeSize *= (double)subgraph.outDegreeOf(owlClass22);
            }
            HashSet<Object> allSubclassesOfConnectedSet = new HashSet<Object>(connectedSet);
            owlClass22 = connectedSet.iterator();
            while (owlClass22.hasNext()) {
                OWLClass owlClass3 = (OWLClass)owlClass22.next();
                if (!toldSubsumptionGraph.containsVertex(owlClass3)) continue;
                for (DefaultWeightedEdge inEdge : toldSubsumptionGraph.incomingEdgesOf(owlClass3)) {
                    allSubclassesOfConnectedSet.add(toldSubsumptionGraph.getEdgeSource(inEdge));
                }
            }
            int totalInvolvedIndividuals = 0;
            for (Map.Entry entry : individualCount.entrySet()) {
                if (!allSubclassesOfConnectedSet.contains(entry.getKey())) continue;
                totalInvolvedIndividuals += ((Integer)entry.getValue()).intValue();
            }
            if (!((estimatedTreeSize *= (double)totalInvolvedIndividuals) > (double)this.m_MaxTreeSize)) continue;
            Lint lint = this.m_LintFactory.make();
            lint.addAllParticipatingClasses(connectedSet);
            lint.setSeverity(new Severity(estimatedTreeSize));
            this.m_AccumulatedLints.add(lint);
        }
    }

    private void removeCyclesAndEstimateTreeSizesWithIndividuals(OptimizedDirectedMultigraph<OWLClass> existentialRestrictionGraph, Map<OWLClass, Integer> individualCounts) {
        HashMap<OWLClass, Object> accumulatedChildren = new HashMap<OWLClass, Object>();
        CycleDetector cycleDetector = new CycleDetector(existentialRestrictionGraph);
        Set nodesInACycle = cycleDetector.findCycles();
        for (OWLClass child : nodesInACycle) {
            Double childValue = (Double)accumulatedChildren.get(child);
            if (childValue == null) {
                childValue = (double)existentialRestrictionGraph.outDegreeOf(child) + 1.0;
            }
            for (Object inEdge : existentialRestrictionGraph.incomingEdgesOf(child)) {
                int inEdgeCount = existentialRestrictionGraph.getEdgeMultiplicity((DefaultWeightedEdge)inEdge);
                OWLClass parent = (OWLClass)existentialRestrictionGraph.getEdgeSource(inEdge);
                Double oldValue = (Double)accumulatedChildren.get(parent);
                if (oldValue == null) {
                    oldValue = existentialRestrictionGraph.outDegreeOf(parent);
                }
                accumulatedChildren.put(parent, oldValue + childValue * (double)inEdgeCount);
            }
        }
        existentialRestrictionGraph.removeAllVertices(nodesInACycle);
        if (!existentialRestrictionGraph.vertexSet().isEmpty()) {
            EdgeReversedGraph reversedForest = new EdgeReversedGraph(existentialRestrictionGraph);
            TopologicalOrderIterator bottomUpIt = new TopologicalOrderIterator((DirectedGraph)reversedForest);
            while (bottomUpIt.hasNext()) {
                OWLClass node = (OWLClass)bottomUpIt.next();
                Object nodeSize = (Double)accumulatedChildren.get(node);
                if (nodeSize == null) {
                    nodeSize = 1.0;
                }
                for (DefaultWeightedEdge outEdge : existentialRestrictionGraph.outgoingEdgesOf(node)) {
                    int outEdgeCount = existentialRestrictionGraph.getEdgeMultiplicity(outEdge);
                    OWLClass child = (OWLClass)existentialRestrictionGraph.getEdgeTarget(outEdge);
                    Double childValue = (Double)accumulatedChildren.get(child);
                    if (childValue == null) {
                        childValue = 1.0;
                    }
                    nodeSize = (Double)nodeSize + childValue * (double)outEdgeCount;
                }
                accumulatedChildren.put(node, nodeSize);
            }
        }
        HashSet<OWLClass> participatingClasses = new HashSet<OWLClass>();
        double estimatedTotalTreeSize = 0.0;
        for (Map.Entry<OWLClass, Integer> entry : individualCounts.entrySet()) {
            OWLClass owlClass = entry.getKey();
            int individualCount = entry.getValue();
            Double childCount = (Double)accumulatedChildren.get(owlClass);
            if (childCount == null) continue;
            double totalCount = childCount * (double)individualCount;
            estimatedTotalTreeSize += totalCount;
            if (!(totalCount > 0.0)) continue;
            participatingClasses.add(owlClass);
        }
        if (estimatedTotalTreeSize > (double)this.m_MaxTreeSize) {
            Lint lint = this.m_LintFactory.make();
            lint.addAllParticipatingClasses(participatingClasses);
            lint.setSeverity(new Severity(estimatedTotalTreeSize));
            this.m_AccumulatedLints.add(lint);
        }
    }
}

