/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.LimitedMapIRIMapper;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;

public class OWLAPILoader
extends KBLoader {
    private OWLOntologyManager manager;
    private PelletReasoner pellet;
    private LimitedMapIRIMapper iriMapper = new LimitedMapIRIMapper();
    private OWLOntology baseOntology;
    private boolean ignoreImports;
    private boolean loadSingleFile;

    public OWLAPILoader() {
        this.manager = OWLManager.createOWLOntologyManager();
        this.manager.setSilentMissingImportsHandling(true);
        this.manager.addMissingImportListener(new MissingImportListener(){

            public void importMissing(MissingImportEvent event) {
                if (!OWLAPILoader.this.ignoreImports) {
                    IRI importURI = event.getImportedOntologyURI();
                    System.err.println("WARNING: Cannot import " + importURI);
                    event.getCreationException().printStackTrace();
                }
            }
        });
        this.clear();
    }

    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public OWLOntology getOntology() {
        return this.baseOntology;
    }

    public Set<OWLOntology> getAllOntologies() {
        return this.manager.getOntologies();
    }

    public PelletReasoner getReasoner() {
        return this.pellet;
    }

    public void load() {
        this.pellet = new PelletReasonerFactory().createReasoner(this.baseOntology);
        this.pellet.getKB().setTaxonomyBuilderProgressMonitor(PelletOptions.USE_CLASSIFICATION_MONITOR.create());
    }

    public void parse(String ... fileNames) {
        this.loadSingleFile = fileNames.length == 1;
        super.parse(fileNames);
    }

    protected void parseFile(String file) {
        try {
            IRI fileIRI = IRI.create((String)file);
            this.iriMapper.addAllowedIRI(fileIRI);
            if (this.loadSingleFile) {
                this.baseOntology = this.manager.loadOntologyFromOntologyDocument(fileIRI);
            } else {
                OWLOntology importOnt = this.manager.loadOntologyFromOntologyDocument(fileIRI);
                OWLImportsDeclaration declaration = this.manager.getOWLDataFactory().getOWLImportsDeclaration(importOnt.getOntologyID().getOntologyIRI());
                this.manager.applyChange((OWLOntologyChange)new AddImport(this.baseOntology, declaration));
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
        catch (OWLOntologyChangeException e) {
            throw new RuntimeException(e);
        }
    }

    public void setIgnoreImports(boolean ignoreImports) {
        this.ignoreImports = ignoreImports;
        if (ignoreImports) {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)this.iriMapper);
        } else {
            this.manager.clearIRIMappers();
            this.manager.addIRIMapper((OWLOntologyIRIMapper)new NonMappingOntologyIRIMapper());
        }
    }

    public void clear() {
        this.iriMapper.clear();
        for (OWLOntology ont : this.manager.getOntologies()) {
            this.manager.removeOntology(ont);
        }
        try {
            this.baseOntology = this.manager.createOntology();
        }
        catch (OWLOntologyCreationException e) {
            throw new RuntimeException(e);
        }
    }
}

