/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase;

import com.clarkparsia.owlwg.testcase.AbstractBaseTestCase;
import com.clarkparsia.owlwg.testcase.PremisedTest;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractPremisedTest<O>
extends AbstractBaseTestCase<O>
implements PremisedTest<O> {
    private static final Logger log = Logger.getLogger(AbstractPremisedTest.class.getCanonicalName());
    private final EnumSet<SerializationFormat> premiseFormats = EnumSet.noneOf(SerializationFormat.class);
    private final EnumMap<SerializationFormat, String> premiseOntologyLiteral = new EnumMap(SerializationFormat.class);

    public AbstractPremisedTest(OWLOntology ontology, OWLNamedIndividual i) {
        super(ontology, i);
        Map values = i.getDataPropertyValues(ontology);
        for (SerializationFormat f : SerializationFormat.values()) {
            Set premises = (Set)values.get(f.getPremiseOWLDataProperty());
            if (premises == null) continue;
            if (premises.size() > 1) {
                log.warning(String.format("Multiple premise ontologies found for testcase (%s) with serialization format (%s).  Choosing arbitrarily.", new Object[]{this.getIdentifier(), f}));
            }
            this.premiseOntologyLiteral.put(f, ((OWLLiteral)premises.iterator().next()).getLiteral());
            this.premiseFormats.add(f);
        }
    }

    @Override
    public void dispose() {
        this.premiseFormats.clear();
        this.premiseOntologyLiteral.clear();
        super.dispose();
    }

    @Override
    public Set<SerializationFormat> getPremiseFormats() {
        return Collections.unmodifiableSet(this.premiseFormats);
    }

    @Override
    public String getPremiseOntology(SerializationFormat format) {
        return this.premiseOntologyLiteral.get((Object)format);
    }
}

