/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase;

import com.clarkparsia.owlwg.testcase.AbstractPremisedTest;
import com.clarkparsia.owlwg.testcase.EntailmentTest;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractEntailmentTest<O>
extends AbstractPremisedTest<O>
implements EntailmentTest<O> {
    private static final Logger log = Logger.getLogger(AbstractEntailmentTest.class.getCanonicalName());
    private final EnumSet<SerializationFormat> conclusionFormats = EnumSet.noneOf(SerializationFormat.class);
    private final EnumMap<SerializationFormat, String> conclusionOntologyLiteral = new EnumMap(SerializationFormat.class);

    public AbstractEntailmentTest(OWLOntology ontology, OWLNamedIndividual i, boolean positive) {
        super(ontology, i);
        Map values = i.getDataPropertyValues(ontology);
        for (SerializationFormat f : SerializationFormat.values()) {
            Set conclusions = (Set)values.get(positive ? f.getConclusionOWLDataProperty() : f.getNonConclusionOWLDataProperty());
            if (conclusions == null) continue;
            if (conclusions.size() > 1) {
                log.warning(String.format("Multiple conclusion ontologies found for testcase (%s) with serialization format (%s).  Choosing arbitrarily.", new Object[]{this.getIdentifier(), f}));
            }
            this.conclusionOntologyLiteral.put(f, ((OWLLiteral)conclusions.iterator().next()).getLiteral());
            this.conclusionFormats.add(f);
        }
    }

    @Override
    public Set<SerializationFormat> getConclusionFormats() {
        return Collections.unmodifiableSet(this.conclusionFormats);
    }

    @Override
    public String getConclusionOntology(SerializationFormat format) {
        return this.conclusionOntologyLiteral.get((Object)format);
    }
}

