/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.owlapi3.testcase.impl;

import com.clarkparsia.owlwg.owlapi3.testcase.impl.ImportsHelper;
import com.clarkparsia.owlwg.owlapi3.testcase.impl.OwlApi3Case;
import com.clarkparsia.owlwg.testcase.AbstractEntailmentTest;
import com.clarkparsia.owlwg.testcase.EntailmentTest;
import com.clarkparsia.owlwg.testcase.OntologyParseException;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import java.util.EnumMap;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class OwlApi3ETImpl
extends AbstractEntailmentTest<OWLOntology>
implements EntailmentTest<OWLOntology>,
OwlApi3Case {
    private final EnumMap<SerializationFormat, OWLOntology> parsedConclusion;
    private final EnumMap<SerializationFormat, OWLOntology> parsedPremise = new EnumMap(SerializationFormat.class);

    public OwlApi3ETImpl(OWLOntology ontology, OWLNamedIndividual i, boolean positive) {
        super(ontology, i, positive);
        this.parsedConclusion = new EnumMap(SerializationFormat.class);
    }

    @Override
    public OWLOntology parseConclusionOntology(SerializationFormat format) throws OntologyParseException {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            manager.setSilentMissingImportsHandling(true);
            manager.clearIRIMappers();
            ImportsHelper.loadImports(manager, this, format);
            OWLOntology o = this.parsedConclusion.get((Object)format);
            if (o == null) {
                String l = this.getConclusionOntology(format);
                if (l == null) {
                    return null;
                }
                StringDocumentSource source = new StringDocumentSource(l);
                o = OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)source);
                this.parsedConclusion.put(format, o);
            }
            return o;
        }
        catch (OWLOntologyCreationException e) {
            throw new OntologyParseException(e);
        }
    }

    @Override
    public OWLOntology parsePremiseOntology(SerializationFormat format) throws OntologyParseException {
        try {
            OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
            manager.setSilentMissingImportsHandling(true);
            manager.clearIRIMappers();
            ImportsHelper.loadImports(manager, this, format);
            OWLOntology o = this.parsedPremise.get((Object)format);
            if (o == null) {
                String l = this.getPremiseOntology(format);
                if (l == null) {
                    return null;
                }
                StringDocumentSource source = new StringDocumentSource(l);
                o = manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)source);
                this.parsedPremise.put(format, o);
            }
            return o;
        }
        catch (OWLOntologyCreationException e) {
            throw new OntologyParseException(e);
        }
    }
}

