/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testrun;

import com.clarkparsia.owlwg.runner.ReadOnlyTestRunner;
import com.clarkparsia.owlwg.runner.TestRunner;
import com.clarkparsia.owlwg.testcase.SyntaxConstraint;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.TestVocabulary;
import com.clarkparsia.owlwg.testrun.AbstractRun;
import com.clarkparsia.owlwg.testrun.ReasoningRun;
import com.clarkparsia.owlwg.testrun.ResultVocabulary;
import com.clarkparsia.owlwg.testrun.RunResultType;
import com.clarkparsia.owlwg.testrun.RunTestType;
import com.clarkparsia.owlwg.testrun.SyntaxConstraintRun;
import com.clarkparsia.owlwg.testrun.SyntaxTranslationRun;
import com.clarkparsia.owlwg.testrun.TestRunResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;

public class TestRunResultParser {
    private static final Logger log = Logger.getLogger(TestRunResultParser.class.getCanonicalName());
    private static final Map<IRI, TestRunner<?>> runners = new HashMap();

    private static TestRunner<?> getRunner(OWLNamedIndividual i, OWLOntology o) {
        IRI iri = i.getIRI();
        TestRunner<?> runner = runners.get(iri);
        if (runner == null) {
            Collection s = EntitySearcher.getAnnotations((OWLAnnotationSubject)i.getIRI(), (OWLOntology)o, (OWLAnnotationProperty)o.getOWLOntologyManager().getOWLDataFactory().getRDFSLabel());
            String name = s == null || s.isEmpty() ? i.getIRI().toURI().toASCIIString() : ((OWLAnnotation)s.iterator().next()).getValue().toString();
            runner = new ReadOnlyTestRunner(iri, name);
            runners.put(iri, runner);
        }
        return runner;
    }

    public Collection<TestRunResult> getResults(OWLOntology o, Map<String, ? extends TestCase<?>> tests) {
        ArrayList<TestRunResult> results = new ArrayList<TestRunResult>();
        for (OWLClassAssertionAxiom axiom : o.getClassAssertionAxioms((OWLClassExpression)ResultVocabulary.Class.TEST_RUN.getOWLClass())) {
            OWLLiteral c;
            String id;
            OWLNamedIndividual i = axiom.getIndividual().asOWLNamedIndividual();
            Map oValues = EntitySearcher.getObjectPropertyValues((OWLIndividual)i, (OWLOntology)o).asMap();
            Collection testObjects = (Collection)oValues.get(ResultVocabulary.ObjectProperty.TEST.getOWLObjectProperty());
            if (testObjects.size() != 1) {
                log.warning(String.format("Skipping result, missing or more than one test assertion (\"%s\",%s)", i.getIRI(), testObjects));
                continue;
            }
            Map testDValues = EntitySearcher.getDataPropertyValues((OWLIndividual)((OWLIndividual)testObjects.iterator().next()), (OWLOntology)o).asMap();
            Collection ids = (Collection)testDValues.get(TestVocabulary.DatatypeProperty.IDENTIFIER.getOWLDataProperty());
            TestCase<?> testCase = null;
            Iterator iterator = ids.iterator();
            while (iterator.hasNext() && (testCase = tests.get(id = (c = (OWLLiteral)iterator.next()).getLiteral())) == null) {
            }
            if (testCase == null) {
                log.warning(String.format("Skipping result, no matching test case found (\"%s\",%s)", i.getIRI(), ids));
                continue;
            }
            Collection runnerIris = (Collection)oValues.get(ResultVocabulary.ObjectProperty.RUNNER.getOWLObjectProperty());
            TestRunner<?> runner = null;
            if (runnerIris.size() != 1) {
                log.warning(String.format("Skipping result, missing or more than one test runner assertion (\"%s\",%s)", i.getIRI(), runnerIris));
                continue;
            }
            runner = TestRunResultParser.getRunner(((OWLIndividual)runnerIris.iterator().next()).asOWLNamedIndividual(), o);
            Collection types = EntitySearcher.getTypes((OWLIndividual)i, (OWLOntology)o);
            RunResultType resultType = null;
            for (RunResultType t : RunResultType.values()) {
                if (!types.contains(t.getOWLClass())) continue;
                resultType = t;
                break;
            }
            if (resultType == null) {
                log.warning(String.format("Skipping result, missing result type (\"%s\")", i.getIRI()));
                continue;
            }
            Collection detailsAnnotations = EntitySearcher.getAnnotations((OWLEntity)i, (OWLOntology)o, (OWLAnnotationProperty)o.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationProperty(ResultVocabulary.AnnotationProperty.DETAILS.getAnnotationPropertyIRI()));
            String details = null;
            int ndetails = detailsAnnotations.size();
            if (ndetails > 0) {
                if (ndetails > 1) {
                    log.info(String.format("Result contains multiple details annotations, ignoring all but first (\"%s\")", i.getIRI()));
                }
                details = ((OWLAnnotation)detailsAnnotations.iterator().next()).getValue().toString();
            }
            AbstractRun result = null;
            if (types.contains(ResultVocabulary.Class.SYNTAX_TRANSLATION_RUN.getOWLClass())) {
                result = details == null ? new SyntaxTranslationRun(testCase, resultType, runner) : new SyntaxTranslationRun(testCase, resultType, runner, details);
            } else if (types.contains(ResultVocabulary.Class.SYNTAX_CONSTRAINT_RUN.getOWLClass())) {
                Collection constraints = (Collection)oValues.get(ResultVocabulary.ObjectProperty.SYNTAX_CONSTRAINT.getOWLObjectProperty());
                SyntaxConstraint constraint = null;
                if (constraints.size() != 1) {
                    log.warning(String.format("Skipping result, missing or more than one syntax constraint assertion (\"%s\",%s)", i.getIRI(), constraints));
                    continue;
                }
                OWLNamedIndividual ind = ((OWLIndividual)constraints.iterator().next()).asOWLNamedIndividual();
                for (SyntaxConstraint c2 : SyntaxConstraint.values()) {
                    if (!c2.getOWLIndividual().equals(ind)) continue;
                    constraint = c2;
                    break;
                }
                if (constraint == null) {
                    log.warning(String.format("Skipping result, unknown syntax constraint assertion (\"%s\",%s)", i.getIRI(), ind));
                    continue;
                }
                result = details == null ? new SyntaxConstraintRun(testCase, resultType, constraint, runner) : new SyntaxConstraintRun(testCase, resultType, constraint, runner, details);
            } else if (types.contains(ResultVocabulary.Class.CONSISTENCY_RUN.getOWLClass())) {
                result = details == null ? new ReasoningRun(testCase, resultType, RunTestType.CONSISTENCY, runner) : new ReasoningRun(testCase, resultType, RunTestType.CONSISTENCY, runner, details);
            } else if (types.contains(ResultVocabulary.Class.INCONSISTENCY_RUN.getOWLClass())) {
                result = details == null ? new ReasoningRun(testCase, resultType, RunTestType.INCONSISTENCY, runner) : new ReasoningRun(testCase, resultType, RunTestType.INCONSISTENCY, runner, details);
            } else if (types.contains(ResultVocabulary.Class.NEGATIVE_ENTAILMENT_RUN.getOWLClass())) {
                result = details == null ? new ReasoningRun(testCase, resultType, RunTestType.NEGATIVE_ENTAILMENT, runner) : new ReasoningRun(testCase, resultType, RunTestType.NEGATIVE_ENTAILMENT, runner, details);
            } else if (types.contains(ResultVocabulary.Class.POSITIVE_ENTAILMENT_RUN.getOWLClass())) {
                result = details == null ? new ReasoningRun(testCase, resultType, RunTestType.POSITIVE_ENTAILMENT, runner) : new ReasoningRun(testCase, resultType, RunTestType.POSITIVE_ENTAILMENT, runner, details);
            }
            results.add(result);
        }
        return results;
    }
}

