/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase;

import com.clarkparsia.owlwg.testcase.ImportedOntology;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import com.clarkparsia.owlwg.testcase.TestVocabulary;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;

public class ImportedOntologyImpl
implements ImportedOntology {
    private static final Logger log = Logger.getLogger(ImportedOntologyImpl.class.getCanonicalName());
    private final EnumSet<SerializationFormat> formats;
    private final EnumMap<SerializationFormat, String> ontologyLiteral;
    private final IRI iri;

    public ImportedOntologyImpl(OWLOntology ontology, OWLNamedIndividual i) {
        Map opValues = EntitySearcher.getObjectPropertyValues((OWLIndividual)i, (OWLOntology)ontology).asMap();
        Collection iris = (Collection)opValues.get(TestVocabulary.ObjectProperty.IMPORTED_ONTOLOGY_IRI.getOWLObjectProperty());
        if (iris == null) {
            String msg = String.format("Value for property %s missing for imported ontology %s", TestVocabulary.ObjectProperty.IMPORTED_ONTOLOGY_IRI.getOWLObjectProperty().getIRI(), i.getIRI());
            log.warning(msg);
            throw new NullPointerException(msg);
        }
        if (iris.size() != 1) {
            String msg = String.format("Property %s should have a single value for imported ontology %s, but has %d", TestVocabulary.ObjectProperty.IMPORTED_ONTOLOGY_IRI.getOWLObjectProperty().getIRI(), i.getIRI(), iris.size());
            log.warning(msg);
            throw new IllegalArgumentException();
        }
        this.iri = ((OWLIndividual)iris.iterator().next()).asOWLNamedIndividual().getIRI();
        Map values = EntitySearcher.getDataPropertyValues((OWLIndividual)i, (OWLOntology)ontology).asMap();
        this.formats = EnumSet.noneOf(SerializationFormat.class);
        this.ontologyLiteral = new EnumMap(SerializationFormat.class);
        for (SerializationFormat f : SerializationFormat.values()) {
            Collection literals = (Collection)values.get(f.getInputOWLDataProperty());
            if (literals == null) continue;
            if (literals.size() > 1) {
                log.warning(String.format("Multiple ontologies found for imported ontology (%s) with serialization format (%s).  Choosing arbitrarily.", new Object[]{i.getIRI(), f}));
            }
            this.ontologyLiteral.put(f, ((OWLLiteral)literals.iterator().next()).getLiteral());
            this.formats.add(f);
        }
    }

    @Override
    public Set<SerializationFormat> getFormats() {
        return Collections.unmodifiableSet(this.formats);
    }

    @Override
    public String getOntology(SerializationFormat format) {
        return this.ontologyLiteral.get((Object)format);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }
}

