/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase;

import com.clarkparsia.owlwg.testcase.ImportedOntology;
import com.clarkparsia.owlwg.testcase.ImportedOntologyImpl;
import com.clarkparsia.owlwg.testcase.Semantics;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import com.clarkparsia.owlwg.testcase.Status;
import com.clarkparsia.owlwg.testcase.SyntaxConstraint;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.TestVocabulary;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;

public abstract class AbstractBaseTestCase<O>
implements TestCase<O> {
    private final String identifier;
    private final Map<IRI, ImportedOntology> imports;
    private final EnumSet<SyntaxConstraint> notsatisfied;
    private final EnumSet<Semantics> notsemantics;
    private final EnumSet<SyntaxConstraint> satisfied;
    private final EnumSet<Semantics> semantics;
    private final Status status;
    private final IRI iri;

    public AbstractBaseTestCase(OWLOntology ontology, OWLNamedIndividual i) {
        Collection notspecies;
        Collection species;
        Collection statuses;
        this.iri = i.getIRI();
        Map dpValues = EntitySearcher.getDataPropertyValues((OWLIndividual)i, (OWLOntology)ontology).asMap();
        Collection identifiers = (Collection)dpValues.get(TestVocabulary.DatatypeProperty.IDENTIFIER.getOWLDataProperty());
        if (identifiers == null) {
            throw new NullPointerException();
        }
        if (identifiers.size() != 1) {
            throw new IllegalArgumentException();
        }
        this.identifier = ((OWLLiteral)identifiers.iterator().next()).getLiteral();
        Map opValues = EntitySearcher.getObjectPropertyValues((OWLIndividual)i, (OWLOntology)ontology).asMap();
        this.imports = new HashMap<IRI, ImportedOntology>();
        Collection importedOntologies = (Collection)opValues.get(TestVocabulary.ObjectProperty.IMPORTED_ONTOLOGY.getOWLObjectProperty());
        if (importedOntologies != null) {
            for (OWLIndividual ind : importedOntologies) {
                ImportedOntologyImpl io = new ImportedOntologyImpl(ontology, ind.asOWLNamedIndividual());
                this.imports.put(io.getIRI(), io);
            }
        }
        if ((statuses = (Collection)opValues.get(TestVocabulary.ObjectProperty.STATUS.getOWLObjectProperty())) == null || statuses.isEmpty()) {
            this.status = null;
        } else {
            if (statuses.size() > 1) {
                throw new IllegalArgumentException();
            }
            OWLNamedIndividual s = ((OWLIndividual)statuses.iterator().next()).asOWLNamedIndividual();
            this.status = Status.get((OWLIndividual)s);
            if (this.status == null) {
                throw new NullPointerException(String.format("Unexpected status ( %s ) for test case %s", s.getIRI().toURI().toASCIIString(), i.getIRI()));
            }
        }
        this.satisfied = EnumSet.noneOf(SyntaxConstraint.class);
        Collection profiles = (Collection)opValues.get(TestVocabulary.ObjectProperty.PROFILE.getOWLObjectProperty());
        if (profiles != null) {
            for (Object p : profiles) {
                SyntaxConstraint c = SyntaxConstraint.get((OWLIndividual)p);
                if (c == null) {
                    throw new NullPointerException(String.format("Unexpected profile ( %s ) for test case %s", p.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
                }
                this.satisfied.add(c);
            }
        }
        if ((species = (Collection)opValues.get(TestVocabulary.ObjectProperty.SPECIES.getOWLObjectProperty())) != null) {
            for (Object s : species) {
                if (TestVocabulary.Individual.FULL.getOWLIndividual().equals(s)) continue;
                if (TestVocabulary.Individual.DL.getOWLIndividual().equals(s)) {
                    this.satisfied.add(SyntaxConstraint.DL);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unexpected species ( %s ) for test case %s", s.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
            }
        }
        this.semantics = EnumSet.noneOf(Semantics.class);
        Collection sems = (Collection)opValues.get(TestVocabulary.ObjectProperty.SEMANTICS.getOWLObjectProperty());
        if (sems != null) {
            for (OWLIndividual sem : sems) {
                Object s = Semantics.get(sem);
                if (s == null) {
                    throw new NullPointerException(String.format("Unexpected semantics ( %s ) for test case %s ", sem.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
                }
                this.semantics.add((Semantics)((Object)s));
            }
        }
        Map nopValues = EntitySearcher.getNegativeObjectPropertyValues((OWLIndividual)i, (OWLOntology)ontology).asMap();
        this.notsatisfied = EnumSet.noneOf(SyntaxConstraint.class);
        Collection notprofiles = (Collection)nopValues.get(TestVocabulary.ObjectProperty.PROFILE.getOWLObjectProperty());
        if (notprofiles != null) {
            for (Object p : notprofiles) {
                SyntaxConstraint c = SyntaxConstraint.get((OWLIndividual)p);
                if (c == null) {
                    throw new NullPointerException(String.format("Unexpected profile ( %s ) for test case %s", p.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
                }
                this.notsatisfied.add(c);
            }
        }
        if ((notspecies = (Collection)nopValues.get(TestVocabulary.ObjectProperty.SPECIES.getOWLObjectProperty())) != null) {
            for (OWLIndividual s : notspecies) {
                if (TestVocabulary.Individual.DL.getOWLIndividual().equals(s)) {
                    this.notsatisfied.add(SyntaxConstraint.DL);
                    continue;
                }
                throw new IllegalArgumentException(String.format("Unexpected species ( %s ) for test case %s", s.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
            }
        }
        this.notsemantics = EnumSet.noneOf(Semantics.class);
        Collection notsems = (Collection)nopValues.get(TestVocabulary.ObjectProperty.SEMANTICS.getOWLObjectProperty());
        if (notsems != null) {
            for (OWLIndividual sem : notsems) {
                Semantics s = Semantics.get(sem);
                if (s == null) {
                    throw new NullPointerException(String.format("Unexpected semantics ( %s ) for test case %s", sem.asOWLNamedIndividual().getIRI().toURI().toASCIIString(), i.getIRI()));
                }
                this.notsemantics.add(s);
            }
        }
    }

    @Override
    public void dispose() {
        this.imports.clear();
        this.notsatisfied.clear();
        this.semantics.clear();
    }

    @Override
    public Set<Semantics> getApplicableSemantics() {
        return Collections.unmodifiableSet(this.semantics);
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public String getImportedOntology(IRI iri, SerializationFormat format) {
        ImportedOntology io = this.imports.get(iri);
        if (io == null) {
            return null;
        }
        return io.getOntology(format);
    }

    @Override
    public Set<IRI> getImportedOntologies() {
        return Collections.unmodifiableSet(this.imports.keySet());
    }

    @Override
    public Set<SerializationFormat> getImportedOntologyFormats(IRI iri) {
        ImportedOntology io = this.imports.get(iri);
        if (io == null) {
            return EnumSet.noneOf(SerializationFormat.class);
        }
        return io.getFormats();
    }

    @Override
    public Set<Semantics> getNotApplicableSemantics() {
        return Collections.unmodifiableSet(this.notsemantics);
    }

    @Override
    public Set<SyntaxConstraint> getSatisfiedConstraints() {
        return Collections.unmodifiableSet(this.satisfied);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Set<SyntaxConstraint> getUnsatisfiedConstraints() {
        return Collections.unmodifiableSet(this.notsatisfied);
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }
}

