/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.cli;

import com.clarkparsia.owlwg.testcase.Semantics;
import com.clarkparsia.owlwg.testcase.SyntaxConstraint;
import com.clarkparsia.owlwg.testcase.filter.ConjunctionFilter;
import com.clarkparsia.owlwg.testcase.filter.DisjunctionFilter;
import com.clarkparsia.owlwg.testcase.filter.FilterCondition;
import com.clarkparsia.owlwg.testcase.filter.NegationFilter;
import com.clarkparsia.owlwg.testcase.filter.SatisfiedSyntaxConstraintFilter;
import com.clarkparsia.owlwg.testcase.filter.SemanticsFilter;
import com.clarkparsia.owlwg.testcase.filter.StatusFilter;
import com.clarkparsia.owlwg.testcase.filter.UnsatisfiedSyntaxConstraintFilter;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilterConditionParser {
    private static final Logger log = Logger.getLogger(FilterConditionParser.class.getCanonicalName());

    public static FilterCondition parse(String filterString) {
        LinkedList<FilterCondition> filterStack = new LinkedList<FilterCondition>();
        String[] splits = filterString.split("\\s");
        for (int i = 0; i < splits.length; ++i) {
            if (splits[i].equalsIgnoreCase("and")) {
                ConjunctionFilter and = ConjunctionFilter.and(filterStack);
                filterStack.clear();
                filterStack.add(and);
                continue;
            }
            if (splits[i].equalsIgnoreCase("approved")) {
                filterStack.add(StatusFilter.APPROVED);
                continue;
            }
            if (splits[i].equalsIgnoreCase("direct")) {
                filterStack.add(new SemanticsFilter(Semantics.DIRECT));
                continue;
            }
            if (splits[i].equalsIgnoreCase("dl")) {
                filterStack.add(SatisfiedSyntaxConstraintFilter.DL);
                continue;
            }
            if (splits[i].equalsIgnoreCase("!dl")) {
                filterStack.add(new UnsatisfiedSyntaxConstraintFilter(SyntaxConstraint.DL));
                continue;
            }
            if (splits[i].equalsIgnoreCase("el")) {
                filterStack.add(SatisfiedSyntaxConstraintFilter.EL);
                continue;
            }
            if (splits[i].equalsIgnoreCase("!el")) {
                filterStack.add(new UnsatisfiedSyntaxConstraintFilter(SyntaxConstraint.EL));
                continue;
            }
            if (splits[i].equalsIgnoreCase("extracredit")) {
                filterStack.add(StatusFilter.EXTRACREDIT);
                continue;
            }
            if (splits[i].equalsIgnoreCase("not")) {
                FilterCondition a = (FilterCondition)filterStack.removeLast();
                filterStack.add(NegationFilter.not(a));
                continue;
            }
            if (splits[i].equalsIgnoreCase("or")) {
                DisjunctionFilter or = DisjunctionFilter.or(filterStack);
                filterStack.clear();
                filterStack.add(or);
                continue;
            }
            if (splits[i].equalsIgnoreCase("proposed")) {
                filterStack.add(StatusFilter.PROPOSED);
                continue;
            }
            if (splits[i].equalsIgnoreCase("ql")) {
                filterStack.add(SatisfiedSyntaxConstraintFilter.QL);
                continue;
            }
            if (splits[i].equalsIgnoreCase("!ql")) {
                filterStack.add(new UnsatisfiedSyntaxConstraintFilter(SyntaxConstraint.QL));
                continue;
            }
            if (splits[i].equalsIgnoreCase("rdf")) {
                filterStack.add(new SemanticsFilter(Semantics.RDF));
                continue;
            }
            if (splits[i].equalsIgnoreCase("rejected")) {
                filterStack.add(StatusFilter.REJECTED);
                continue;
            }
            if (splits[i].equalsIgnoreCase("rl")) {
                filterStack.add(SatisfiedSyntaxConstraintFilter.RL);
                continue;
            }
            if (splits[i].equalsIgnoreCase("!rl")) {
                filterStack.add(new UnsatisfiedSyntaxConstraintFilter(SyntaxConstraint.RL));
                continue;
            }
            String msg = String.format("Unexpected filter condition argument: \"%s\"", splits[i]);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (filterStack.isEmpty()) {
            String msg = String.format("Missing valid filter condition. Filter option argument: \"%s\"", filterString);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        if (filterStack.size() > 1) {
            String msg = String.format("Filter conditions do not parse to a single condition. Final parse stack: \"%s\"", filterStack);
            log.severe(msg);
            throw new IllegalArgumentException(msg);
        }
        FilterCondition filter = (FilterCondition)filterStack.iterator().next();
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("Filter condition: \"%s\"", filter));
        }
        return filter;
    }
}

