/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class BufferingOntologyChangeListener
implements OWLOntologyChangeListener {
    private final Set<OWLAxiom> additions = Sets.newHashSet();
    private final Set<OWLAxiom> removals = Sets.newHashSet();
    private final Set<OWLOntologyID> ontologies;

    public BufferingOntologyChangeListener(Iterable<OWLOntologyID> onts) {
        this.ontologies = Sets.newHashSet(onts);
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changeList) throws OWLException {
        for (OWLOntologyChange oWLOntologyChange : changeList) {
            OWLAxiom axiom;
            if (!this.ontologies.contains(oWLOntologyChange.getOntology().getOntologyID()) || !oWLOntologyChange.isAxiomChange() || (axiom = oWLOntologyChange.getAxiom()).isAnnotationAxiom()) continue;
            if (oWLOntologyChange.isAddAxiom()) {
                this.additions.add(axiom);
                this.removals.remove(axiom);
                continue;
            }
            this.additions.remove(axiom);
            this.removals.add(axiom);
        }
    }

    public boolean isChanged() {
        return !this.getAdditions().isEmpty() || !this.getRemovals().isEmpty();
    }

    public Set<OWLAxiom> getAdditions() {
        return this.additions;
    }

    public Set<OWLAxiom> getRemovals() {
        return this.removals;
    }

    public void reset() {
        this.additions.clear();
        this.removals.clear();
    }
}

