/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import org.mindswap.pellet.PelletOptions;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.FreshEntityPolicy;
import org.semanticweb.owlapi.reasoner.IndividualNodeSetPolicy;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class PelletReasonerConfiguration
implements OWLReasonerConfiguration {
    private ReasonerProgressMonitor progressMonitor = new NullReasonerProgressMonitor();
    private FreshEntityPolicy freshEntityPolicy = PelletOptions.SILENT_UNDEFINED_ENTITY_HANDLING ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    private IndividualNodeSetPolicy individualNodeSetPolicy = IndividualNodeSetPolicy.BY_SAME_AS;
    private long timeOut = 0L;
    private BufferingMode bufferingMode = BufferingMode.BUFFERING;
    private OWLOntologyManager manager = null;
    private boolean listenChanges = true;

    public PelletReasonerConfiguration() {
    }

    public PelletReasonerConfiguration(OWLReasonerConfiguration source) {
        this.progressMonitor = source.getProgressMonitor();
        this.freshEntityPolicy = source.getFreshEntityPolicy();
        this.individualNodeSetPolicy = source.getIndividualNodeSetPolicy();
        this.timeOut = source.getTimeOut();
    }

    public ReasonerProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public PelletReasonerConfiguration progressMonitor(ReasonerProgressMonitor theProgressMonitor) {
        this.progressMonitor = theProgressMonitor;
        return this;
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.freshEntityPolicy;
    }

    public PelletReasonerConfiguration freshEntityPolicy(FreshEntityPolicy theFreshEntityPolicy) {
        this.freshEntityPolicy = theFreshEntityPolicy;
        return this;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.individualNodeSetPolicy;
    }

    public PelletReasonerConfiguration individualNodeSetPolicy(IndividualNodeSetPolicy theIndividualNodeSetPolicy) {
        this.individualNodeSetPolicy = theIndividualNodeSetPolicy;
        return this;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public PelletReasonerConfiguration timeout(long theTimeOut) {
        this.timeOut = theTimeOut;
        return this;
    }

    public BufferingMode getBufferingMode() {
        return this.bufferingMode;
    }

    public PelletReasonerConfiguration buffering(BufferingMode theBufferingMode) {
        this.bufferingMode = theBufferingMode;
        return this;
    }

    public PelletReasonerConfiguration buffering(boolean isBuffering) {
        return this.buffering(isBuffering ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING);
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public PelletReasonerConfiguration manager(OWLOntologyManager theManager) {
        this.manager = theManager;
        return this;
    }

    public boolean isListenChanges() {
        return this.listenChanges;
    }

    public PelletReasonerConfiguration listenChanges(boolean isListenChanges) {
        this.listenChanges = isListenChanges;
        return this;
    }

    public PelletReasoner createReasoner(OWLOntology ont) {
        return new PelletReasoner(ont, this);
    }
}

