/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testrun;

import com.clarkparsia.owlwg.runner.TestRunner;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testrun.AbstractRun;
import com.clarkparsia.owlwg.testrun.RunResultType;
import com.clarkparsia.owlwg.testrun.RunTestType;
import com.clarkparsia.owlwg.testrun.TestRunResultVisitor;
import java.util.EnumSet;

public class ReasoningRun
extends AbstractRun {
    public ReasoningRun(TestCase testcase, RunResultType resultType, RunTestType testType, TestRunner runner) {
        this(testcase, resultType, testType, runner, null, null);
    }

    public ReasoningRun(TestCase testcase, RunResultType resultType, RunTestType testType, TestRunner runner, String details) {
        this(testcase, resultType, testType, runner, details, null);
    }

    public ReasoningRun(TestCase testcase, RunResultType resultType, RunTestType testType, TestRunner runner, String details, Throwable cause) {
        super(testcase, resultType, testType, runner, details, cause);
        if (!EnumSet.of(RunTestType.CONSISTENCY, RunTestType.INCONSISTENCY, RunTestType.NEGATIVE_ENTAILMENT, RunTestType.POSITIVE_ENTAILMENT).contains((Object)testType)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void accept(TestRunResultVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        String details = this.getDetails();
        if (details == null) {
            return String.format("Result( %s , %s, %s)", new Object[]{this.getTestCase(), this.getResultType(), this.getTestType()});
        }
        return String.format("Result( %s , %s, %s (%s))", new Object[]{this.getTestCase(), this.getResultType(), this.getTestType(), details});
    }
}

