/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.testcase.filter;

import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.filter.FilterCondition;
import java.util.Arrays;
import java.util.Collection;

public class DisjunctionFilter
implements FilterCondition {
    private final FilterCondition[] conditions;

    public static DisjunctionFilter or(Collection<? extends FilterCondition> conditions) {
        return new DisjunctionFilter(conditions);
    }

    public static DisjunctionFilter or(FilterCondition ... conditions) {
        return DisjunctionFilter.or(Arrays.asList(conditions));
    }

    public DisjunctionFilter(Collection<? extends FilterCondition> conditions) {
        if (conditions == null) {
            throw new NullPointerException();
        }
        this.conditions = conditions.toArray(new FilterCondition[0]);
    }

    public DisjunctionFilter(FilterCondition ... conditions) {
        int n = conditions.length;
        this.conditions = new FilterCondition[n];
        System.arraycopy(conditions, 0, this.conditions, 0, n);
    }

    @Override
    public boolean accepts(TestCase testcase) {
        for (FilterCondition c : this.conditions) {
            if (!c.accepts(testcase)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.conditions.length; ++i) {
            buf.append(this.conditions[i].toString());
            buf.append(" ");
        }
        buf.append("or");
        return buf.toString();
    }
}

