/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.owlapi3.testcase.impl;

import com.clarkparsia.owlwg.owlapi3.testcase.impl.OwlApi3Case;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import java.util.logging.Logger;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.StringDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class ImportsHelper {
    private static final Logger log = Logger.getLogger(ImportsHelper.class.getCanonicalName());

    public static void loadImports(OWLOntologyManager manager, OwlApi3Case t, SerializationFormat format) throws OWLOntologyCreationException {
        for (IRI iri : t.getImportedOntologies()) {
            if (manager.contains(iri)) continue;
            String str = t.getImportedOntology(iri, format);
            if (str == null) {
                String msg = String.format("Imported ontology (%s) not provided in " + (Object)((Object)format) + " syntax for testcase (%s)", iri, t.getIdentifier());
                log.warning(msg);
                throw new OWLOntologyCreationException(msg);
            }
            StringDocumentSource source = new StringDocumentSource(str, iri);
            try {
                manager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)source);
            }
            catch (OWLOntologyCreationException e) {
                log.warning(String.format("Failed to parse imported ontology for testcase (%s)", t.getIdentifier()));
                throw e;
            }
        }
    }
}

