/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlwg.owlapi3.runner.impl;

import com.clarkparsia.owlwg.owlapi3.testcase.impl.OwlApi3Case;
import com.clarkparsia.owlwg.runner.TestRunner;
import com.clarkparsia.owlwg.testcase.ConsistencyTest;
import com.clarkparsia.owlwg.testcase.EntailmentTest;
import com.clarkparsia.owlwg.testcase.InconsistencyTest;
import com.clarkparsia.owlwg.testcase.NegativeEntailmentTest;
import com.clarkparsia.owlwg.testcase.OntologyParseException;
import com.clarkparsia.owlwg.testcase.PositiveEntailmentTest;
import com.clarkparsia.owlwg.testcase.PremisedTest;
import com.clarkparsia.owlwg.testcase.SerializationFormat;
import com.clarkparsia.owlwg.testcase.TestCase;
import com.clarkparsia.owlwg.testcase.TestCaseVisitor;
import com.clarkparsia.owlwg.testrun.ReasoningRun;
import com.clarkparsia.owlwg.testrun.RunResultType;
import com.clarkparsia.owlwg.testrun.RunTestType;
import com.clarkparsia.owlwg.testrun.TestRunResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class OwlApi3AbstractRunner
implements TestRunner<OWLOntology> {
    private static final SerializationFormat[] formatList = new SerializationFormat[]{SerializationFormat.RDFXML, SerializationFormat.FUNCTIONAL, SerializationFormat.OWLXML};
    protected static final Logger log = Logger.getLogger(OwlApi3AbstractRunner.class.getCanonicalName());
    private final Runner runner = new Runner();
    protected long timeout;

    @Override
    public void dispose() {
    }

    protected abstract boolean isConsistent(OWLOntology var1);

    protected abstract boolean isEntailed(OWLOntology var1, OWLOntology var2);

    protected TestRunResult run(TestAsRunnable runnable) {
        Thread t = new Thread(runnable);
        t.start();
        try {
            t.join(this.timeout);
        }
        catch (InterruptedException e) {
            return runnable.getErrorResult(e);
        }
        if (t.isAlive()) {
            try {
                t.stop();
                return runnable.getTimeoutResult();
            }
            catch (OutOfMemoryError oome) {
                log.warning("Out of memory allocating timeout response. Retrying.");
                System.gc();
                return runnable.getTimeoutResult();
            }
        }
        try {
            return runnable.getResult();
        }
        catch (Throwable th) {
            return runnable.getErrorResult(th);
        }
    }

    @Override
    public Collection<TestRunResult> run(TestCase<OWLOntology> testcase, long timeout) {
        this.timeout = timeout;
        if (testcase instanceof OwlApi3Case) {
            return this.runner.getResults((OwlApi3Case)testcase);
        }
        throw new IllegalArgumentException();
    }

    protected TestRunResult runConsistencyTest(PremisedTest<OWLOntology> testcase) {
        return this.run(new XConsistencyTest(testcase, RunTestType.CONSISTENCY));
    }

    protected TestRunResult runEntailmentTest(NegativeEntailmentTest<OWLOntology> testcase) {
        return this.run(new XEntailmentTest(testcase, RunTestType.NEGATIVE_ENTAILMENT));
    }

    protected TestRunResult runEntailmentTest(PositiveEntailmentTest<OWLOntology> testcase) {
        return this.run(new XEntailmentTest(testcase, RunTestType.POSITIVE_ENTAILMENT));
    }

    protected TestRunResult runInconsistencyTest(InconsistencyTest<OWLOntology> testcase) {
        return this.run(new XConsistencyTest(testcase, RunTestType.INCONSISTENCY));
    }

    protected class XEntailmentTest
    extends AbstractTestAsRunnable<EntailmentTest<OWLOntology>> {
        public XEntailmentTest(EntailmentTest<OWLOntology> testcase, RunTestType type) {
            super(OwlApi3AbstractRunner.this, testcase, type);
            if (!EnumSet.of(RunTestType.POSITIVE_ENTAILMENT, RunTestType.NEGATIVE_ENTAILMENT).contains((Object)type)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void run() {
            OWLOntology conclusion;
            OWLOntology premise;
            SerializationFormat pFmt = null;
            SerializationFormat cFmt = null;
            for (SerializationFormat f : formatList) {
                if (!((EntailmentTest)this.testcase).getPremiseFormats().contains((Object)f)) continue;
                pFmt = f;
                break;
            }
            if (pFmt == null) {
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "No acceptable serialization formats found for premise ontology.");
                return;
            }
            for (SerializationFormat f : formatList) {
                if (!((EntailmentTest)this.testcase).getConclusionFormats().contains((Object)f)) continue;
                cFmt = f;
                break;
            }
            if (cFmt == null) {
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "No acceptable serialization formats found for conclusion ontology.");
                return;
            }
            try {
                long parseStart = System.currentTimeMillis();
                premise = (OWLOntology)((EntailmentTest)this.testcase).parsePremiseOntology(pFmt);
                conclusion = (OWLOntology)((EntailmentTest)this.testcase).parseConclusionOntology(cFmt);
                long parseEnd = System.currentTimeMillis();
                System.err.println(((EntailmentTest)this.testcase).getIdentifier() + " parse time " + (parseEnd - parseStart) / 1000L);
            }
            catch (OntologyParseException e) {
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "Exception parsing input ontology: " + e.getLocalizedMessage(), e);
                return;
            }
            try {
                boolean entailed = OwlApi3AbstractRunner.this.isEntailed(premise, conclusion);
                this.result = entailed ? new ReasoningRun(this.testcase, RunTestType.POSITIVE_ENTAILMENT.equals((Object)this.type) ? RunResultType.PASSING : RunResultType.FAILING, this.type, OwlApi3AbstractRunner.this) : new ReasoningRun(this.testcase, RunTestType.NEGATIVE_ENTAILMENT.equals((Object)this.type) ? RunResultType.PASSING : RunResultType.FAILING, this.type, OwlApi3AbstractRunner.this);
            }
            catch (Throwable th) {
                System.gc();
                th.printStackTrace();
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "Caught throwable: " + th.getLocalizedMessage(), th);
            }
        }
    }

    protected class XConsistencyTest
    extends AbstractTestAsRunnable<PremisedTest<OWLOntology>> {
        public XConsistencyTest(PremisedTest<OWLOntology> testcase, RunTestType type) {
            super(OwlApi3AbstractRunner.this, testcase, type);
            if (!EnumSet.of(RunTestType.CONSISTENCY, RunTestType.INCONSISTENCY).contains((Object)type)) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public void run() {
            OWLOntology o;
            SerializationFormat fmt = null;
            for (SerializationFormat f : formatList) {
                if (!((PremisedTest)this.testcase).getPremiseFormats().contains((Object)f)) continue;
                fmt = f;
                break;
            }
            if (fmt == null) {
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "No acceptable serialization formats found for premise ontology.");
                return;
            }
            try {
                long parseStart = System.currentTimeMillis();
                o = (OWLOntology)((PremisedTest)this.testcase).parsePremiseOntology(fmt);
                long parseEnd = System.currentTimeMillis();
                System.err.println(((PremisedTest)this.testcase).getIdentifier() + " parse time " + (parseEnd - parseStart) / 1000L);
            }
            catch (OntologyParseException e) {
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "Exception parsing premise ontology: " + e.getLocalizedMessage(), e);
                return;
            }
            try {
                boolean consistent = OwlApi3AbstractRunner.this.isConsistent(o);
                this.result = consistent ? new ReasoningRun(this.testcase, RunTestType.CONSISTENCY.equals((Object)this.type) ? RunResultType.PASSING : RunResultType.FAILING, this.type, OwlApi3AbstractRunner.this) : new ReasoningRun(this.testcase, RunTestType.INCONSISTENCY.equals((Object)this.type) ? RunResultType.PASSING : RunResultType.FAILING, this.type, OwlApi3AbstractRunner.this);
            }
            catch (Throwable th) {
                th.printStackTrace();
                this.result = new ReasoningRun(this.testcase, RunResultType.INCOMPLETE, this.type, OwlApi3AbstractRunner.this, "Caught throwable: " + th.getLocalizedMessage(), th);
            }
        }
    }

    protected static interface TestAsRunnable
    extends Runnable {
        public TestRunResult getErrorResult(Throwable var1);

        public TestRunResult getResult() throws Throwable;

        public TestRunResult getTimeoutResult();
    }

    private class Runner
    implements TestCaseVisitor<OWLOntology> {
        private TestRunResult[] results;

        private Runner() {
        }

        public List<TestRunResult> getResults(OwlApi3Case testcase) {
            this.results = null;
            testcase.accept(this);
            return Arrays.asList(this.results);
        }

        @Override
        public void visit(ConsistencyTest<OWLOntology> testcase) {
            this.results = new TestRunResult[1];
            this.results[0] = OwlApi3AbstractRunner.this.runConsistencyTest(testcase);
        }

        @Override
        public void visit(InconsistencyTest<OWLOntology> testcase) {
            this.results = new TestRunResult[1];
            this.results[0] = OwlApi3AbstractRunner.this.runInconsistencyTest(testcase);
        }

        @Override
        public void visit(NegativeEntailmentTest<OWLOntology> testcase) {
            this.results = new TestRunResult[2];
            this.results[0] = OwlApi3AbstractRunner.this.runConsistencyTest(testcase);
            this.results[1] = OwlApi3AbstractRunner.this.runEntailmentTest(testcase);
        }

        @Override
        public void visit(PositiveEntailmentTest<OWLOntology> testcase) {
            this.results = new TestRunResult[2];
            this.results[0] = OwlApi3AbstractRunner.this.runConsistencyTest(testcase);
            this.results[1] = OwlApi3AbstractRunner.this.runEntailmentTest(testcase);
        }
    }

    protected static abstract class AbstractTestAsRunnable<T extends TestCase<OWLOntology>>
    implements TestAsRunnable {
        protected TestRunResult result;
        protected final T testcase;
        protected Throwable throwable;
        protected final RunTestType type;
        final /* synthetic */ OwlApi3AbstractRunner this$0;

        public AbstractTestAsRunnable(T testcase, RunTestType type) {
            this.this$0 = this$0;
            this.testcase = testcase;
            if (!EnumSet.of(RunTestType.CONSISTENCY, RunTestType.INCONSISTENCY, RunTestType.NEGATIVE_ENTAILMENT, RunTestType.POSITIVE_ENTAILMENT).contains((Object)type)) {
                throw new IllegalArgumentException();
            }
            this.type = type;
            this.result = null;
            this.throwable = null;
        }

        @Override
        public TestRunResult getErrorResult(Throwable th) {
            th.printStackTrace();
            return new ReasoningRun((TestCase)this.testcase, RunResultType.INCOMPLETE, this.type, this.this$0, th.getMessage(), th);
        }

        @Override
        public TestRunResult getResult() throws Throwable {
            if (this.throwable != null) {
                throw this.throwable;
            }
            if (this.result == null) {
                throw new IllegalStateException();
            }
            return this.result;
        }

        @Override
        public TestRunResult getTimeoutResult() {
            return new ReasoningRun((TestCase)this.testcase, RunResultType.INCOMPLETE, this.type, this.this$0, String.format("Timeout: %s ms", this.this$0.timeout));
        }
    }
}

