/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.AxiomBasedModuleExtractor;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import java.util.Iterator;
import java.util.Set;
import org.mindswap.pellet.utils.iterator.NestedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class ModularityUtils {
    public static Set<OWLAxiom> extractModule(OWLOntology ontology, Set<OWLEntity> signature, ModuleType moduleType) {
        return ModularityUtils.extractModule(ontology.getImportsClosure(), signature, moduleType);
    }

    public static Set<OWLAxiom> extractModule(Set<OWLOntology> ontologies, Set<OWLEntity> signature, ModuleType moduleType) {
        switch (moduleType) {
            case TOP: {
                return ModularityUtils.extractTopModule(ModularityUtils.axiomIterator(ontologies), signature);
            }
            case BOT: {
                return ModularityUtils.extractBottomModule(ModularityUtils.axiomIterator(ontologies), signature);
            }
            case TOP_OF_BOT: {
                Set<OWLAxiom> bottomModule = ModularityUtils.extractBottomModule(ModularityUtils.axiomIterator(ontologies), signature);
                return ModularityUtils.extractTopModule(bottomModule.iterator(), signature);
            }
            case BOT_OF_TOP: {
                Set<OWLAxiom> topModule = ModularityUtils.extractTopModule(ModularityUtils.axiomIterator(ontologies), signature);
                return ModularityUtils.extractBottomModule(topModule.iterator(), signature);
            }
        }
        throw new UnsupportedOperationException("Unrecognized module type: " + moduleType);
    }

    private static Iterator<OWLAxiom> axiomIterator(Set<OWLOntology> ontologies) {
        return new NestedIterator<OWLOntology, OWLAxiom>(ontologies){

            public Iterator<? extends OWLAxiom> getInnerIterator(OWLOntology ont) {
                return ont.getAxioms().iterator();
            }
        };
    }

    private static Set<OWLAxiom> extractTopModule(Iterator<OWLAxiom> axioms, Set<OWLEntity> signature) {
        return ModularityUtils.extractModule(axioms, signature, LocalityClass.TOP_TOP);
    }

    private static Set<OWLAxiom> extractBottomModule(Iterator<OWLAxiom> axioms, Set<OWLEntity> signature) {
        return ModularityUtils.extractModule(axioms, signature, LocalityClass.BOTTOM_BOTTOM);
    }

    private static Set<OWLAxiom> extractModule(Iterator<OWLAxiom> axioms, Set<OWLEntity> signature, LocalityClass localityClass) {
        AxiomBasedModuleExtractor extractor = new AxiomBasedModuleExtractor(localityClass);
        while (axioms.hasNext()) {
            extractor.addAxiom(axioms.next());
        }
        return extractor.extractModule(signature);
    }
}

