/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.GlassBoxExplanation;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.TransactionAwareSingleExpGen;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletExplanation {
    private static final int ALL_EXPLANATIONS = -1;
    private OWLDataFactory factory;
    private HSTExplanationGenerator expGen;
    private SatisfiabilityConverter converter;
    private boolean disposeReasoner = false;

    public static void setup() {
        GlassBoxExplanation.setup();
    }

    public PelletExplanation(OWLOntology ontology) {
        this(ontology, true);
    }

    public PelletExplanation(OWLOntology ontology, boolean useGlassBox) {
        this(new PelletReasonerFactory().createReasoner(ontology), useGlassBox);
        this.disposeReasoner = true;
    }

    public PelletExplanation(PelletReasoner reasoner) {
        this(reasoner, true);
    }

    private PelletExplanation(PelletReasoner reasoner, boolean useGlassBox) {
        this.factory = reasoner.getManager().getOWLDataFactory();
        GlassBoxExplanation singleExp = useGlassBox ? new GlassBoxExplanation(reasoner) : new BlackBoxExplanation(reasoner.getRootOntology(), (OWLReasonerFactory)new PelletReasonerFactory(), (OWLReasoner)reasoner);
        this.expGen = new HSTExplanationGenerator((TransactionAwareSingleExpGen)singleExp);
        this.converter = new SatisfiabilityConverter(this.factory);
    }

    public Set<OWLAxiom> getEntailmentExplanation(OWLAxiom axiom) {
        OWLClassExpression unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom) {
        OWLClassExpression unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getEntailmentExplanations(OWLAxiom axiom, int maxExplanations) {
        OWLClassExpression unsatClass = this.converter.convert(axiom);
        return this.getUnsatisfiableExplanations(unsatClass, maxExplanations);
    }

    public Set<OWLAxiom> getInconsistencyExplanation() {
        return this.getUnsatisfiableExplanation((OWLClassExpression)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations() {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this.factory.getOWLThing());
    }

    public Set<Set<OWLAxiom>> getInconsistencyExplanations(int maxExplanations) {
        return this.getUnsatisfiableExplanations((OWLClassExpression)this.factory.getOWLThing(), maxExplanations);
    }

    public Set<OWLAxiom> getInstanceExplanation(OWLIndividual ind, OWLClassExpression cls) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanation((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLClassExpression cls) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion);
    }

    public Set<Set<OWLAxiom>> getInstanceExplanations(OWLIndividual ind, OWLClassExpression cls, int maxExplanations) {
        OWLClassAssertionAxiom classAssertion = this.factory.getOWLClassAssertionAxiom(cls, ind);
        return this.getEntailmentExplanations((OWLAxiom)classAssertion, maxExplanations);
    }

    public Set<OWLAxiom> getSubClassExplanation(OWLClassExpression subClass, OWLClassExpression superClass) {
        OWLSubClassOfAxiom subClassAxiom = this.factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanation((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression subClass, OWLClassExpression superClass) {
        OWLSubClassOfAxiom subClassAxiom = this.factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom);
    }

    public Set<Set<OWLAxiom>> getSubClassExplanations(OWLClassExpression subClass, OWLClassExpression superClass, int maxExplanations) {
        OWLSubClassOfAxiom subClassAxiom = this.factory.getOWLSubClassOfAxiom(subClass, superClass);
        return this.getEntailmentExplanations((OWLAxiom)subClassAxiom, maxExplanations);
    }

    public Set<OWLAxiom> getUnsatisfiableExplanation(OWLClassExpression unsatClass) {
        return this.expGen.getExplanation(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression unsatClass) {
        return this.expGen.getExplanations(unsatClass);
    }

    public Set<Set<OWLAxiom>> getUnsatisfiableExplanations(OWLClassExpression unsatClass, int maxExplanations) {
        if (maxExplanations == -1) {
            return this.expGen.getExplanations(unsatClass);
        }
        return this.expGen.getExplanations(unsatClass, maxExplanations);
    }

    public void dispose() {
        if (this.disposeReasoner) {
            this.expGen.getReasoner().dispose();
        }
        this.expGen.dispose();
    }

    static {
        PelletExplanation.setup();
    }
}

