/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class SPARQLDLExample {
    private static final String ontology = "data/university0-0.owl";
    private static final String[] queries = new String[]{"data/lubm-query4.sparql", "data/lubm-sparql-dl.sparql", "data/lubm-sparql-dl-extvoc.sparql"};

    public void run() {
        for (int i = 0; i < queries.length; ++i) {
            String query = queries[i];
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            m.read(ontology);
            Query q = QueryFactory.read((String)query);
            QueryExecution qe = SparqlDLExecutionFactory.create((Query)q, (Model)m);
            ResultSet rs = qe.execSelect();
            System.out.println(q.toString());
            ResultSetFormatter.out((ResultSet)rs);
            System.out.println();
        }
    }

    public static void main(String[] args) {
        SPARQLDLExample app = new SPARQLDLExample();
        app.run();
    }
}

