/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class RulesExample {
    public static void main(String[] args) {
        String ont = "http://owldl.com/ontologies/dl-safe.owl";
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC, null);
        model.read(ont);
        ObjectProperty sibling = model.getObjectProperty(ont + "#sibling");
        OntClass BadChild = model.getOntClass(ont + "#BadChild");
        OntClass Child = model.getOntClass(ont + "#Child");
        Individual Abel = model.getIndividual(ont + "#Abel");
        Individual Cain = model.getIndividual(ont + "#Cain");
        Individual Remus = model.getIndividual(ont + "#Remus");
        Individual Romulus = model.getIndividual(ont + "#Romulus");
        model.prepare();
        RulesExample.printPropertyValues(Cain, (Property)sibling);
        RulesExample.printPropertyValues(Abel, (Property)sibling);
        RulesExample.printPropertyValues(Remus, (Property)sibling);
        RulesExample.printPropertyValues(Romulus, (Property)sibling);
        RulesExample.printInstances(BadChild);
        RulesExample.printInstances(Child);
    }

    public static void printPropertyValues(Individual ind, Property prop) {
        System.out.print(ind.getLocalName() + " has " + prop.getLocalName() + "(s): ");
        RulesExample.printIterator((ExtendedIterator)ind.listPropertyValues(prop));
    }

    public static void printInstances(OntClass cls) {
        System.out.print(cls.getLocalName() + " instances: ");
        RulesExample.printIterator(cls.listInstances());
    }

    public static void printIterator(ExtendedIterator i) {
        if (!i.hasNext()) {
            System.out.print("none");
        } else {
            while (i.hasNext()) {
                Resource val = (Resource)i.next();
                System.out.print(val.getLocalName());
                if (!i.hasNext()) continue;
                System.out.print(", ");
            }
        }
        System.out.println();
    }
}

