/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import aterm.ATermAppl;
import com.clarkparsia.pellet.sparqldl.engine.QuerySubsumption;
import com.clarkparsia.pellet.sparqldl.model.Query;
import com.clarkparsia.pellet.sparqldl.model.QueryResult;
import com.clarkparsia.pellet.sparqldl.model.ResultBinding;
import com.clarkparsia.pellet.sparqldl.parser.ARQParser;
import com.clarkparsia.pellet.sparqldl.parser.QueryParser;
import java.util.Iterator;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.ModelFactory;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class QuerySubsumptionExample {
    String ont = "http://owldl.com/ontologies/family.owl";
    String family = "http://www.example.org/family#";
    String prefix = "PREFIX rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\r\nPREFIX family: <" + this.family + ">\r\n" + "SELECT * { ";
    String suffix = " }";
    KnowledgeBase kb;
    QueryParser parser;

    public static void main(String[] args) throws Exception {
        new QuerySubsumptionExample().run();
    }

    public QuerySubsumptionExample() {
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(this.ont);
        model.prepare();
        this.kb = ((PelletInfGraph)model.getGraph()).getKB();
        this.parser = new ARQParser();
    }

    public Query query(String queryStr) {
        return this.parser.parse(this.prefix + queryStr + this.suffix, this.kb);
    }

    public void run() {
        this.example1();
        this.example2();
        this.example3();
        this.example4();
    }

    public void example1() {
        Query q1 = this.query("?x a family:Male .");
        Query q2 = this.query("?x a family:Person .");
        System.out.println("Example 1");
        System.out.println("=========");
        System.out.println("Query 1: " + q1.toString());
        System.out.println("Query 2: " + q2.toString());
        System.out.println();
        System.out.println("Query 1 is subsumed by query 2: " + QuerySubsumption.isSubsumedBy((Query)q1, (Query)q2));
        System.out.println("Query 2 is subsumed by query 1: " + QuerySubsumption.isSubsumedBy((Query)q2, (Query)q1));
        System.out.println();
    }

    public void example2() {
        Query q3 = this.query("?x family:isMarriedTo ?y . ?y rdf:type family:Male");
        Query q4 = this.query("?x a family:Female .");
        System.out.println("Example 2");
        System.out.println("=========");
        System.out.println("Query 3: " + q3.toString());
        System.out.println("Query 4: " + q4.toString());
        System.out.println();
        System.out.println("Query 3 is subsumed by query 4: " + QuerySubsumption.isSubsumedBy((Query)q3, (Query)q4));
        System.out.println("Query 4 is subsumed by query 3: " + QuerySubsumption.isSubsumedBy((Query)q4, (Query)q3));
        System.out.println();
    }

    public void example3() {
        Query q5 = this.query("?x family:hasFather ?y . ");
        Query q6 = this.query("?x family:hasParent ?y . ?y a family:Male .");
        System.out.println("Example 3");
        System.out.println("=========");
        System.out.println("Query 5: " + q5.toString());
        System.out.println("Query 6: " + q6.toString());
        System.out.println();
        System.out.println("Query 5 is subsumed by query 6: " + QuerySubsumption.isSubsumedBy((Query)q5, (Query)q6));
        System.out.println("Query 6 is subsumed by query 5: " + QuerySubsumption.isSubsumedBy((Query)q5, (Query)q6));
        System.out.println("Query 5 is equivalent to query 6: " + QuerySubsumption.isEquivalentTo((Query)q5, (Query)q6));
        System.out.println();
    }

    public void example4() {
        Query q7 = this.query("?x a family:Female; family:hasBrother ?y . ");
        Query q8 = this.query("?x a family:Female; family:hasSibling ?z .");
        System.out.println("Example 4");
        System.out.println("=========");
        System.out.println("Query 7: " + q7.toString());
        System.out.println("Query 8: " + q8.toString());
        System.out.println();
        System.out.println("Query 7 is subsumed by query 8: " + QuerySubsumption.isSubsumedBy((Query)q7, (Query)q8));
        System.out.print("Subsumption mappings: ");
        QueryResult mappings = QuerySubsumption.getSubsumptionMappings((Query)q7, (Query)q8);
        for (ResultBinding mapping : mappings) {
            Iterator j = q8.getVars().iterator();
            while (j.hasNext()) {
                ATermAppl var = (ATermAppl)j.next();
                System.out.print(var.getArgument(0) + " -> " + mapping.getValue(var));
                if (!j.hasNext()) continue;
                System.out.print(", ");
            }
        }
        System.out.println();
    }
}

