/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class ClassTree {
    OntModel model;
    Set<OntResource> unsatConcepts;
    TreeCellRenderer treeCellRenderer = new DefaultTreeCellRenderer(){

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Set set = (Set)node.getUserObject();
            StringBuffer label = new StringBuffer();
            if (set.size() > 1) {
                label.append("[");
            }
            Iterator i = set.iterator();
            OntResource first = (OntResource)i.next();
            label.append(ClassTree.this.model.shortForm(first.getURI()));
            while (i.hasNext()) {
                OntResource c = (OntResource)i.next();
                label.append(" = ");
                label.append(ClassTree.this.model.shortForm(c.getURI()));
            }
            if (set.size() > 1) {
                label.append("]");
            }
            if (ClassTree.this.unsatConcepts.contains(first)) {
                this.setForeground(Color.RED);
            }
            this.setText(label.toString());
            this.setIcon(this.getDefaultClosedIcon());
            return this;
        }
    };

    public ClassTree(String ontology) throws Exception {
        this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        System.out.print("Reading...");
        this.model.read(ontology);
        System.out.println("done");
        System.out.print("Preparing...");
        this.model.prepare();
        System.out.println("done");
        System.out.print("Classifying...");
        ((PelletInfGraph)this.model.getGraph()).getKB().classify();
        System.out.println("done");
    }

    public Set<OntResource> collect(Iterator i) {
        HashSet<OntResource> set = new HashSet<OntResource>();
        while (i.hasNext()) {
            OntResource res = (OntResource)i.next();
            if (res.isAnon()) continue;
            set.add(res);
        }
        return set;
    }

    public JTree getJTree() {
        OntClass owlThing = this.model.getOntClass(OWL.Thing.getURI());
        OntClass owlNothing = this.model.getOntClass(OWL.Nothing.getURI());
        this.unsatConcepts = this.collect((Iterator)owlNothing.listEquivalentClasses());
        DefaultMutableTreeNode thing = this.createTree(owlThing);
        Iterator<OntResource> i = this.unsatConcepts.iterator();
        if (i.hasNext()) {
            DefaultMutableTreeNode nothing = this.createSingletonNode((OntResource)owlNothing);
            while (i.hasNext()) {
                OntClass unsat = (OntClass)i.next();
                if (unsat.equals(owlNothing)) continue;
                DefaultMutableTreeNode node = this.createSingletonNode((OntResource)unsat);
                nothing.add(node);
            }
            thing.add(nothing);
        }
        JTree classTree = new JTree(new DefaultTreeModel(thing));
        classTree.setCellRenderer(this.treeCellRenderer);
        for (int r = 0; r < classTree.getRowCount(); ++r) {
            classTree.expandRow(r);
        }
        return classTree;
    }

    DefaultMutableTreeNode createTree(OntClass cls) {
        if (this.unsatConcepts.contains(cls)) {
            return null;
        }
        DefaultMutableTreeNode root = this.createNode(cls);
        HashSet processedSubs = new HashSet();
        ExtendedIterator subs = cls.listSubClasses(true);
        while (subs.hasNext()) {
            DefaultMutableTreeNode node;
            OntClass sub = (OntClass)subs.next();
            if (sub.isAnon() || processedSubs.contains(sub) || (node = this.createTree(sub)) == null) continue;
            root.add(node);
            processedSubs.addAll((Set)node.getUserObject());
        }
        return root;
    }

    DefaultMutableTreeNode createSingletonNode(OntResource cls) {
        return new DefaultMutableTreeNode(Collections.singleton(cls));
    }

    DefaultMutableTreeNode createNode(OntClass cls) {
        Set<OntResource> eqs = this.collect((Iterator)cls.listEquivalentClasses());
        return new DefaultMutableTreeNode(eqs);
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("ERROR: No ontology URI given!");
            System.out.println("");
            System.out.println("usage: java ClassTree <ontology URI>");
            System.exit(0);
        }
        ClassTree tree = new ClassTree(args[0]);
        JFrame frame = new JFrame("Ontology Hierarchy");
        frame.getContentPane().add(new JScrollPane(tree.getJTree()));
        frame.setSize(800, 600);
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
    }
}

