/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.pellet.sparqldl.jena.SparqlDLExecutionFactory;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class SPARQLDLExample {
    private static final String ontology = "file:examples/data/university0-0.owl";
    private static final String[] queries = new String[]{"file:examples/data/lubm-query4.sparql", "file:examples/data/lubm-sparql-dl.sparql", "file:examples/data/lubm-sparql-dl-extvoc.sparql"};

    public void run() {
        for (int i = 0; i < queries.length; ++i) {
            String query = queries[i];
            OntModel m = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
            m.read(ontology);
            Query q = QueryFactory.read((String)query);
            QueryExecution qe = SparqlDLExecutionFactory.create((Query)q, (Model)m);
            ResultSet rs = qe.execSelect();
            System.out.println(q.toString());
            ResultSetFormatter.out((ResultSet)rs);
            System.out.println();
        }
    }

    public static void main(String[] args) {
        SPARQLDLExample app = new SPARQLDLExample();
        app.run();
    }
}

