/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.modularity.IncrementalClassifier;
import com.clarkparsia.modularity.io.IncrementalClassifierPersistence;
import com.clarkparsia.owlapiv3.OWL;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class PersistenceExample {
    private static final String file = "file:examples/data/simple-galen.owl";
    private static final String persistenceFile = "incrementalClassifierData.zip";
    private static final String NS = "http://www.co-ode.org/ontologies/galen#";

    public void run() throws OWLOntologyCreationException {
        OWLOntology ontology = OWL.manager.loadOntology(IRI.create((String)file));
        IncrementalClassifier classifier = new IncrementalClassifier(ontology);
        classifier.classify();
        try {
            System.out.print("Saving the state of the classifier to the file ... ");
            System.out.flush();
            FileOutputStream outputStream = new FileOutputStream(persistenceFile);
            IncrementalClassifierPersistence.save((IncrementalClassifier)classifier, (OutputStream)outputStream);
            outputStream.close();
            System.out.println("done.");
        }
        catch (IOException e) {
            System.out.println("I/O Error occurred while saving the current state of the incremental classifier: " + e);
            System.exit(1);
        }
        OWLClass headache = OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Headache");
        OWLClass pain = OWL.Class((String)"http://www.co-ode.org/ontologies/galen#Pain");
        OWLSubClassOfAxiom axiom = OWL.subClassOf((OWLClassExpression)headache, (OWLClassExpression)pain);
        OWL.manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)axiom));
        IncrementalClassifier restoredClassifier = null;
        try {
            System.out.print("Reading the state of the classifier back from the file ... ");
            System.out.flush();
            FileInputStream inputStream = new FileInputStream(persistenceFile);
            restoredClassifier = IncrementalClassifierPersistence.load((InputStream)inputStream, (OWLOntology)ontology);
            inputStream.close();
            System.out.println("done.");
        }
        catch (IOException e) {
            System.out.println("I/O Error occurred while reading the current state of the incremental classifier: " + e);
            System.exit(1);
        }
        System.out.println("[Original classifier] Subclasses of " + pain + ": " + classifier.getSubClasses((OWLClassExpression)pain, true).getFlattened() + "\n");
        System.out.println("[Restored classifier] Subclasses of " + pain + ": " + restoredClassifier.getSubClasses((OWLClassExpression)pain, true).getFlattened() + "\n");
        File fileToDelete = new File(persistenceFile);
        fileToDelete.delete();
    }

    public static void main(String[] args) throws OWLOntologyCreationException {
        PersistenceExample app = new PersistenceExample();
        app.run();
    }
}

