/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class OWLAPIExample {
    public static final void main(String[] args) throws Exception {
        String file = "http://www.mindswap.org/2004/owl/mindswappers#";
        System.out.print("Reading file " + file + "...");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLOntology ontology = manager.loadOntology(IRI.create((String)file));
        PelletReasoner reasoner = PelletReasonerFactory.getInstance().createReasoner(ontology);
        System.out.println("done.");
        reasoner.getKB().realize();
        reasoner.getKB().printClassTree();
        OWLClass Person = manager.getOWLDataFactory().getOWLClass(IRI.create((String)"http://xmlns.com/foaf/0.1/Person"));
        OWLObjectProperty workHomepage = manager.getOWLDataFactory().getOWLObjectProperty(IRI.create((String)"http://xmlns.com/foaf/0.1/workInfoHomepage"));
        OWLDataProperty foafName = manager.getOWLDataFactory().getOWLDataProperty(IRI.create((String)"http://xmlns.com/foaf/0.1/name"));
        NodeSet individuals = reasoner.getInstances((OWLClassExpression)Person, false);
        for (Node sameInd : individuals) {
            OWLNamedIndividual ind = (OWLNamedIndividual)sameInd.getRepresentativeElement();
            Set names = reasoner.getDataPropertyValues(ind, foafName);
            NodeSet types = reasoner.getTypes(ind, true);
            NodeSet homepages = reasoner.getObjectPropertyValues(ind, (OWLObjectPropertyExpression)workHomepage);
            String name = ((OWLLiteral)names.iterator().next()).getLiteral();
            System.out.println("Name: " + name);
            OWLClass type = (OWLClass)((Node)types.iterator().next()).getRepresentativeElement();
            System.out.println("Type:" + type);
            if (homepages.isEmpty()) {
                System.out.print("Homepage: Unknown");
            } else {
                System.out.print("Homepage:");
                for (Node homepage : homepages) {
                    System.out.print(" " + ((OWLNamedIndividual)homepage.getRepresentativeElement()).getIRI());
                }
            }
            System.out.println();
            System.out.println();
        }
    }
}

