/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.examples;

import aterm.ATermAppl;
import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.examples.JenaReasoner;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;
import org.mindswap.pellet.utils.ATermUtils;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class IncrementalConsistencyExample {
    static final String foaf = "http://xmlns.com/foaf/0.1/";
    static final String mindswap = "http://www.mindswap.org/2003/owl/mindswap#";
    static final String mindswappers = "http://www.mindswap.org/2004/owl/mindswappers#";

    public static void main(String[] args) throws Exception {
        PelletOptions.USE_COMPLETION_QUEUE = true;
        PelletOptions.USE_INCREMENTAL_CONSISTENCY = true;
        PelletOptions.USE_SMART_RESTORE = false;
        IncrementalConsistencyExample.runWithPelletAPI();
        IncrementalConsistencyExample.runWithOWLAPI();
        IncrementalConsistencyExample.runWithJenaAPIAndPelletInfGraph();
        IncrementalConsistencyExample.runWithJenaAPIAndOntModel();
    }

    public static void runWithPelletAPI() {
        System.out.println("\nResults after applying changes through Pellet API");
        System.out.println("-------------------------------------------------");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.read(mindswappers);
        model.prepare();
        KnowledgeBase kb = ((PelletInfGraph)model.getGraph()).getKB();
        long s = System.currentTimeMillis();
        boolean consistent = kb.isConsistent();
        long e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        ATermAppl concept = ATermUtils.makeTermAppl((String)"http://www.mindswap.org/2003/owl/mindswap#GraduateStudent");
        ATermAppl individual = ATermUtils.makeTermAppl((String)"http://www.mindswap.org/2004/owl/mindswappers#JohnDoe");
        kb.addIndividual(individual);
        kb.addType(individual, concept);
        s = System.currentTimeMillis();
        consistent = kb.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        ATermAppl role = ATermUtils.makeTermAppl((String)"http://xmlns.com/foaf/0.1/mbox");
        individual = ATermUtils.makeTermAppl((String)"http://www.mindswap.org/2004/owl/mindswappers#Christian.Halaschek");
        ATermAppl mbox = ATermUtils.makeTermAppl((String)"mailto:kolovski@cs.umd.edu");
        kb.addPropertyValue(role, individual, mbox);
        s = System.currentTimeMillis();
        consistent = kb.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
    }

    public static void runWithOWLAPI() throws Exception {
        System.out.println("\nResults after applying changes through OWL API");
        System.out.println("----------------------------------------------");
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        OWLDataFactory factory = manager.getOWLDataFactory();
        OWLOntology ontology = manager.loadOntology(IRI.create((String)mindswappers));
        PelletReasoner reasoner = com.clarkparsia.pellet.owlapiv3.PelletReasonerFactory.getInstance().createNonBufferingReasoner(ontology);
        manager.addOntologyChangeListener((OWLOntologyChangeListener)reasoner);
        long s = System.currentTimeMillis();
        boolean consistent = reasoner.isConsistent();
        long e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        OWLClass concept = factory.getOWLClass(IRI.create((String)"http://www.mindswap.org/2003/owl/mindswap#GraduateStudent"));
        OWLNamedIndividual individual = factory.getOWLNamedIndividual(IRI.create((String)"http://www.mindswap.org/2004/owl/mindswappers#JohnDoe"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)factory.getOWLClassAssertionAxiom((OWLClassExpression)concept, (OWLIndividual)individual)));
        s = System.currentTimeMillis();
        consistent = reasoner.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        OWLObjectProperty role = factory.getOWLObjectProperty(IRI.create((String)"http://xmlns.com/foaf/0.1/mbox"));
        individual = factory.getOWLNamedIndividual(IRI.create((String)"http://www.mindswap.org/2004/owl/mindswappers#Christian.Halaschek"));
        OWLNamedIndividual mbox = factory.getOWLNamedIndividual(IRI.create((String)"mailto:kolovski@cs.umd.edu"));
        manager.applyChange((OWLOntologyChange)new AddAxiom(ontology, (OWLAxiom)factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)role, (OWLIndividual)individual, (OWLIndividual)mbox)));
        s = System.currentTimeMillis();
        consistent = reasoner.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
    }

    public static void runWithJenaAPIAndPelletInfGraph() {
        System.out.println("\nResults after applying changes through Jena API using PelletInfGraph");
        System.out.println("-------------------------------------------------");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        model.read(mindswappers);
        PelletInfGraph pelletJenaGraph = (PelletInfGraph)model.getGraph();
        long s = System.currentTimeMillis();
        boolean consistent = pelletJenaGraph.isConsistent();
        long e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        Resource concept = model.getResource("http://www.mindswap.org/2003/owl/mindswap#GraduateStudent");
        Individual individual = model.createIndividual("http://www.mindswap.org/2004/owl/mindswappers#JohnDoe", concept);
        s = System.currentTimeMillis();
        consistent = pelletJenaGraph.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
        Property role = model.getProperty("http://xmlns.com/foaf/0.1/mbox");
        individual = model.getIndividual("http://www.mindswap.org/2004/owl/mindswappers#Christian.Halaschek");
        Individual mbox = model.getIndividual("mailto:kolovski@cs.umd.edu");
        individual.addProperty(role, (RDFNode)mbox);
        s = System.currentTimeMillis();
        consistent = pelletJenaGraph.isConsistent();
        e = System.currentTimeMillis();
        System.out.println("Consistent? " + consistent + " (" + (e - s) + "ms)");
    }

    public static void runWithJenaAPIAndOntModel() {
        System.out.println("\nResults after applying changes through Jena API using OntModel");
        System.out.println("-------------------------------------------------");
        OntModel model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        model.setStrictMode(false);
        model.read(mindswappers);
        long s = System.currentTimeMillis();
        model.prepare();
        long e = System.currentTimeMillis();
        System.out.println("Total time " + (e - s) + " ms)");
        JenaReasoner.printIterator(model.validate().getReports(), "Validation Results");
        Resource concept = model.getResource("http://www.mindswap.org/2003/owl/mindswap#GraduateStudent");
        Individual individual = model.createIndividual("http://www.mindswap.org/2004/owl/mindswappers#JohnDoe", concept);
        s = System.currentTimeMillis();
        model.prepare();
        e = System.currentTimeMillis();
        System.out.println("Total time " + (e - s) + " ms)");
        JenaReasoner.printIterator(model.validate().getReports(), "Validation Results");
        Property role = model.getProperty("http://xmlns.com/foaf/0.1/mbox");
        individual = model.getIndividual("http://www.mindswap.org/2004/owl/mindswappers#Christian.Halaschek");
        Individual mbox = model.getIndividual("mailto:kolovski@cs.umd.edu");
        individual.addProperty(role, (RDFNode)mbox);
        s = System.currentTimeMillis();
        model.prepare();
        e = System.currentTimeMillis();
        System.out.println("Total time " + (e - s) + " ms)");
        JenaReasoner.printIterator(model.validate().getReports(), "Validation Results");
    }
}

