/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.tableau.branch;

import com.clarkparsia.pellet.rules.RuleAtomAsserter;
import com.clarkparsia.pellet.rules.VariableBinding;
import com.clarkparsia.pellet.rules.model.AtomIObject;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.model.UnaryAtom;
import java.util.List;
import java.util.logging.Level;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Clash;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.exceptions.InternalReasonerException;
import org.mindswap.pellet.tableau.branch.Branch;
import org.mindswap.pellet.tableau.completion.CompletionStrategy;

public class RuleBranch
extends Branch {
    private RuleAtomAsserter ruleAtomAsserter;
    private VariableBinding binding;
    private List<RuleAtom> atoms;
    private int bodyAtomCount;
    private int[] order;
    private DependencySet[] prevDS;

    public RuleBranch(ABox abox, CompletionStrategy completion, RuleAtomAsserter ruleAtomAsserter, List<RuleAtom> atoms, VariableBinding binding, int bodyAtomCount, DependencySet ds) {
        super(abox, completion, ds, atoms.size());
        this.ruleAtomAsserter = ruleAtomAsserter;
        this.atoms = atoms;
        this.bodyAtomCount = bodyAtomCount;
        this.binding = binding;
        this.prevDS = new DependencySet[atoms.size()];
        this.order = new int[atoms.size()];
        for (int i = 0; i < this.order.length; ++i) {
            this.order[i] = i;
        }
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public RuleBranch copyTo(ABox abox) {
        RuleBranch b = new RuleBranch(abox, this.strategy, this.ruleAtomAsserter, this.atoms, this.binding, this.bodyAtomCount, this.getTermDepends());
        b.setAnonCount(this.getAnonCount());
        b.setNodeCount(this.nodeCount);
        b.setBranch(this.branch);
        b.setTryNext(this.tryNext);
        b.prevDS = new DependencySet[this.prevDS.length];
        System.arraycopy(this.prevDS, 0, b.prevDS, 0, this.tryNext);
        b.order = new int[this.order.length];
        System.arraycopy(this.order, 0, b.order, 0, this.order.length);
        return b;
    }

    @Override
    public void setLastClash(DependencySet ds) {
        super.setLastClash(ds);
        if (this.tryNext >= 0) {
            this.prevDS[this.tryNext] = ds;
        }
    }

    @Override
    protected void tryBranch() {
        this.abox.incrementBranch();
        while (this.tryNext < this.tryCount) {
            DependencySet clashDepends;
            RuleAtom atom = this.atoms.get(this.tryNext);
            DependencySet ds = null;
            if (this.tryNext == this.tryCount - 1 && !PelletOptions.SATURATE_TABLEAU) {
                ds = this.getTermDepends();
                for (int m = 0; m < this.tryNext; ++m) {
                    ds = ds.union(this.prevDS[m], this.abox.doExplanation());
                }
                if (PelletOptions.USE_INCREMENTAL_DELETION) {
                    ds.setExplain(this.getTermDepends().getExplain());
                } else {
                    ds.remove(this.getBranch());
                }
            } else {
                ds = PelletOptions.USE_INCREMENTAL_DELETION ? this.getTermDepends().union(new DependencySet(this.getBranch()), this.abox.doExplanation()) : new DependencySet(this.getBranch());
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("RULE: Branch (" + this.getBranch() + ") try (" + (this.tryNext + 1) + "/" + this.tryCount + ") " + atom + " " + this.binding + " " + this.atoms + " " + ds);
            }
            this.ruleAtomAsserter.assertAtom(atom, this.binding, ds, this.tryNext < this.bodyAtomCount, this.abox, this.strategy);
            if (this.abox.isClosed()) {
                clashDepends = this.abox.getClash().getDepends();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("CLASH: Branch " + this.getBranch() + " " + Clash.unexplained(null, clashDepends) + "!");
                }
                if (this.tryNext >= this.tryCount - 1 || !clashDepends.contains(this.getBranch())) {
                    this.abox.setClash(Clash.unexplained(null, clashDepends.union(ds, this.abox.doExplanation())));
                    if (PelletOptions.USE_INCREMENTAL_DELETION) {
                        this.abox.getKB().getDependencyIndex().addCloseBranchDependency(this, this.abox.getClash().getDepends());
                    }
                    return;
                }
            } else {
                return;
            }
            AtomIObject obj = (AtomIObject)(atom instanceof UnaryAtom ? ((UnaryAtom)atom).getArgument() : ((BinaryAtom)atom).getArgument1());
            Individual ind = this.binding.get(obj);
            this.strategy.restoreLocal(ind, this);
            this.abox.incrementBranch();
            this.setLastClash(clashDepends);
            ++this.tryNext;
        }
        throw new InternalReasonerException("This exception should not be thrown!");
    }

    @Override
    public void shiftTryNext(int openIndex) {
    }
}

