/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import aterm.ATerm;
import com.clarkparsia.pellet.rules.model.AtomVariable;
import com.clarkparsia.pellet.rules.model.BinaryAtom;
import com.clarkparsia.pellet.rules.model.DatavaluedPropertyAtom;
import com.clarkparsia.pellet.rules.model.IndividualPropertyAtom;
import com.clarkparsia.pellet.rules.model.RuleAtom;
import com.clarkparsia.pellet.rules.rete.AlphaNode;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.ArrayList;
import java.util.Iterator;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.DefaultEdge;
import org.mindswap.pellet.DependencySet;
import org.mindswap.pellet.Edge;
import org.mindswap.pellet.EdgeList;
import org.mindswap.pellet.Individual;
import org.mindswap.pellet.Node;
import org.mindswap.pellet.Role;
import org.mindswap.pellet.utils.ATermUtils;
import org.mindswap.pellet.utils.iterator.IteratorUtils;
import org.mindswap.pellet.utils.iterator.NestedIterator;

public class AlphaEdgeNode
extends AlphaNode {
    protected final Role role;

    public AlphaEdgeNode(ABox abox, Role role) {
        super(abox);
        this.role = role;
    }

    public Role getRole() {
        return this.role;
    }

    protected WME.EdgeDirection edgeMatches(Edge edge) {
        boolean isBwd;
        Role edgeRole = edge.getRole();
        boolean isFwd = edgeRole.isSubRoleOf(this.role);
        boolean bl = isBwd = this.role.getInverse() != null && edgeRole.isSubRoleOf(this.role.getInverse());
        return isFwd ? (isBwd ? WME.EdgeDirection.BOTH : WME.EdgeDirection.FORWARD) : (isBwd ? WME.EdgeDirection.BACKWARD : null);
    }

    protected WME createEdge(Edge edge, WME.EdgeDirection dir) {
        if (this.doExplanation) {
            DependencySet ds;
            DependencySet dependencySet = ds = dir == WME.EdgeDirection.FORWARD ? this.role.getExplainSub((ATerm)edge.getRole().getName()) : this.role.getInverse().getExplainSub((ATerm)edge.getRole().getName());
            if (!ds.getExplain().isEmpty()) {
                return WME.createEdge(new DefaultEdge(edge.getRole(), edge.getFrom(), edge.getTo(), edge.getDepends().union(ds, this.doExplanation)), dir);
            }
        }
        return WME.createEdge(edge, dir);
    }

    public boolean activate(Edge edge) {
        WME.EdgeDirection dir = this.edgeMatches(edge);
        if (dir != null) {
            if (dir == WME.EdgeDirection.BOTH) {
                this.activate(this.createEdge(edge, WME.EdgeDirection.FORWARD));
            } else {
                this.activate(this.createEdge(edge, dir));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(RuleAtom atom) {
        return (atom instanceof IndividualPropertyAtom || atom instanceof DatavaluedPropertyAtom) && atom.getPredicate().equals(this.role.getName()) && ((BinaryAtom)atom).getArgument1() instanceof AtomVariable && ((BinaryAtom)atom).getArgument2() instanceof AtomVariable;
    }

    @Override
    public Iterator<WME> getMatches(int argIndex, Node arg) {
        return argIndex == 0 ? this.getMatches((Individual)arg, this.role, null) : this.getMatches(null, this.role, arg);
    }

    protected Iterator<WME> getMatches(Individual s, Role r, Node o) {
        Iterator<Object> i1 = IteratorUtils.emptyIterator();
        Iterator<WME> i2 = IteratorUtils.emptyIterator();
        Role invRole = this.role.getInverse();
        if (s != null) {
            i1 = this.toWMEs(this.getEdges(s.getOutEdges(), this.role, o), WME.EdgeDirection.FORWARD);
            if (invRole != null) {
                i2 = this.toWMEs(this.getEdges(s.getInEdges(), invRole, o), WME.EdgeDirection.BACKWARD);
            }
        } else {
            assert (s == null);
            i1 = this.toWMEs(this.getEdges(o.getInEdges(), this.role, null), WME.EdgeDirection.FORWARD);
            if (invRole != null) {
                i2 = this.toWMEs(this.getEdges(((Individual)o).getOutEdges(), invRole, null), WME.EdgeDirection.BACKWARD);
            }
        }
        return !i1.hasNext() ? i2 : (!i2.hasNext() ? i1 : IteratorUtils.concat(i1, i2));
    }

    private EdgeList getEdges(EdgeList edges, Role r, Node o) {
        return o == null ? edges.getEdges(r) : edges.getEdgesTo(r, o);
    }

    @Override
    public Iterator<WME> getMatches() {
        return new NestedIterator<Individual, WME>((Iterator)this.abox.getIndIterator()){

            @Override
            public Iterator<WME> getInnerIterator(Individual ind) {
                return AlphaEdgeNode.this.toWMEs(ind.getOutEdges().getEdges(AlphaEdgeNode.this.role), WME.EdgeDirection.FORWARD);
            }
        };
    }

    protected Iterator<WME> toWMEs(EdgeList edges, WME.EdgeDirection dir) {
        if (edges.isEmpty()) {
            return IteratorUtils.emptyIterator();
        }
        if (edges.size() == 1) {
            Edge edge = edges.edgeAt(0);
            return IteratorUtils.singletonIterator(this.createEdge(edge, dir));
        }
        ArrayList<WME> wmes = new ArrayList<WME>(edges.size());
        for (Edge edge : edges) {
            wmes.add(this.createEdge(edge, dir));
        }
        return wmes.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.role.getName().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        AlphaEdgeNode other = (AlphaEdgeNode)obj;
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.role.equals(other.role);
    }

    public String toString() {
        return ATermUtils.toString(this.role.getName()) + "(0, 1)";
    }
}

