/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.builtins;

import com.clarkparsia.pellet.rules.builtins.NumericVisitor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import org.mindswap.pellet.exceptions.InternalReasonerException;

public class NumericPromotion {
    private BigInteger[] bigIntArgs;
    private BigDecimal[] decimalArgs;
    private Double[] doubleArgs;
    private Float[] floatArgs;
    private Type type;

    public void accept(NumericVisitor visitor) {
        switch (this.type) {
            case BIGDECIMAL: {
                visitor.visit(this.decimalArgs);
                break;
            }
            case BIGINTEGER: {
                visitor.visit(this.bigIntArgs);
                break;
            }
            case DOUBLE: {
                visitor.visit(this.doubleArgs);
                break;
            }
            case FLOAT: {
                visitor.visit(this.floatArgs);
                break;
            }
            default: {
                throw new InternalReasonerException("Cannot visit type " + (Object)((Object)this.type));
            }
        }
    }

    private Type findHighestType(Number[] nums) {
        Type largest = Type.BYTE;
        for (Number num : nums) {
            Type type = this.findType(num);
            if (!largest.isLessThan(type)) continue;
            largest = type;
        }
        return largest;
    }

    private Type findType(Number num) {
        if (num instanceof Byte) {
            return Type.BYTE;
        }
        if (num instanceof Short) {
            return Type.SHORT;
        }
        if (num instanceof Integer) {
            return Type.INTEGER;
        }
        if (num instanceof Long) {
            return Type.LONG;
        }
        if (num instanceof BigInteger) {
            return Type.BIGINTEGER;
        }
        if (num instanceof BigDecimal) {
            return Type.BIGDECIMAL;
        }
        if (num instanceof Float) {
            return Type.FLOAT;
        }
        if (num instanceof Double) {
            return Type.DOUBLE;
        }
        throw new InternalReasonerException("Unexpected numeric type '" + num.getClass() + "': " + num);
    }

    private void prepArray(Type type, int length) {
        this.bigIntArgs = null;
        this.decimalArgs = null;
        this.doubleArgs = null;
        this.floatArgs = null;
        switch (type) {
            case BIGDECIMAL: {
                this.decimalArgs = new BigDecimal[length];
                break;
            }
            case BIGINTEGER: {
                this.bigIntArgs = new BigInteger[length];
                break;
            }
            case DOUBLE: {
                this.doubleArgs = new Double[length];
                break;
            }
            case FLOAT: {
                this.floatArgs = new Float[length];
                break;
            }
            default: {
                throw new InternalReasonerException("Faulty switch: Don't know how to handle '" + (Object)((Object)type) + "'.");
            }
        }
    }

    public void promote(Number ... nums) {
        this.promote(Type.BIGINTEGER, nums);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void promote(Number arg, int position, Type type2) {
        if (type2.isLessThan(Type.BIGINTEGER)) {
            throw new InternalReasonerException("Cannot promote to anything less than BigInteger");
        }
        Type type1 = this.findType(arg);
        if (type2 == Type.DOUBLE) {
            this.doubleArgs[position] = arg.doubleValue();
            return;
        } else if (type2 == Type.FLOAT) {
            this.floatArgs[position] = Float.valueOf(arg.floatValue());
            return;
        } else if (type2 == Type.BIGDECIMAL) {
            if (type1 == Type.BIGDECIMAL) {
                this.decimalArgs[position] = (BigDecimal)arg;
                return;
            } else if (type1 == Type.BIGINTEGER) {
                this.decimalArgs[position] = new BigDecimal((BigInteger)arg, 0, MathContext.DECIMAL128);
                return;
            } else {
                if (!type1.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + (Object)((Object)type1) + " to BigDecimal.");
                this.decimalArgs[position] = new BigDecimal(arg.longValue(), MathContext.DECIMAL128);
            }
            return;
        } else {
            if (type2 != Type.BIGINTEGER) throw new InternalReasonerException("Do not know how to promote numbers to type " + (Object)((Object)type2));
            if (type1 == Type.BIGINTEGER) {
                this.bigIntArgs[position] = (BigInteger)arg;
                return;
            } else {
                if (!type1.isLessThan(Type.BIGINTEGER)) throw new InternalReasonerException("Do not know how to convert " + (Object)((Object)type1) + " to BigInteger.");
                this.bigIntArgs[position] = new BigDecimal(arg.longValue(), MathContext.DECIMAL128).toBigInteger();
            }
        }
    }

    private void promote(Type minType, Number ... nums) {
        Type largest = this.findHighestType(nums);
        if (largest.isLessThan(minType)) {
            largest = minType;
        }
        this.prepArray(largest, nums.length);
        for (int i = 0; i < nums.length; ++i) {
            this.promote(nums[i], i, largest);
        }
        this.type = largest;
    }

    private static enum Type {
        BIGDECIMAL(5),
        BIGINTEGER(4),
        BYTE(0),
        DOUBLE(7),
        FLOAT(6),
        INTEGER(2),
        LONG(3),
        SHORT(1);

        private final int rank;

        private Type(int rank) {
            this.rank = rank;
        }

        public boolean isLessThan(Type t) {
            if (t == null) {
                return false;
            }
            return this.rank < t.rank;
        }
    }
}

