/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.Pipe;
import org.semarglproject.sink.TripleSink;

public final class TurtleSerializer
extends Pipe<CharSink>
implements TripleSink {
    private static final String DOT_EOL = " .\n";
    private static final String COMMA_EOL = " ,\n";
    private static final String SEMICOLON_EOL = " ;\n";
    private static final String EOL = "\n";
    private static final String MULTILINE_QUOTE = "\"\"\"";
    private static final char SINGLE_LINE_QUOTE = '\"';
    private static final char BNODE_START = '[';
    private static final char BNODE_END = ']';
    private static final char URI_START = '<';
    private static final char URI_END = '>';
    private static final char SPACE = ' ';
    private static final char RDF_TYPE_ABBR = 'a';
    private static final String INDENT = "    ";
    private String prevSubj;
    private String prevPred;
    private final Queue<String> bnodeStack = new LinkedList<String>();
    private final Set<String> namedBnodes = new HashSet<String>();
    private String baseUri;

    private TurtleSerializer(CharSink sink) {
        super((DataSink)sink);
    }

    public static TripleSink connect(CharSink sink) {
        return new TurtleSerializer(sink);
    }

    public void addNonLiteral(String subj, String pred, String obj) {
        try {
            this.startTriple(subj, pred);
            if (obj.startsWith("_:")) {
                if (!this.namedBnodes.contains(obj) && obj.endsWith("sbl")) {
                    this.openBnode(obj);
                } else {
                    ((CharSink)this.sink).process(obj);
                }
            } else {
                this.serializeUri(obj);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addPlainLiteral(String subj, String pred, String content, String lang) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            if (lang != null) {
                ((CharSink)this.sink).process('@').process(lang);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void addTypedLiteral(String subj, String pred, String content, String type) {
        try {
            this.startTriple(subj, pred);
            this.addContent(content);
            ((CharSink)this.sink).process("^^");
            this.serializeUri(type);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void startStream() throws ParseException {
        super.startStream();
        this.prevSubj = null;
        this.prevPred = null;
        if (this.baseUri != null) {
            ((CharSink)this.sink).process("@base ").process('<').process(this.baseUri).process('>').process(DOT_EOL);
        }
        ((CharSink)this.sink).process("@prefix rdf: ").process('<').process("http://www.w3.org/1999/02/22-rdf-syntax-ns#").process('>').process(DOT_EOL);
        this.bnodeStack.clear();
        this.namedBnodes.clear();
    }

    public void endStream() throws ParseException {
        while (!this.bnodeStack.isEmpty()) {
            this.closeBnode();
        }
        if (this.prevPred != null) {
            ((CharSink)this.sink).process(DOT_EOL);
        } else {
            ((CharSink)this.sink).process(EOL);
        }
        this.baseUri = null;
        super.endStream();
    }

    protected boolean setPropertyInternal(String key, Object value) {
        return false;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri.substring(0, baseUri.length() - 1);
    }

    private void startTriple(String subj, String pred) throws ParseException {
        if (subj.equals(this.prevSubj)) {
            if (pred.equals(this.prevPred)) {
                ((CharSink)this.sink).process(COMMA_EOL);
                this.indent(2);
            } else if (this.prevPred != null) {
                ((CharSink)this.sink).process(SEMICOLON_EOL);
                this.indent(1);
                this.serializePredicate(pred);
            } else {
                this.indent(0);
                this.serializePredicate(pred);
            }
        } else {
            if (!this.bnodeStack.isEmpty()) {
                this.closeBnode();
                this.startTriple(subj, pred);
                return;
            }
            if (this.prevSubj != null) {
                ((CharSink)this.sink).process(DOT_EOL);
            }
            if (subj.startsWith("_:")) {
                if (subj.endsWith("sbl")) {
                    this.openBnode(subj);
                } else {
                    ((CharSink)this.sink).process(subj).process(' ');
                    this.namedBnodes.add(subj);
                }
            } else {
                this.serializeUri(subj);
            }
            this.serializePredicate(pred);
        }
        this.prevSubj = subj;
        this.prevPred = pred;
    }

    private void serializePredicate(String pred) throws ParseException {
        if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#type".equals(pred)) {
            ((CharSink)this.sink).process('a').process(' ');
        } else {
            this.serializeUri(pred);
        }
    }

    private void serializeUri(String uri) throws ParseException {
        String escapedUri = uri.replace("\\", "\\\\").replace(">", "\\u003E");
        if (escapedUri.startsWith("http://www.w3.org/1999/02/22-rdf-syntax-ns#")) {
            ((CharSink)this.sink).process("rdf:").process(escapedUri.substring("http://www.w3.org/1999/02/22-rdf-syntax-ns#".length()));
        } else if (this.baseUri != null && escapedUri.startsWith(this.baseUri)) {
            ((CharSink)this.sink).process('<').process(escapedUri.substring(this.baseUri.length())).process('>');
        } else {
            ((CharSink)this.sink).process('<').process(escapedUri).process('>');
        }
        ((CharSink)this.sink).process(' ');
    }

    private void indent(int additionalIndent) throws ParseException {
        for (int i = 0; i < this.bnodeStack.size() + additionalIndent; ++i) {
            ((CharSink)this.sink).process(INDENT);
        }
    }

    private void addContent(String content) throws ParseException {
        String escapedContent = content.replace("\\", "\\\\").replace("\"", "\\\"");
        if (escapedContent.contains(EOL)) {
            ((CharSink)this.sink).process(MULTILINE_QUOTE).process(escapedContent).process(MULTILINE_QUOTE);
        } else {
            ((CharSink)this.sink).process('\"').process(escapedContent).process('\"');
        }
    }

    private void openBnode(String obj) throws ParseException {
        ((CharSink)this.sink).process('[');
        this.bnodeStack.offer(obj);
        this.prevSubj = obj;
        this.prevPred = null;
    }

    private void closeBnode() throws ParseException {
        ((CharSink)this.sink).process(']');
        this.bnodeStack.poll();
        this.prevSubj = this.bnodeStack.peek();
        this.prevPred = null;
        if (this.prevSubj == null) {
            ((CharSink)this.sink).process(DOT_EOL);
        }
    }
}

