/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellint.rdfxml;

import com.clarkparsia.pellint.rdfxml.DoubtfulSet;
import com.clarkparsia.pellint.util.CollectionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.vocabulary.SWRL;

public class OWLEntityDatabase {
    public static final Logger log = Logger.getLogger(OWLEntityDatabase.class.getName());
    private DoubtfulSet<RDFNode> m_Ontologies = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Classes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Datatypes = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_Individuals = new DoubtfulSet();
    private Set<RDFNode> m_AllRoles = CollectionUtil.makeSet();
    private DoubtfulSet<RDFNode> m_AnnotationRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_OntologyRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_ObjectRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_DatatypeRoles = new DoubtfulSet();
    private DoubtfulSet<RDFNode> m_SWRLVariables = new DoubtfulSet();
    private Set<RDFNode> m_RDFClasses = CollectionUtil.makeSet();
    private Set<Resource> m_Restrictions = CollectionUtil.makeSet();
    private Set<RDFNode> m_Literals = CollectionUtil.makeSet();
    private Set<Literal> m_LiteralsAsClass = CollectionUtil.makeSet();
    private Set<Literal> m_LiteralsAsIndividuals = CollectionUtil.makeSet();
    private Set<Resource> m_ResourcesAsLiterals = CollectionUtil.makeSet();

    public void addOntology(RDFNode s) {
        this.m_Ontologies.addDefinite(s);
    }

    public void assumeOntology(RDFNode s) {
        this.m_Ontologies.add(s);
    }

    public boolean containsOntology(RDFNode s) {
        return this.m_Ontologies.contains(s);
    }

    public Set<RDFNode> getDoubtfulOntologies() {
        return this.m_Ontologies.getDoubtfulElements();
    }

    public void addRDFSClass(RDFNode s) {
        this.m_RDFClasses.add(s);
    }

    public Set<RDFNode> getAllRDFClasses() {
        return this.m_RDFClasses;
    }

    public void addRestriction(Resource s) {
        this.m_Restrictions.add(s);
    }

    public Set<Resource> getAllRestrictions() {
        return this.m_Restrictions;
    }

    public void addLiteral(RDFNode s) {
        this.m_Literals.add(s);
    }

    public void addClass(RDFNode s) {
        this.m_Classes.addDefinite(s);
    }

    public void assumeClass(RDFNode s) {
        this.m_Classes.add(s);
        if (s instanceof Literal) {
            this.m_LiteralsAsClass.add((Literal)s);
        }
    }

    public boolean containsClass(RDFNode s) {
        return this.m_Classes.contains(s) || s.isResource() && this.m_Restrictions.contains(s);
    }

    public Set<RDFNode> getDoubtfulClasses() {
        Set<RDFNode> classes = this.m_Classes.getDoubtfulElements();
        classes.removeAll(this.m_Restrictions);
        return classes;
    }

    public void addDatatype(RDFNode s) {
        this.m_Datatypes.addDefinite(s);
    }

    public void assumeDatatype(RDFNode s) {
        this.m_Datatypes.add(s);
    }

    public boolean containsDatatype(RDFNode s) {
        return this.m_Datatypes.contains(s);
    }

    public Set<RDFNode> getDoubtfulDatatypes() {
        return this.m_Datatypes.getDoubtfulElements();
    }

    public void addIndividual(RDFNode s) {
        this.m_Individuals.addDefinite(s);
    }

    public void assumeIndividual(RDFNode s) {
        this.m_Individuals.add(s);
    }

    public boolean containsIndividual(RDFNode s) {
        return this.m_Individuals.contains(s);
    }

    public Set<RDFNode> getDoubtfulIndividuals() {
        return this.m_Individuals.getDoubtfulElements();
    }

    public void addUntypedRole(RDFNode s) {
        this.m_AllRoles.add(s);
    }

    public boolean containsRole(RDFNode s) {
        return this.m_AllRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulRoles() {
        Set<RDFNode> roles = CollectionUtil.copy(this.m_AllRoles);
        roles.removeAll(this.m_AnnotationRoles);
        roles.removeAll(this.m_OntologyRoles);
        roles.removeAll(this.m_ObjectRoles);
        roles.removeAll(this.m_DatatypeRoles);
        return roles;
    }

    public void addAnnotationRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_AnnotationRoles.addDefinite(s);
    }

    public void assumeAnnotationRole(RDFNode s) {
        this.m_AnnotationRoles.add(s);
    }

    public boolean containsAnnotaionRole(RDFNode s) {
        return this.m_AnnotationRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulAnnotaionRoles() {
        return this.m_AnnotationRoles.getDoubtfulElements();
    }

    public void addOntologyRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_OntologyRoles.addDefinite(s);
    }

    public boolean containsOntologyRole(RDFNode s) {
        return this.m_OntologyRoles.contains(s);
    }

    public void addObjectRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_ObjectRoles.addDefinite(s);
    }

    public void assumeObjectRole(RDFNode s) {
        this.m_ObjectRoles.add(s);
    }

    public boolean containsObjectRole(RDFNode s) {
        return this.m_ObjectRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulObjectRoles() {
        return this.m_ObjectRoles.getDoubtfulElements();
    }

    public void addInverseFunctionalRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addTransitiveRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addSymmetricRole(RDFNode s) {
        this.addObjectRole(s);
    }

    public void addAntiSymmetricRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addReflexiveRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addIrreflexiveRole(Resource s) {
        this.addObjectRole((RDFNode)s);
    }

    public void addDatatypeRole(RDFNode s) {
        this.m_AllRoles.add(s);
        this.m_DatatypeRoles.addDefinite(s);
    }

    public void assumeDatatypeRole(RDFNode s) {
        this.m_DatatypeRoles.add(s);
    }

    public boolean containsDatatypeRole(RDFNode s) {
        return this.m_DatatypeRoles.contains(s);
    }

    public Set<RDFNode> getDoubtfulDatatypeRoles() {
        return this.m_DatatypeRoles.getDoubtfulElements();
    }

    public void addSWRLVariable(RDFNode s) {
        this.m_SWRLVariables.addDefinite(s);
    }

    public void assumeSWRLVariable(RDFNode s) {
        this.m_SWRLVariables.add(s);
    }

    public boolean containsSWRLVariable(RDFNode s) {
        return this.m_SWRLVariables.contains(s);
    }

    public Set<RDFNode> getDoubtfulSWRLVariables() {
        return this.m_SWRLVariables.getDoubtfulElements();
    }

    public Set<Literal> getLiteralsAsClass() {
        return this.m_LiteralsAsClass;
    }

    public void addLiteralAsClass(Literal literal) {
        this.m_LiteralsAsClass.add(literal);
    }

    public Set<Literal> getLiteralsAsIndividuals() {
        return this.m_LiteralsAsIndividuals;
    }

    public void addLiteralAsIndividual(Literal literal) {
        this.m_LiteralsAsIndividuals.add(literal);
    }

    public Set<Resource> getResourcesAsLiterals() {
        return this.m_ResourcesAsLiterals;
    }

    public void addResourcesAsLiteral(Resource resource) {
        this.m_ResourcesAsLiterals.add(resource);
    }

    public boolean containsResource(RDFNode s) {
        return this.m_Ontologies.contains(s) || this.m_Classes.contains(s) || this.m_Datatypes.contains(s) || this.m_Individuals.contains(s) || this.m_AllRoles.contains(s) || this.m_RDFClasses.contains(s) || s.isResource() && this.m_Restrictions.contains(s) || this.m_Literals.contains(s) || this.m_SWRLVariables.contains(s);
    }

    public Map<RDFNode, List<String>> getAllMultiTypedResources() {
        return this.getMultiTypedResources(false);
    }

    public Map<RDFNode, List<String>> getMultiTypedResources(boolean excludeValidPunning) {
        Map<String, Set<RDFNode>> definiteResourcesByType = CollectionUtil.makeMap();
        if (!excludeValidPunning) {
            definiteResourcesByType.put("Ontology", this.m_Ontologies.getDefiniteElements());
            definiteResourcesByType.put("Class", this.m_Classes.getDefiniteElements());
            definiteResourcesByType.put("Datatype", this.m_Datatypes.getDefiniteElements());
            definiteResourcesByType.put("Individual", this.m_Individuals);
            definiteResourcesByType.put("Literal", this.m_Literals);
        }
        definiteResourcesByType.put("Annotation Property", this.m_AnnotationRoles.getDefiniteElements());
        definiteResourcesByType.put("Ontology Property", this.m_OntologyRoles.getDefiniteElements());
        definiteResourcesByType.put("Datatype Property", this.m_DatatypeRoles.getDefiniteElements());
        definiteResourcesByType.put("Object Property", this.m_ObjectRoles.getDefiniteElements());
        definiteResourcesByType.put("SWRL Variable", this.m_SWRLVariables.getDefiniteElements());
        Set<RDFNode> allDefiniteResources = CollectionUtil.makeSet();
        for (Object definiteResources : definiteResourcesByType.values()) {
            allDefiniteResources.addAll((Collection<RDFNode>)definiteResources);
        }
        Map<RDFNode, List<String>> multiTypedResources = CollectionUtil.makeMap();
        for (RDFNode node : allDefiniteResources) {
            List types = CollectionUtil.makeList();
            for (Map.Entry definiteResources : definiteResourcesByType.entrySet()) {
                if (!((Set)definiteResources.getValue()).contains(node)) continue;
                types.add(definiteResources.getKey());
            }
            if (types.size() <= 1) continue;
            multiTypedResources.put(node, types);
        }
        if (excludeValidPunning) {
            List<String> classDatatypePunning = Arrays.asList("Class", "Datatype");
            for (RDFNode node : this.m_Datatypes.getDefiniteElements()) {
                if (!this.m_Classes.getDefiniteElements().contains(node)) continue;
                multiTypedResources.put(node, classDatatypePunning);
            }
        }
        return multiTypedResources;
    }

    public List<Statement> getAllTypingStatements() {
        List<Statement> statements = CollectionUtil.makeList();
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulOntologies(), OWL.Ontology);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulClasses(), OWL.Class);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulDatatypes(), RDFS.Datatype);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulAnnotaionRoles(), OWL.AnnotationProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulObjectRoles(), OWL.ObjectProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulDatatypeRoles(), OWL.DatatypeProperty);
        OWLEntityDatabase.addTypingStatements(statements, this.getDoubtfulSWRLVariables(), SWRL.Variable);
        return statements;
    }

    private static void addTypingStatements(List<Statement> statements, Set<RDFNode> subjects, Resource rdfType) {
        Model model = ModelFactory.createDefaultModel();
        for (RDFNode s : subjects) {
            if (!(s instanceof Resource)) continue;
            statements.add(model.createStatement((Resource)s, RDF.type, (RDFNode)rdfType));
        }
    }
}

