/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapiv3;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.reasoner.Node;

public class ImmutableNode<E extends OWLObject>
implements Node<E> {
    private final Set<E> entities;

    public static <E extends OWLObject> ImmutableNode<E> of(E entity) {
        return new ImmutableNode<E>(ImmutableSet.of(entity));
    }

    public static <E extends OWLObject> ImmutableNode<E> of(Set<E> entities) {
        return new ImmutableNode<E>(ImmutableSet.copyOf(entities));
    }

    private ImmutableNode(ImmutableSet<E> entities) {
        this.entities = entities;
    }

    protected E getTopEntity() {
        return null;
    }

    protected E getBottomEntity() {
        return null;
    }

    public boolean isTopNode() {
        return this.entities.contains(this.getTopEntity());
    }

    public boolean isBottomNode() {
        return this.entities.contains(this.getBottomEntity());
    }

    @Nonnull
    public Set<E> getEntities() {
        return this.entities;
    }

    public int getSize() {
        return this.entities.size();
    }

    public boolean contains(E entity) {
        return this.entities.contains(entity);
    }

    @Nonnull
    public Set<E> getEntitiesMinus(E e) {
        HashSet<E> result = new HashSet<E>(this.entities);
        result.remove(e);
        return result;
    }

    @Nonnull
    public Set<E> getEntitiesMinusTop() {
        return this.getEntitiesMinus(this.getTopEntity());
    }

    @Nonnull
    public Set<E> getEntitiesMinusBottom() {
        return this.getEntitiesMinus(this.getBottomEntity());
    }

    public boolean isSingleton() {
        return this.entities.size() == 1;
    }

    @Nonnull
    public E getRepresentativeElement() {
        return (E)((OWLObject)this.entities.iterator().next());
    }

    @Nonnull
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    @Nonnull
    public String toString() {
        return "Node" + this.entities;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        return this.entities.equals(other.getEntities());
    }

    public int hashCode() {
        return this.entities.hashCode();
    }
}

