/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.apibinding;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.OWLAPIParsersModule;
import org.semanticweb.owlapi.OWLAPIServiceLoaderModule;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.mansyntax.ManchesterOWLSyntaxParser;
import uk.ac.manchester.cs.owl.owlapi.OWLAPIImplModule;
import uk.ac.manchester.cs.owl.owlapi.concurrent.Concurrency;

public class OWLManager
implements OWLOntologyManagerFactory {
    private static final long serialVersionUID = 40000L;

    public OWLOntologyManager get() {
        return OWLManager.createOWLOntologyManager();
    }

    @Nonnull
    public static OWLOntologyManager createOWLOntologyManager() {
        return OWLManager.createOWLOntologyManager(OWLManager.createInjector(Concurrency.NON_CONCURRENT));
    }

    @Nonnull
    public static OWLOntologyManager createConcurrentOWLOntologyManager() {
        return OWLManager.createOWLOntologyManager(OWLManager.createInjector(Concurrency.CONCURRENT));
    }

    @Nonnull
    public static OWLDataFactory getOWLDataFactory() {
        return OWLManager.getOWLDataFactory(OWLManager.createInjector(Concurrency.NON_CONCURRENT));
    }

    @Nonnull
    public static OWLOntologyManager createOWLOntologyManager(Object injector) {
        return OWLManager.instatiateOWLOntologyManager(injector);
    }

    @Nonnull
    public static OWLDataFactory getOWLDataFactory(Object injector) {
        return (OWLDataFactory)OWLAPIPreconditions.verifyNotNull((Object)((Injector)injector).getInstance(OWLDataFactory.class));
    }

    @Nonnull
    public static ManchesterOWLSyntaxParser createManchesterParser() {
        return (ManchesterOWLSyntaxParser)((Injector)OWLManager.createInjector(Concurrency.NON_CONCURRENT)).getInstance(ManchesterOWLSyntaxParser.class);
    }

    @Nonnull
    public static Object createInjector(Concurrency concurrency) {
        String previousStrategy = System.getProperty("guice_include_stack_traces");
        System.setProperty("guice_include_stack_traces", "OFF");
        Injector injector = Guice.createInjector((Module[])new Module[]{new OWLAPIImplModule(concurrency), new OWLAPIParsersModule(), new OWLAPIServiceLoaderModule()});
        if (previousStrategy != null) {
            System.setProperty("guice_include_stack_traces", previousStrategy);
        } else {
            System.getProperties().remove("guice_include_stack_traces");
        }
        return injector;
    }

    private static OWLOntologyManager instatiateOWLOntologyManager(Object injector) {
        Injector inj = (Injector)injector;
        OWLOntologyManager instance = (OWLOntologyManager)inj.getInstance(OWLOntologyManager.class);
        inj.injectMembers((Object)instance);
        return (OWLOntologyManager)OWLAPIPreconditions.verifyNotNull((Object)instance);
    }
}

