/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import aterm.ATermAppl;
import java.util.Collection;
import java.util.HashSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.mindswap.pellet.jena.JenaUtils;
import org.mindswap.pellet.jena.vocabulary.OWL2;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.TaxonomyUtils;

public class TaxonomyExtractor {
    private Taxonomy<ATermAppl> taxonomy;
    private Model model;
    private boolean includeIndividuals;

    public TaxonomyExtractor(Taxonomy<ATermAppl> taxonomy) {
        this.taxonomy = taxonomy;
        this.includeIndividuals = false;
    }

    public void setIncludeIndividuals(boolean includeIndividuals) {
        this.includeIndividuals = includeIndividuals;
    }

    public Model extractModel() {
        if (this.model == null) {
            this.model = this.createExtractedModel();
        }
        return this.model;
    }

    private Model createExtractedModel() {
        Model model = ModelFactory.createDefaultModel();
        HashSet processedEquivalentClasses = new HashSet();
        for (TaxonomyNode taxonomyNode : this.taxonomy.getNodes()) {
            if (processedEquivalentClasses.contains(taxonomyNode.getName())) continue;
            processedEquivalentClasses.addAll(taxonomyNode.getEquivalents());
            for (ATermAppl aClass : taxonomyNode.getEquivalents()) {
                Collection individuals;
                model.add(TaxonomyExtractor.classAssertion(model, aClass));
                for (TaxonomyNode superNode : taxonomyNode.getSupers()) {
                    model.add(TaxonomyExtractor.subClassOfAssertion(model, aClass, (ATermAppl)superNode.getName()));
                }
                if (taxonomyNode.getEquivalents().size() > 1) {
                    for (ATermAppl equivalentClass : taxonomyNode.getEquivalents()) {
                        if (equivalentClass.equals(aClass)) continue;
                        model.add(TaxonomyExtractor.equivalentClassAssertion(model, aClass, equivalentClass));
                    }
                }
                if (!this.includeIndividuals || (individuals = (Collection)taxonomyNode.getDatum(TaxonomyUtils.INSTANCES_KEY)) == null || individuals.isEmpty()) continue;
                for (ATermAppl individual : individuals) {
                    model.add(TaxonomyExtractor.typeAssertion(model, individual, aClass));
                }
            }
        }
        return model;
    }

    private static Statement typeAssertion(Model model, ATermAppl individual, ATermAppl type) {
        Resource individualResource = TaxonomyExtractor.createResource(model, individual);
        Property typeProperty = RDF.type;
        Resource typeResource = TaxonomyExtractor.createResource(model, type);
        return model.createStatement(individualResource, typeProperty, (RDFNode)typeResource);
    }

    private static Statement classAssertion(Model model, ATermAppl aClass) {
        Resource classResource = TaxonomyExtractor.createResource(model, aClass);
        Property typeProperty = RDF.type;
        Resource owlClassResource = OWL2.Class;
        return model.createStatement(classResource, typeProperty, (RDFNode)owlClassResource);
    }

    private static Statement subClassOfAssertion(Model model, ATermAppl subClass, ATermAppl superClass) {
        Resource subClassResource = TaxonomyExtractor.createResource(model, subClass);
        Property subClassOfProperty = RDFS.subClassOf;
        Resource superClassResource = TaxonomyExtractor.createResource(model, superClass);
        return model.createStatement(subClassResource, subClassOfProperty, (RDFNode)superClassResource);
    }

    private static Statement equivalentClassAssertion(Model model, ATermAppl firstClass, ATermAppl secondClass) {
        Resource firstClassResource = TaxonomyExtractor.createResource(model, firstClass);
        Property equivalentClassProperty = OWL2.equivalentClass;
        Resource secondClassResource = TaxonomyExtractor.createResource(model, secondClass);
        return model.createStatement(firstClassResource, equivalentClassProperty, (RDFNode)secondClassResource);
    }

    private static Resource createResource(Model model, ATermAppl term) {
        return JenaUtils.makeResource(term, model);
    }
}

