/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.IncrementalReasoner;
import com.clarkparsia.modularity.IncrementalReasonerConfiguration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class IncremantalReasonerFactory
implements OWLReasonerFactory {
    private static final IncremantalReasonerFactory INSTANCE = new IncremantalReasonerFactory();

    public static IncremantalReasonerFactory getInstance() {
        return INSTANCE;
    }

    public String getReasonerName() {
        return "Pellet (Incremental)";
    }

    public String toString() {
        return this.getReasonerName();
    }

    public IncrementalReasoner createReasoner(OWLOntology ontology) {
        return new IncrementalReasoner(ontology, new IncrementalReasonerConfiguration());
    }

    public IncrementalReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new IncrementalReasoner(ontology, this.config(config));
    }

    public IncrementalReasoner createNonBufferingReasoner(OWLOntology ontology) {
        return new IncrementalReasoner(ontology, new IncrementalReasonerConfiguration());
    }

    public IncrementalReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new IncrementalReasoner(ontology, this.config(config));
    }

    private IncrementalReasonerConfiguration config(OWLReasonerConfiguration config) {
        return config instanceof IncrementalReasonerConfiguration ? (IncrementalReasonerConfiguration)config : new IncrementalReasonerConfiguration(config);
    }
}

