/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.modularity;

import com.clarkparsia.modularity.ChangeTypeDetector;
import com.clarkparsia.modularity.ModuleExtractor;
import com.clarkparsia.modularity.io.ModuleExtractorPersistence;
import com.clarkparsia.modularity.io.UncloseableOutputStream;
import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import com.clarkparsia.owlapiv3.OWL;
import com.clarkparsia.owlapiv3.OntologyUtils;
import com.clarkparsia.pellet.expressivity.Expressivity;
import com.clarkparsia.pellet.utils.DeltaMap;
import com.clarkparsia.pellet.utils.DeltaSet;
import com.clarkparsia.pellet.utils.MultiMapUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.PelletOptions;
import org.mindswap.pellet.taxonomy.Taxonomy;
import org.mindswap.pellet.taxonomy.TaxonomyNode;
import org.mindswap.pellet.utils.MultiValueMap;
import org.mindswap.pellet.utils.Timer;
import org.mindswap.pellet.utils.Timers;
import org.mindswap.pellet.utils.progress.ConsoleProgressMonitor;
import org.mindswap.pellet.utils.progress.ProgressMonitor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public abstract class AbstractModuleExtractor
implements ModuleExtractor {
    public static final Logger log = Logger.getLogger(AbstractModuleExtractor.class.getName());
    private final Set<OWLAxiom> additions = new HashSet<OWLAxiom>();
    private final Set<OWLClass> newClasses = new HashSet<OWLClass>();
    private final Set<OWLAxiom> axioms;
    private final Set<OWLAxiom> deletions = new HashSet<OWLAxiom>();
    protected final EnumSet<KnowledgeBase.ChangeType> changes = EnumSet.noneOf(KnowledgeBase.ChangeType.class);
    protected final Map<OWLEntity, Set<OWLAxiom>> entityAxioms;
    private final LocalityClass localityClass;
    private final SyntacticLocalityEvaluator localityEvaluator;
    protected Map<OWLEntity, Set<OWLEntity>> modules;
    private boolean nonLocalAxioms = false;
    private final Timers timers = new Timers();
    private static final String MODULE_EXTRACTOR_AXIOMS_FILE_NAME = "ModuleExtractorAxioms";
    private static final String MODULE_EXTRACTOR_MODULES_FILE_NAME = "ModuleExtractorModules";

    public AbstractModuleExtractor() {
        this(LocalityClass.BOTTOM_BOTTOM);
    }

    public AbstractModuleExtractor(LocalityClass localityClass) {
        this.localityClass = localityClass;
        this.localityEvaluator = new SyntacticLocalityEvaluator(localityClass);
        this.axioms = new HashSet<OWLAxiom>();
        this.entityAxioms = new HashMap<OWLEntity, Set<OWLAxiom>>();
        this.modules = null;
    }

    protected AbstractModuleExtractor(AbstractModuleExtractor extractor) {
        this.localityClass = extractor.localityClass;
        this.localityEvaluator = new SyntacticLocalityEvaluator(this.localityClass);
        this.axioms = new DeltaSet(extractor.axioms);
        this.entityAxioms = new DeltaMap(extractor.entityAxioms);
        this.modules = extractor.modules == null ? null : new DeltaMap(extractor.modules);
    }

    @Override
    public void addAxiom(OWLAxiom axiom) {
        if (!axiom.isLogicalAxiom()) {
            return;
        }
        if (this.axioms.contains(axiom = axiom.getAxiomWithoutAnnotations())) {
            return;
        }
        this.checkNonLocalAxiom(axiom);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Adding " + axiom);
        }
        this.deletions.remove(axiom);
        this.additions.add(axiom);
        this.categorizeAddedAxiom(axiom);
    }

    @Override
    public boolean canUpdate() {
        return this.modules != null && !this.nonLocalAxioms;
    }

    private void checkNonLocalAxiom(OWLAxiom axiom) {
        if (this.canUpdate() && !this.isLocal(axiom, Collections.emptySet())) {
            log.warning("*** Non-local axiom: " + axiom);
            this.nonLocalAxioms = true;
        }
    }

    @Override
    public void deleteAxiom(OWLAxiom axiom) {
        if (!axiom.isLogicalAxiom()) {
            return;
        }
        axiom = axiom.getAxiomWithoutAnnotations();
        this.checkNonLocalAxiom(axiom);
        if (!this.axioms.contains(axiom)) {
            if (this.additions.remove(axiom) && log.isLoggable(Level.FINE)) {
                log.fine("Deleted axiom from add queue before processing " + axiom);
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Deleting " + axiom);
        }
        this.additions.remove(axiom);
        this.deletions.add(axiom);
        this.categorizeRemovedAxiom(axiom);
    }

    @Override
    public void extractModules() {
        Timer timer = this.timers.startTimer("extractModules");
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new HashMap<OWLEntity, Set<OWLEntity>>();
        this.extractModuleSignatures(this.entityAxioms.keySet());
        timer.stop();
    }

    private void extractModuleSignatures(Set<? extends OWLEntity> entities) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Extracting module for each of " + entities);
        }
        if (entities.isEmpty()) {
            return;
        }
        ConsoleProgressMonitor monitor = new ConsoleProgressMonitor();
        monitor.setProgressTitle("Extracting");
        monitor.setProgressLength(entities.size());
        monitor.taskStarted();
        this.extractModuleSignatures(entities, (ProgressMonitor)monitor);
        monitor.taskFinished();
        if (log.isLoggable(Level.FINER)) {
            log.finer("Modules: " + this.modules);
        }
    }

    protected abstract void extractModuleSignatures(Set<? extends OWLEntity> var1, ProgressMonitor var2);

    private Set<OWLEntity> getAffectedRoots(OWLAxiom axiom, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<OWLEntity> roots = new HashSet<OWLEntity>();
        HashSet<TaxonomyNode<OWLClass>> visited = new HashSet<TaxonomyNode<OWLClass>>();
        visited.add(taxonomy.getBottom());
        this.getAffectedRoots(axiom, (TaxonomyNode<OWLClass>)taxonomy.getTop(), roots, add, visited);
        if (!add && roots.isEmpty()) {
            for (OWLClass unsat : taxonomy.getEquivalents((Object)OWL.Nothing)) {
                Set<OWLEntity> signature = this.modules.get(unsat);
                if (signature == null || !signature.containsAll(axiom.getSignature())) continue;
                roots.add((OWLEntity)unsat);
            }
        }
        return roots;
    }

    private void getAffectedRoots(OWLAxiom axiom, TaxonomyNode<OWLClass> node, Set<OWLEntity> effects, boolean add, Set<TaxonomyNode<OWLClass>> visited) {
        if (visited.contains(node)) {
            return;
        }
        visited.add(node);
        OWLEntity entity = (OWLEntity)node.getName();
        Set<OWLEntity> signature = this.modules.get(entity);
        boolean outdated = false;
        if (signature == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Removed entity " + entity);
            }
        } else {
            outdated = add ? !this.isLocal(axiom, signature) : signature.containsAll(axiom.getSignature());
        }
        if (outdated) {
            effects.addAll(node.getEquivalents());
        } else {
            for (TaxonomyNode next : node.getSubs()) {
                this.getAffectedRoots(axiom, (TaxonomyNode<OWLClass>)next, effects, add, visited);
            }
        }
    }

    @Override
    public Set<OWLAxiom> getAxioms(OWLEntity entity) {
        return MultiMapUtils.get(this.entityAxioms, (Object)entity);
    }

    @Override
    public Set<OWLEntity> getModuleEntities(OWLEntity entity) {
        return this.modules.get(entity);
    }

    protected Set<OWLAxiom> getModuleAxioms(Set<OWLEntity> signature) {
        HashSet referenced = new HashSet();
        HashSet<OWLEntity> augmentedSig = new HashSet<OWLEntity>(signature);
        augmentedSig.add((OWLEntity)OWL.Thing);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> candidates = new HashSet<OWLAxiom>();
        for (OWLEntity e : signature) {
            candidates.addAll(this.getAxioms(e));
        }
        for (OWLAxiom axiom : candidates) {
            Set sigAxiom = axiom.getSignature();
            if (!augmentedSig.containsAll(sigAxiom) || this.isLocal(axiom, signature)) continue;
            axioms.add(axiom);
            referenced.addAll(sigAxiom);
        }
        HashSet<OWLEntity> notReferenced = new HashSet<OWLEntity>(signature);
        notReferenced.removeAll(referenced);
        for (OWLEntity e : notReferenced) {
            if (this.entityAxioms.get(e) == null) continue;
            axioms.add((OWLAxiom)OWL.declaration((OWLEntity)e));
        }
        return axioms;
    }

    @Override
    public OWLOntology getModuleFromSignature(Set<OWLEntity> signature) {
        Set<OWLAxiom> moduleAxioms = this.getModuleAxioms(signature);
        return OWL.Ontology(moduleAxioms);
    }

    @Override
    public boolean isChanged() {
        return !this.additions.isEmpty() || !this.deletions.isEmpty() || this.nonLocalAxioms;
    }

    protected boolean isLocal(OWLAxiom axiom, Set<OWLEntity> signature) {
        return this.localityEvaluator.isLocal(axiom, signature);
    }

    private void processAdditions() {
        for (OWLAxiom axiom : this.additions) {
            this.axioms.add(axiom);
            for (OWLEntity entity : axiom.getSignature()) {
                MultiMapUtils.add(this.entityAxioms, (Object)entity, (Object)axiom);
                if (!(entity instanceof OWLClass)) continue;
                OWLClass cls = (OWLClass)entity;
                if (this.modules == null || this.modules.containsKey(cls)) continue;
                this.newClasses.add(cls);
            }
        }
    }

    private void processDeletions() {
        for (OWLAxiom axiom : this.deletions) {
            this.axioms.remove(axiom);
            for (OWLEntity entity : axiom.getSignature()) {
                MultiMapUtils.remove(this.entityAxioms, (Object)entity, (Object)axiom);
                if (this.entityAxioms.containsKey(entity)) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Remove " + entity + " which is not mentioned anymore");
                }
                this.modules.remove(entity);
            }
        }
    }

    private void updateEffectedModules(Set<OWLEntity> effects, Taxonomy<OWLClass> taxonomy, boolean add) {
        HashSet<Object> affectedRoots = new HashSet<Object>();
        HashSet<OWLEntity> affected = new HashSet<OWLEntity>();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Update modules for " + (add ? "additions" : "deletions"));
        }
        affectedRoots.addAll(this.newClasses);
        Set<OWLAxiom> axioms = add ? this.additions : this.deletions;
        for (OWLAxiom oWLAxiom : axioms) {
            affectedRoots.addAll(this.getAffectedRoots(oWLAxiom, taxonomy, add));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected roots " + affectedRoots);
        }
        for (OWLEntity oWLEntity : affectedRoots) {
            affected.add(oWLEntity);
            if (!(oWLEntity instanceof OWLClass) || !taxonomy.contains((Object)((OWLClass)oWLEntity))) continue;
            affected.addAll(taxonomy.getFlattenedSubs((Object)((OWLClass)oWLEntity), false));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Affected entities " + affected);
        }
        for (OWLEntity oWLEntity : affected) {
            this.modules.remove(oWLEntity);
        }
        this.extractModuleSignatures(affected);
        for (OWLEntity oWLEntity : affected) {
            Set<OWLEntity> module = this.modules.get(oWLEntity);
            if (module == null) {
                String msg = "No module for " + oWLEntity;
                log.log(Level.SEVERE, msg, new RuntimeException(msg));
            }
            effects.addAll(module);
        }
    }

    @Override
    public Set<OWLEntity> applyChanges(Taxonomy<OWLClass> taxonomy) throws UnsupportedOperationException {
        Timer timer = this.timers.startTimer("updateModules");
        if (!this.canUpdate()) {
            throw new UnsupportedOperationException("Modules cannot be updated!");
        }
        HashSet<OWLEntity> effects = new HashSet<OWLEntity>();
        this.processAdditions();
        this.updateEffectedModules(effects, taxonomy, true);
        this.updateEffectedModules(effects, taxonomy, false);
        this.processDeletions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.newClasses.clear();
        timer.stop();
        return effects;
    }

    @Override
    public Timers getTimers() {
        return this.timers;
    }

    @Override
    public Set<OWLAxiom> getAxioms() {
        return Collections.unmodifiableSet(this.axioms);
    }

    @Override
    public Set<OWLEntity> getEntities() {
        return Collections.unmodifiableSet(this.entityAxioms.keySet());
    }

    public void resetModules() {
        this.processAdditions();
        this.additions.clear();
        this.deletions.clear();
        this.changes.clear();
        this.nonLocalAxioms = false;
        this.modules = new MultiValueMap();
    }

    @Override
    public boolean isClassificationNeeded(Expressivity expressivity) {
        return this.isTBoxChanged() || this.isRBoxChanged() || expressivity.hasNominal() && !PelletOptions.USE_PSEUDO_NOMINALS;
    }

    public boolean isTBoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.TBOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.TBOX_DEL);
    }

    public boolean isRBoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.RBOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.RBOX_DEL);
    }

    public boolean isABoxChanged() {
        return this.changes.contains(KnowledgeBase.ChangeType.ABOX_ADD) || this.changes.contains(KnowledgeBase.ChangeType.ABOX_DEL);
    }

    private void categorizeAddedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_ADD);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_ADD);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_ADD);
        }
    }

    private void categorizeRemovedAxiom(OWLAxiom axiom) {
        if (ChangeTypeDetector.isTBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.TBOX_DEL);
        } else if (ChangeTypeDetector.isRBoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.RBOX_DEL);
        } else if (ChangeTypeDetector.isABoxAxiom(axiom)) {
            this.changes.add(KnowledgeBase.ChangeType.ABOX_DEL);
        }
    }

    @Override
    public void save(ZipOutputStream outputStream) throws IOException, IllegalStateException {
        if (!this.additions.isEmpty() || !this.deletions.isEmpty()) {
            throw new IllegalStateException("The module extractor contains unapplied changes to the modules, and therefore cannot be saved.");
        }
        ZipEntry axiomsEntry = new ZipEntry(MODULE_EXTRACTOR_AXIOMS_FILE_NAME);
        outputStream.putNextEntry(axiomsEntry);
        ModuleExtractorPersistence.saveAxioms(this.axioms, new UncloseableOutputStream(outputStream));
        ZipEntry modulesEntry = new ZipEntry(MODULE_EXTRACTOR_MODULES_FILE_NAME);
        outputStream.putNextEntry(modulesEntry);
        ModuleExtractorPersistence.saveModules(this.modules, new UncloseableOutputStream(outputStream));
        outputStream.flush();
    }

    @Override
    public void load(ZipInputStream inputStream) throws IOException, IllegalArgumentException {
        this.resetModules();
        ZipEntry zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_AXIOMS_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_AXIOMS_FILE_NAME));
        }
        Set axioms = OntologyUtils.loadAxioms((InputStream)inputStream);
        this.modules = null;
        this.additions.addAll(axioms);
        this.processAdditions();
        this.additions.clear();
        zipEntry = inputStream.getNextEntry();
        if (!MODULE_EXTRACTOR_MODULES_FILE_NAME.equals(zipEntry.getName())) {
            throw new IllegalArgumentException(String.format("Unexpected entry (%s) in ZipInputStream. Expected %s", zipEntry.getName(), MODULE_EXTRACTOR_MODULES_FILE_NAME));
        }
        this.modules = ModuleExtractorPersistence.loadModules(inputStream);
    }
}

