/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.source;

import java.io.InputStream;
import java.io.Reader;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.DataSink;
import org.semarglproject.source.AbstractSource;
import org.semarglproject.source.BaseStreamProcessor;
import org.semarglproject.source.XmlSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class StreamProcessor
extends BaseStreamProcessor {
    public static final String XML_READER_PROPERTY = "http://semarglproject.org/core/properties/xml-parser";
    public static final String ENABLE_ERROR_RECOVERY = "http://semarglproject.org/core/properties/enable-error-recovery";
    public static final String PROCESSOR_GRAPH_HANDLER_PROPERTY = "http://semarglproject.org/core/properties/processor-graph-handler";
    private final DataSink sink;
    private final AbstractSource source;

    public StreamProcessor(DataSink sink) {
        this.sink = sink;
        this.source = StreamProcessor.createSourceForSink(sink);
    }

    @Override
    public void processInternal(InputStream inputStream, String mimeType, String baseUri) throws ParseException {
        this.source.process(inputStream, mimeType, baseUri);
    }

    @Override
    protected void startStream() throws ParseException {
        this.sink.startStream();
    }

    @Override
    protected void endStream() throws ParseException {
        this.sink.endStream();
    }

    @Override
    public void processInternal(Reader reader, String mimeType, String baseUri) throws ParseException {
        this.source.process(reader, mimeType, baseUri);
    }

    @Override
    public boolean setProperty(String key, Object value) {
        boolean result = false;
        if (XML_READER_PROPERTY.equals(key) && value instanceof XMLReader && this.source instanceof XmlSource) {
            try {
                if (value != null) {
                    ((XmlSource)this.source).setXmlReader((XMLReader)value);
                    result = true;
                }
            }
            catch (SAXException e) {
                throw new IllegalArgumentException("XMLReader was not able to be initialized", e);
            }
        }
        return this.sink.setProperty(key, value) || result;
    }
}

