/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.inject.assistedinject.Assisted;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import uk.ac.manchester.cs.owl.owlapi.OWLImmutableOntologyImpl;

public class OWLOntologyImpl
extends OWLImmutableOntologyImpl
implements OWLMutableOntology,
Serializable {
    private static final long serialVersionUID = 40000L;

    @Inject
    public OWLOntologyImpl(@Nonnull @Assisted OWLOntologyManager manager, @Nonnull @Assisted OWLOntologyID ontologyID) {
        super(manager, ontologyID);
    }

    @Override
    public ChangeApplied applyChange(@Nonnull OWLOntologyChange change) {
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        return change.accept(changeFilter);
    }

    @Override
    @Nonnull
    public ChangeApplied applyChanges(@Nonnull List<? extends OWLOntologyChange> changes) {
        ChangeApplied appliedChanges = ChangeApplied.SUCCESSFULLY;
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ChangeApplied result = oWLOntologyChange.accept(changeFilter);
            if (appliedChanges != ChangeApplied.SUCCESSFULLY) continue;
            appliedChanges = result;
        }
        return appliedChanges;
    }

    @Override
    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> enactedChanges = new ArrayList<OWLOntologyChange>();
        ChangeApplied appliedChanges = ChangeApplied.SUCCESSFULLY;
        OWLOntologyChangeFilter changeFilter = new OWLOntologyChangeFilter();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ChangeApplied result = oWLOntologyChange.accept(changeFilter);
            if (result == ChangeApplied.SUCCESSFULLY) {
                enactedChanges.add(oWLOntologyChange);
            }
            if (appliedChanges != ChangeApplied.SUCCESSFULLY) continue;
            appliedChanges = result;
        }
        return new ChangeDetails(appliedChanges, enactedChanges);
    }

    @Override
    public ChangeApplied addAxiom(OWLAxiom axiom) {
        return this.getOWLOntologyManager().addAxiom(this, axiom);
    }

    @Override
    public ChangeApplied addAxioms(Set<? extends OWLAxiom> axioms) {
        return this.getOWLOntologyManager().addAxioms(this, axioms);
    }

    protected class OWLOntologyChangeFilter
    implements OWLOntologyChangeVisitorEx<ChangeApplied>,
    Serializable {
        private static final long serialVersionUID = 40000L;

        protected OWLOntologyChangeFilter() {
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveAxiom change) {
            if (OWLOntologyImpl.this.ints.removeAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (!id.equals(OWLOntologyImpl.this.ontologyID)) {
                OWLOntologyImpl.this.ontologyID = id;
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddAxiom change) {
            if (OWLOntologyImpl.this.ints.addAxiom(change.getAxiom())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddImport change) {
            if (OWLOntologyImpl.this.ints.addImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveImport change) {
            if (OWLOntologyImpl.this.ints.removeImportsDeclaration(change.getImportDeclaration())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull AddOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.addOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        @Override
        public ChangeApplied visit(@Nonnull RemoveOntologyAnnotation change) {
            if (OWLOntologyImpl.this.ints.removeOntologyAnnotation(change.getAnnotation())) {
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }
    }
}

