/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermFactory;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermLong;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import aterm.ParseError;
import aterm.pure.AFunImpl;
import aterm.pure.ATermApplImpl;
import aterm.pure.ATermBlobImpl;
import aterm.pure.ATermImpl;
import aterm.pure.ATermIntImpl;
import aterm.pure.ATermListImpl;
import aterm.pure.ATermLongImpl;
import aterm.pure.ATermPlaceholderImpl;
import aterm.pure.ATermReader;
import aterm.pure.ATermRealImpl;
import aterm.pure.binary.BAFReader;
import aterm.pure.binary.BinaryReader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import shared.SharedObject;
import shared.SharedObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PureFactory
extends SharedObjectFactory
implements ATermFactory {
    private static int DEFAULT_TERM_TABLE_SIZE = 16;
    private final ATermList empty;
    private static ATerm[] array0 = new ATerm[0];

    static boolean isBase64(int c) {
        return Character.isLetterOrDigit(c) || c == 43 || c == 47;
    }

    public static int abbrevSize(int abbrev) {
        int size = 1;
        if (abbrev == 0) {
            return 2;
        }
        while (abbrev > 0) {
            ++size;
            abbrev /= 64;
        }
        return size;
    }

    public PureFactory() {
        this(DEFAULT_TERM_TABLE_SIZE);
    }

    public PureFactory(int termTableSize) {
        super(termTableSize);
        ATermListImpl protoList = new ATermListImpl(this);
        protoList.init(240146486, null, null, null);
        this.empty = (ATermList)this.build((SharedObject)protoList);
        ((ATermListImpl)this.empty).init(240146486, this.empty, null, null);
    }

    @Override
    public ATermInt makeInt(int val) {
        return this.makeInt(val, this.empty);
    }

    @Override
    public ATermLong makeLong(long val) {
        return this.makeLong(val, this.empty);
    }

    @Override
    public ATermReal makeReal(double val) {
        return this.makeReal(val, this.empty);
    }

    @Override
    public ATermList makeList() {
        return this.empty;
    }

    @Override
    public ATermList makeList(ATerm singleton) {
        return this.makeList(singleton, this.empty, this.empty);
    }

    @Override
    public ATermList makeList(ATerm first, ATermList next) {
        return this.makeList(first, next, this.empty);
    }

    @Override
    public ATermPlaceholder makePlaceholder(ATerm type) {
        return this.makePlaceholder(type, this.empty);
    }

    @Override
    public ATermBlob makeBlob(byte[] data) {
        return this.makeBlob(data, this.empty);
    }

    @Override
    public AFun makeAFun(String name, int arity, boolean isQuoted) {
        return (AFun)this.build((SharedObject)new AFunImpl(this, name, arity, isQuoted));
    }

    public ATermInt makeInt(int value, ATermList annos) {
        return (ATermInt)this.build((SharedObject)new ATermIntImpl(this, annos, value));
    }

    public ATermLong makeLong(long value, ATermList annos) {
        return (ATermLong)this.build((SharedObject)new ATermLongImpl(this, annos, value));
    }

    public ATermReal makeReal(double value, ATermList annos) {
        return (ATermReal)this.build((SharedObject)new ATermRealImpl(this, annos, value));
    }

    public ATermPlaceholder makePlaceholder(ATerm type, ATermList annos) {
        return (ATermPlaceholder)this.build((SharedObject)new ATermPlaceholderImpl(this, annos, type));
    }

    public ATermBlob makeBlob(byte[] data, ATermList annos) {
        return (ATermBlob)this.build((SharedObject)new ATermBlobImpl(this, annos, data));
    }

    public ATermList makeList(ATerm first, ATermList next, ATermList annos) {
        return (ATermList)this.build((SharedObject)new ATermListImpl(this, annos, first, next));
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm[] args) {
        return this.makeAppl(fun, args, this.empty);
    }

    public ATermAppl makeAppl(AFun fun, ATerm[] args, ATermList annos) {
        return (ATermAppl)this.build((SharedObject)new ATermApplImpl(this, annos, fun, args));
    }

    @Override
    public ATermAppl makeApplList(AFun fun, ATermList list) {
        return this.makeApplList(fun, list, this.empty);
    }

    public ATermAppl makeApplList(AFun fun, ATermList list, ATermList annos) {
        ATerm[] arg_array = new ATerm[list.getLength()];
        int i = 0;
        while (!list.isEmpty()) {
            arg_array[i++] = list.getFirst();
            list = list.getNext();
        }
        return this.makeAppl(fun, arg_array, annos);
    }

    @Override
    public ATermAppl makeAppl(AFun fun) {
        return this.makeAppl(fun, array0);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg) {
        ATerm[] argarray1 = new ATerm[]{arg};
        return this.makeAppl(fun, argarray1);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2) {
        ATerm[] argarray2 = new ATerm[]{arg1, arg2};
        return this.makeAppl(fun, argarray2);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3) {
        ATerm[] argarray3 = new ATerm[]{arg1, arg2, arg3};
        return this.makeAppl(fun, argarray3);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4) {
        ATerm[] argarray4 = new ATerm[]{arg1, arg2, arg3, arg4};
        return this.makeAppl(fun, argarray4);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5) {
        ATerm[] argarray5 = new ATerm[]{arg1, arg2, arg3, arg4, arg5};
        return this.makeAppl(fun, argarray5);
    }

    @Override
    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6};
        return this.makeAppl(fun, args);
    }

    public ATermAppl makeAppl(AFun fun, ATerm arg1, ATerm arg2, ATerm arg3, ATerm arg4, ATerm arg5, ATerm arg6, ATerm arg7) {
        ATerm[] args = new ATerm[]{arg1, arg2, arg3, arg4, arg5, arg6, arg7};
        return this.makeAppl(fun, args);
    }

    public ATermList getEmpty() {
        return this.empty;
    }

    private ATerm parseAbbrev(ATermReader reader) throws IOException {
        int c = reader.read();
        int abbrev = 0;
        while (PureFactory.isBase64(c)) {
            abbrev *= 64;
            if (c >= 65 && c <= 90) {
                abbrev += c - 65;
            } else if (c >= 97 && c <= 122) {
                abbrev += c - 97 + 26;
            } else if (c >= 48 && c <= 57) {
                abbrev += c - 48 + 52;
            } else if (c == 43) {
                abbrev += 62;
            } else if (c == 47) {
                abbrev += 63;
            } else {
                throw new RuntimeException("not a base-64 digit: " + c);
            }
            c = reader.read();
        }
        ATerm result = reader.getTerm(abbrev);
        return result;
    }

    private ATerm parseNumber(ATermReader reader) throws IOException {
        ATerm result;
        StringBuilder str = new StringBuilder();
        do {
            str.append((char)reader.getLastChar());
        } while (Character.isDigit(reader.read()));
        if (reader.getLastChar() != 46 && reader.getLastChar() != 101 && reader.getLastChar() != 69 && reader.getLastChar() != 108 && reader.getLastChar() != 76) {
            int val;
            try {
                val = Integer.parseInt(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed int");
            }
            result = this.makeInt(val);
        } else if (reader.getLastChar() == 108 || reader.getLastChar() == 76) {
            long val;
            reader.read();
            try {
                val = Long.parseLong(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed long");
            }
            result = this.makeLong(val);
        } else {
            double val;
            if (reader.getLastChar() == 46) {
                str.append('.');
                reader.read();
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new ParseError("digit expected");
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            if (reader.getLastChar() == 101 || reader.getLastChar() == 69) {
                str.append((char)reader.getLastChar());
                reader.read();
                if (reader.getLastChar() == 45 || reader.getLastChar() == 43) {
                    str.append((char)reader.getLastChar());
                    reader.read();
                }
                if (!Character.isDigit(reader.getLastChar())) {
                    throw new ParseError("digit expected!");
                }
                do {
                    str.append((char)reader.getLastChar());
                } while (Character.isDigit(reader.read()));
            }
            try {
                val = Double.valueOf(str.toString());
            }
            catch (NumberFormatException e) {
                throw new ParseError("malformed real");
            }
            result = this.makeReal(val);
        }
        return result;
    }

    private String parseId(ATermReader reader) throws IOException {
        int c = reader.getLastChar();
        StringBuilder buf = new StringBuilder(32);
        do {
            buf.append((char)c);
        } while (Character.isLetterOrDigit(c = reader.read()) || c == 95 || c == 45 || c == 43 || c == 42 || c == 36);
        return buf.toString();
    }

    private String parseString(ATermReader reader) throws IOException {
        boolean escaped;
        StringBuilder str = new StringBuilder();
        do {
            int lastChar;
            escaped = false;
            if (reader.read() == 92) {
                reader.read();
                escaped = true;
            }
            if ((lastChar = reader.getLastChar()) == -1) {
                throw new ParseError("Unterminated quoted function symbol: " + str);
            }
            if (escaped) {
                switch (lastChar) {
                    case 110: {
                        str.append('\n');
                        break;
                    }
                    case 116: {
                        str.append('\t');
                        break;
                    }
                    case 98: {
                        str.append('\b');
                        break;
                    }
                    case 114: {
                        str.append('\r');
                        break;
                    }
                    case 102: {
                        str.append('\f');
                        break;
                    }
                    case 92: {
                        str.append('\\');
                        break;
                    }
                    case 39: {
                        str.append('\'');
                        break;
                    }
                    case 34: {
                        str.append('\"');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        str.append(reader.readOct());
                        break;
                    }
                    default: {
                        str.append('\\').append((char)reader.getLastChar());
                        break;
                    }
                }
                continue;
            }
            if (lastChar == 34) continue;
            str.append((char)lastChar);
        } while (escaped || reader.getLastChar() != 34);
        return str.toString();
    }

    private ATermList parseATerms(ATermReader reader) throws IOException {
        ATerm[] terms = this.parseATermsArray(reader);
        ATermList result = this.empty;
        for (int i = terms.length - 1; i >= 0; --i) {
            result = this.makeList(terms[i], result);
        }
        return result;
    }

    private ATerm[] parseATermsArray(ATermReader reader) throws IOException {
        ArrayList<ATerm> list = new ArrayList<ATerm>();
        ATerm term = this.parseFromReader(reader);
        list.add(term);
        while (reader.getLastChar() == 44) {
            reader.readSkippingWS();
            term = this.parseFromReader(reader);
            list.add(term);
        }
        ATerm[] array = new ATerm[list.size()];
        ListIterator iter = list.listIterator();
        int index = 0;
        while (iter.hasNext()) {
            array[index++] = (ATerm)iter.next();
        }
        return array;
    }

    private ATerm parseFromReader(ATermReader reader) throws IOException {
        ATerm result;
        int start = reader.getPosition();
        switch (reader.getLastChar()) {
            case -1: {
                throw new ParseError("premature EOF encountered.");
            }
            case 35: {
                return this.parseAbbrev(reader);
            }
            case 91: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (c == 93) {
                    c = reader.readSkippingWS();
                    result = this.empty;
                    break;
                }
                result = this.parseATerms(reader);
                if (reader.getLastChar() != 93) {
                    throw new ParseError("expected ']' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                break;
            }
            case 60: {
                int c = reader.readSkippingWS();
                ATerm ph = this.parseFromReader(reader);
                if (reader.getLastChar() != 62) {
                    throw new ParseError("expected '>' but got '" + (char)reader.getLastChar() + "'");
                }
                c = reader.readSkippingWS();
                result = this.makePlaceholder(ph);
                break;
            }
            case 34: {
                String funname = this.parseString(reader);
                int c = reader.readSkippingWS();
                if (reader.getLastChar() == 40) {
                    c = reader.readSkippingWS();
                    if (c == -1) {
                        throw new ParseError("premature EOF encountered.");
                    }
                    if (reader.getLastChar() == 41) {
                        result = this.makeAppl(this.makeAFun(funname, 0, true));
                    } else {
                        ATerm[] list = this.parseATermsArray(reader);
                        if (reader.getLastChar() != 41) {
                            throw new ParseError("expected ')' but got '" + reader.getLastChar() + "'");
                        }
                        result = this.makeAppl(this.makeAFun(funname, list.length, true), list);
                    }
                    c = reader.readSkippingWS();
                    break;
                }
                result = this.makeAppl(this.makeAFun(funname, 0, true));
                break;
            }
            case 40: {
                int c = reader.readSkippingWS();
                if (c == -1) {
                    throw new ParseError("premature EOF encountered.");
                }
                if (reader.getLastChar() == 41) {
                    result = this.makeAppl(this.makeAFun("", 0, false));
                } else {
                    ATerm[] list = this.parseATermsArray(reader);
                    if (reader.getLastChar() != 41) {
                        throw new ParseError("expected ')' but got '" + (char)reader.getLastChar() + "'");
                    }
                    result = this.makeAppl(this.makeAFun("", list.length, false), list);
                }
                c = reader.readSkippingWS();
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                result = this.parseNumber(reader);
                int c = reader.skipWS();
                break;
            }
            default: {
                int c = reader.getLastChar();
                if (Character.isLetter(c)) {
                    String funname = this.parseId(reader);
                    c = reader.skipWS();
                    if (reader.getLastChar() == 40) {
                        c = reader.readSkippingWS();
                        if (c == -1) {
                            throw new ParseError("premature EOF encountered.");
                        }
                        if (reader.getLastChar() == 41) {
                            result = this.makeAppl(this.makeAFun(funname, 0, false));
                        } else {
                            ATerm[] list = this.parseATermsArray(reader);
                            if (reader.getLastChar() != 41) {
                                throw new ParseError("expected ')' but got '" + (char)reader.getLastChar() + "'");
                            }
                            result = this.makeAppl(this.makeAFun(funname, list.length, false), list);
                        }
                        c = reader.readSkippingWS();
                        break;
                    }
                    result = this.makeAppl(this.makeAFun(funname, 0, false));
                    break;
                }
                throw new ParseError("illegal character: '" + (char)reader.getLastChar() + "'");
            }
        }
        if (reader.getLastChar() == 123) {
            ATermList annos;
            if (reader.readSkippingWS() == 125) {
                reader.readSkippingWS();
                annos = this.empty;
            } else {
                annos = this.parseATerms(reader);
                if (reader.getLastChar() != 125) {
                    throw new ParseError("'}' expected '" + (char)reader.getLastChar() + "'");
                }
                reader.readSkippingWS();
            }
            result = result.setAnnotations(annos);
        }
        if (reader.getLastChar() == 58) {
            reader.read();
            ATerm anno = this.parseFromReader(reader);
            result = result.setAnnotation(this.parse("type"), anno);
        }
        if (reader.getLastChar() == 63) {
            reader.readSkippingWS();
            result = result.setAnnotation(this.parse("result"), this.parse("true"));
        }
        int end = reader.getPosition();
        reader.storeNextTerm(result, end - start);
        return result;
    }

    @Override
    public ATerm parse(String trm) {
        try {
            ATermReader reader = new ATermReader(new StringReader(trm), trm.length());
            reader.readSkippingWS();
            ATerm result = this.parseFromReader(reader);
            return result;
        }
        catch (IOException e) {
            throw new ParseError("premature end of string");
        }
    }

    @Override
    public ATerm make(String trm) {
        return this.parse(trm);
    }

    @Override
    public ATerm make(String pattern, List<Object> args) {
        return this.make(this.parse(pattern), args);
    }

    @Override
    public ATerm make(String pattern, Object arg1) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        args.add(arg6);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(String pattern, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) {
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        args.add(arg6);
        args.add(arg7);
        return this.make(pattern, args);
    }

    @Override
    public ATerm make(ATerm pattern, List<Object> args) {
        return pattern.make(args);
    }

    ATerm parsePattern(String pattern) throws ParseError {
        return this.parse(pattern);
    }

    protected boolean isDeepEqual(ATermImpl t1, ATerm t2) {
        throw new UnsupportedOperationException("not yet implemented!");
    }

    private ATerm readFromSharedTextFile(ATermReader reader) throws IOException {
        reader.initializeSharing();
        return this.parseFromReader(reader);
    }

    private ATerm readFromTextFile(ATermReader reader) throws IOException {
        return this.parseFromReader(reader);
    }

    @Override
    public ATerm readFromTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
        reader.readSkippingWS();
        return this.readFromTextFile(reader);
    }

    @Override
    public ATerm readFromSharedTextFile(InputStream stream) throws IOException {
        ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
        reader.readSkippingWS();
        if (reader.getLastChar() != 33) {
            throw new IOException("not a shared text file!");
        }
        reader.readSkippingWS();
        return this.readFromSharedTextFile(reader);
    }

    @Override
    public ATerm readFromBinaryFile(InputStream stream) throws IOException {
        return this.readFromBinaryFile(stream, false);
    }

    private ATerm readFromBinaryFile(InputStream stream, boolean headerRead) throws ParseError, IOException {
        BAFReader r = new BAFReader(this, stream);
        return r.readFromBinaryFile(headerRead);
    }

    private ATerm readSAFFromOldStyleStream(InputStream stream) throws IOException {
        int nrOfBytesRead;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((nrOfBytesRead = stream.read(buffer, 0, buffer.length)) != -1) {
            baos.write(buffer, 0, nrOfBytesRead);
        }
        return BinaryReader.readTermFromSAFString(this, baos.toByteArray());
    }

    @Override
    public ATerm readFromFile(InputStream stream) throws IOException {
        BufferedInputStream bis;
        int firstToken;
        do {
            if ((firstToken = stream.read()) != -1) continue;
            throw new IOException("Premature EOF.");
        } while (Character.isWhitespace((char)firstToken));
        char typeByte = (char)firstToken;
        if (typeByte == '!') {
            ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
            reader.readSkippingWS();
            return this.readFromSharedTextFile(reader);
        }
        if (typeByte == '?') {
            return this.readSAFFromOldStyleStream(stream);
        }
        if (Character.isLetterOrDigit(typeByte) || typeByte == '_' || typeByte == '[' || typeByte == '-') {
            ATermReader reader = new ATermReader(new BufferedReader(new InputStreamReader(stream)));
            reader.last_char = typeByte;
            return this.readFromTextFile(reader);
        }
        if (firstToken == 0 && BAFReader.isBinaryATerm(bis = new BufferedInputStream(stream))) {
            return this.readFromBinaryFile(bis, true);
        }
        throw new RuntimeException("Unsupported file type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ATerm readFromFile(String filename) throws IOException {
        ATerm result;
        FileInputStream fis = new FileInputStream(filename);
        try {
            result = this.readFromFile(fis);
        }
        finally {
            fis.close();
        }
        return result;
    }

    @Override
    public ATerm importTerm(ATerm term) {
        ATerm result;
        SharedObject object = (SharedObject)term;
        if (this.contains(object)) {
            return term;
        }
        switch (term.getType()) {
            case 1: {
                ATermAppl appl = (ATermAppl)term;
                AFun fun = (AFun)this.importTerm(appl.getAFun());
                int nrOfArguments = appl.getArity();
                ATerm[] newArguments = new ATerm[nrOfArguments];
                for (int i = nrOfArguments - 1; i >= 0; --i) {
                    newArguments[i] = this.importTerm(appl.getArgument(i));
                }
                result = this.makeAppl(fun, newArguments);
                break;
            }
            case 4: {
                ATermList list = (ATermList)term;
                if (list.isEmpty()) {
                    result = this.empty;
                    break;
                }
                ATerm first = this.importTerm(list.getFirst());
                ATermList next = (ATermList)this.importTerm(list.getNext());
                result = this.makeList(first, next);
                break;
            }
            case 2: {
                ATermInt integer = (ATermInt)term;
                result = this.makeInt(integer.getInt());
                break;
            }
            case 8: {
                ATermLong elongatedType = (ATermLong)term;
                result = this.makeLong(elongatedType.getLong());
                break;
            }
            case 3: {
                ATermReal real = (ATermReal)term;
                result = this.makeReal(real.getReal());
                break;
            }
            case 5: {
                ATermPlaceholder placeHolder = (ATermPlaceholder)term;
                result = this.makePlaceholder(this.importTerm(placeHolder.getPlaceholder()));
                break;
            }
            case 7: {
                AFun afun = (AFun)term;
                return this.makeAFun(afun.getName(), afun.getArity(), afun.isQuoted());
            }
            default: {
                throw new RuntimeException("Unknown term type id: " + term.getType());
            }
        }
        if (term.hasAnnotations()) {
            ATermList annotations = term.getAnnotations();
            result = result.setAnnotations(annotations);
        }
        return result;
    }
}

