/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.oboformat.writer;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.OWLAPIObo2Owl;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.StringComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBOFormatWriter {
    private static final Logger LOG = LoggerFactory.getLogger(OBOFormatWriter.class);
    @Nonnull
    private static final Set<String> TAGSINFORMATIVE = OBOFormatWriter.buildTagsInformative();
    private boolean isCheckStructure = true;

    public boolean isCheckStructure() {
        return this.isCheckStructure;
    }

    public void setCheckStructure(boolean isCheckStructure) {
        this.isCheckStructure = isCheckStructure;
    }

    @Nonnull
    private static Set<String> buildTagsInformative() {
        HashSet<String> set = new HashSet<String>();
        set.add(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN.getTag());
        set.add(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER.getTag());
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(@Nonnull String fn, @Nonnull BufferedWriter writer) throws IOException {
        if (fn.startsWith("http:")) {
            this.write(new URL(fn), writer);
        } else {
            try (BufferedReader reader = new BufferedReader(new FileReader(new File(fn)));){
                this.write(reader, writer);
            }
        }
    }

    public void write(@Nonnull URL url, @Nonnull BufferedWriter writer) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        this.write(reader, writer);
    }

    public void write(BufferedReader reader, @Nonnull BufferedWriter writer) throws IOException {
        OBOFormatParser parser = new OBOFormatParser();
        OBODoc doc = parser.parse(reader);
        this.write(doc, writer);
    }

    public void write(@Nonnull OBODoc doc, @Nonnull String outFilename) throws IOException {
        this.write(doc, new File(outFilename));
    }

    public void write(@Nonnull OBODoc doc, @Nonnull File outFile) throws IOException {
        FileOutputStream os = new FileOutputStream(outFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF-8");
        BufferedWriter bw = new BufferedWriter(osw);
        this.write(doc, bw);
        bw.close();
    }

    public void write(@Nonnull OBODoc doc, @Nonnull BufferedWriter writer) throws IOException {
        OBODocNameProvider nameProvider = new OBODocNameProvider(doc);
        this.write(doc, writer, (NameProvider)nameProvider);
    }

    public void write(@Nonnull OBODoc doc, @Nonnull BufferedWriter writer, NameProvider nameProvider) throws IOException {
        if (this.isCheckStructure) {
            doc.check();
        }
        Frame headerFrame = doc.getHeaderFrame();
        this.writeHeader(headerFrame, writer, nameProvider);
        ArrayList<Frame> termFrames = new ArrayList<Frame>();
        termFrames.addAll(doc.getTermFrames());
        Collections.sort(termFrames, FramesComparator.INSTANCE);
        ArrayList<Frame> typeDefFrames = new ArrayList<Frame>();
        typeDefFrames.addAll(doc.getTypedefFrames());
        Collections.sort(typeDefFrames, FramesComparator.INSTANCE);
        ArrayList instanceFrames = new ArrayList();
        typeDefFrames.addAll(doc.getInstanceFrames());
        Collections.sort(instanceFrames, FramesComparator.INSTANCE);
        for (Frame f : termFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : typeDefFrames) {
            this.write(f, writer, nameProvider);
        }
        for (Frame f : instanceFrames) {
            this.write(f, writer, nameProvider);
        }
        writer.flush();
    }

    private static void writeLine(@Nonnull StringBuilder ln, @Nonnull BufferedWriter writer) throws IOException {
        ln.append('\n');
        writer.write(ln.toString());
    }

    private static void writeLine(String ln, @Nonnull BufferedWriter writer) throws IOException {
        writer.write(ln + '\n');
    }

    private static void writeEmptyLine(@Nonnull BufferedWriter writer) throws IOException {
        writer.write("\n");
    }

    @Nonnull
    private static List<String> duplicateTags(@Nonnull Set<String> src) {
        ArrayList<String> tags = new ArrayList<String>(src.size());
        for (String tag : src) {
            tags.add(tag);
        }
        return tags;
    }

    public void writeHeader(@Nonnull Frame frame, @Nonnull BufferedWriter writer, NameProvider nameProvider) throws IOException {
        List<String> tags = OBOFormatWriter.duplicateTags(frame.getTags());
        Collections.sort(tags, HeaderTagsComparator.INSTANCE);
        OBOFormatWriter.write(new Clause(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag(), "1.2"), writer, nameProvider);
        for (String tag : tags) {
            if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag())) continue;
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, ClauseComparator.INSTANCE);
            for (Clause clause : clauses) {
                assert (clause != null);
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag())) {
                    OBOFormatWriter.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag())) {
                    OBOFormatWriter.writeSynonymtypedef(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_DATE.getTag())) {
                    OBOFormatWriter.writeHeaderDate(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag())) {
                    OBOFormatWriter.writePropertyValue(clause, writer);
                    continue;
                }
                if (tag.equals(OBOFormatConstants.OboFormatTag.TAG_IDSPACE.getTag())) {
                    OBOFormatWriter.writeIdSpace(clause, writer);
                    continue;
                }
                OBOFormatWriter.write(clause, writer, nameProvider);
            }
        }
        OBOFormatWriter.writeEmptyLine(writer);
    }

    public void write(@Nonnull Frame frame, @Nonnull BufferedWriter writer, @Nullable NameProvider nameProvider) throws IOException {
        Object comparator = null;
        if (frame.getType() == Frame.FrameType.TERM) {
            OBOFormatWriter.writeLine("[Term]", writer);
            comparator = TermsTagsComparator.INSTANCE;
        } else if (frame.getType() == Frame.FrameType.TYPEDEF) {
            OBOFormatWriter.writeLine("[Typedef]", writer);
            comparator = TypeDefTagsComparator.INSTANCE;
        } else if (frame.getType() == Frame.FrameType.INSTANCE) {
            OBOFormatWriter.writeLine("[Instance]", writer);
            comparator = TypeDefTagsComparator.INSTANCE;
        }
        if (frame.getId() != null) {
            Object label = frame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_NAME);
            String extra = "";
            if (label == null && nameProvider != null && (label = nameProvider.getName(frame.getId())) != null) {
                extra = " ! " + label;
            }
            OBOFormatWriter.writeLine(OBOFormatConstants.OboFormatTag.TAG_ID.getTag() + ": " + frame.getId() + extra, writer);
        }
        List<String> tags = OBOFormatWriter.duplicateTags(frame.getTags());
        Collections.sort(tags, comparator);
        String defaultOboNamespace = null;
        if (nameProvider != null) {
            defaultOboNamespace = nameProvider.getDefaultOboNamespace();
        }
        for (String tag : tags) {
            ArrayList<Clause> clauses = new ArrayList<Clause>(frame.getClauses(tag));
            Collections.sort(clauses, ClauseComparator.INSTANCE);
            for (Clause clause : clauses) {
                String clauseTag = clause.getTag();
                if (OBOFormatConstants.OboFormatTag.TAG_ID.getTag().equals(clauseTag)) continue;
                if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeDef(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeSynonym(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writePropertyValue(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clauseTag) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_XREF.getTag().equals(clauseTag)) {
                    OBOFormatWriter.writeXRefClause(clause, writer);
                    continue;
                }
                if (OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag().equals(clauseTag)) {
                    if (defaultOboNamespace != null && clause.getValue().equals(defaultOboNamespace)) continue;
                    OBOFormatWriter.write(clause, writer, nameProvider);
                    continue;
                }
                OBOFormatWriter.write(clause, writer, nameProvider);
            }
        }
        OBOFormatWriter.writeEmptyLine(writer);
    }

    private static void writeXRefClause(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        Xref xref = clause.getValue(Xref.class);
        if (xref != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(clause.getTag());
            sb.append(": ");
            String idref = xref.getIdref();
            int colonPos = idref.indexOf(58);
            if (colonPos > 0) {
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(0, colonPos), EscapeMode.xref));
                sb.append(':');
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(colonPos + 1), EscapeMode.xref));
            } else {
                sb.append(OBOFormatWriter.escapeOboString(idref, EscapeMode.xref));
            }
            String annotation = xref.getAnnotation();
            if (annotation != null) {
                sb.append(" \"");
                sb.append(OBOFormatWriter.escapeOboString(annotation, EscapeMode.quotes));
                sb.append('\"');
            }
            OBOFormatWriter.appendQualifiers(sb, clause);
            OBOFormatWriter.writeLine(sb, writer);
        }
    }

    private static void writeSynonymtypedef(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        Collection<Object> values = clause.getValues();
        for (int i = 0; i < values.size(); ++i) {
            String value = valuesIterator.next().toString();
            assert (value != null);
            if (i == 1) {
                sb.append('\"');
            }
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.quotes));
            if (i == 1) {
                sb.append('\"');
            }
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeHeaderDate(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Object value = clause.getValue();
        assert (value != null);
        if (value instanceof Date) {
            sb.append(OBOFormatConstants.headerDateFormat().format((Date)value));
        } else if (value instanceof String) {
            sb.append(value);
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Unknown datatype ('{}') for value in clause: {}", (Object)value.getClass().getName(), (Object)clause);
            sb.append(value);
        }
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeIdSpace(@Nonnull Clause cl, @Nonnull BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder(cl.getTag());
        sb.append(": ");
        Collection<Object> values = cl.getValues();
        Iterator<Object> iterator = values.iterator();
        for (int i = 0; iterator.hasNext() && i < 3; ++i) {
            String value = iterator.next().toString();
            assert (value != null);
            if (i == 2) {
                sb.append('\"').append(OBOFormatWriter.escapeOboString(value, EscapeMode.quotes)).append('\"');
                continue;
            }
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.simple)).append(' ');
        }
        OBOFormatWriter.appendQualifiers(sb, cl);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void writeClauseWithQuotedString(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        boolean first = true;
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        while (valuesIterator.hasNext()) {
            if (first) {
                sb.append('\"');
            }
            String value = valuesIterator.next().toString();
            assert (value != null);
            sb.append(OBOFormatWriter.escapeOboString(value, EscapeMode.quotes));
            if (first) {
                sb.append('\"');
            }
            if (valuesIterator.hasNext()) {
                sb.append(' ');
            }
            first = false;
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (!xrefs.isEmpty()) {
            OBOFormatWriter.appendXrefs(sb, xrefs);
        } else if (OBOFormatConstants.OboFormatTag.TAG_DEF.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag().equals(clause.getTag()) || OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag().equals(clause.getTag())) {
            sb.append(" []");
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static void appendXrefs(@Nonnull StringBuilder sb, @Nonnull Collection<Xref> xrefs) {
        ArrayList<Xref> sortedXrefs = new ArrayList<Xref>(xrefs);
        Collections.sort(sortedXrefs, XrefComparator.INSTANCE);
        sb.append(" [");
        Iterator xrefsIterator = sortedXrefs.iterator();
        while (xrefsIterator.hasNext()) {
            Xref current = (Xref)xrefsIterator.next();
            String idref = current.getIdref();
            int colonPos = idref.indexOf(58);
            if (colonPos > 0) {
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(0, colonPos), EscapeMode.xrefList));
                sb.append(':');
                sb.append(OBOFormatWriter.escapeOboString(idref.substring(colonPos + 1), EscapeMode.xrefList));
            } else {
                sb.append(OBOFormatWriter.escapeOboString(idref, EscapeMode.xrefList));
            }
            String annotation = current.getAnnotation();
            if (annotation != null) {
                sb.append(' ');
                sb.append('\"');
                sb.append(OBOFormatWriter.escapeOboString(annotation, EscapeMode.quotes));
                sb.append('\"');
            }
            if (!xrefsIterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
    }

    public static void writeDef(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
    }

    public static void writePropertyValue(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        Collection<Object> cols = clause.getValues();
        if (cols.size() < 2) {
            LOG.error("The {} has incorrect number of values: {}", (Object)OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), (Object)clause);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> it = cols.iterator();
        String property = it.next().toString();
        assert (property != null);
        sb.append(OBOFormatWriter.escapeOboString(property, EscapeMode.simple));
        while (it.hasNext()) {
            sb.append(' ');
            String val = it.next().toString();
            if (val.contains(" ") || !val.contains(":")) {
                sb.append('\"');
                sb.append(OBOFormatWriter.escapeOboString(val, EscapeMode.quotes));
                sb.append('\"');
                continue;
            }
            sb.append(OBOFormatWriter.escapeOboString(val, EscapeMode.simple));
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        OBOFormatWriter.writeLine(sb, writer);
    }

    public static void writeSynonym(@Nonnull Clause clause, @Nonnull BufferedWriter writer) throws IOException {
        OBOFormatWriter.writeClauseWithQuotedString(clause, writer);
    }

    public static void write(@Nonnull Clause clause, @Nonnull BufferedWriter writer, @Nullable NameProvider nameProvider) throws IOException {
        String trimmed;
        Object value;
        if (OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag().equals(clause.getTag()) && ((value = clause.getValue()) instanceof Boolean ? Boolean.FALSE.equals(value) : !Boolean.TRUE.toString().equals(value))) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(clause.getTag());
        sb.append(": ");
        Iterator<Object> valuesIterator = clause.getValues().iterator();
        StringBuilder idsLabel = null;
        if (nameProvider != null && TAGSINFORMATIVE.contains(clause.getTag())) {
            idsLabel = new StringBuilder();
        }
        while (valuesIterator.hasNext()) {
            String label;
            String value2 = valuesIterator.next().toString();
            assert (value2 != null);
            if (idsLabel != null && nameProvider != null && (label = nameProvider.getName(value2)) != null && (OBOFormatWriter.isOpaqueIdentifier(value2) || !valuesIterator.hasNext())) {
                if (idsLabel.length() > 0) {
                    idsLabel.append(' ');
                }
                idsLabel.append(label);
            }
            EscapeMode mode = EscapeMode.most;
            if (OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag().equals(clause.getTag())) {
                mode = EscapeMode.parenthesis;
            }
            sb.append(OBOFormatWriter.escapeOboString(value2, mode));
            if (!valuesIterator.hasNext()) continue;
            sb.append(' ');
        }
        Collection<Xref> xrefs = clause.getXrefs();
        if (!xrefs.isEmpty()) {
            OBOFormatWriter.appendXrefs(sb, xrefs);
        }
        OBOFormatWriter.appendQualifiers(sb, clause);
        if (idsLabel != null && idsLabel.length() > 0 && !(trimmed = idsLabel.toString().trim()).isEmpty()) {
            sb.append(" ! ");
            sb.append(trimmed);
        }
        OBOFormatWriter.writeLine(sb, writer);
    }

    private static boolean isOpaqueIdentifier(@Nullable String value) {
        int colonPos;
        boolean result = false;
        if (value != null && !value.isEmpty() && (colonPos = value.indexOf(58)) > 0 && value.length() > colonPos + 1) {
            result = true;
            for (int i = colonPos; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Character.isDigit(c) || c == ':') continue;
                result = false;
                break;
            }
        }
        return result;
    }

    private static void appendQualifiers(@Nonnull StringBuilder sb, @Nonnull Clause clause) {
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        if (!qvs.isEmpty()) {
            sb.append(" {");
            Iterator<QualifierValue> qvsIterator = qvs.iterator();
            while (qvsIterator.hasNext()) {
                QualifierValue qv = qvsIterator.next();
                sb.append(qv.getQualifier());
                sb.append("=\"");
                sb.append(OBOFormatWriter.escapeOboString(qv.getValue(), EscapeMode.quotes));
                sb.append('\"');
                if (!qvsIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append('}');
        }
    }

    @Nonnull
    private static CharSequence escapeOboString(@Nonnull String in, EscapeMode mode) {
        boolean modfied = false;
        StringBuilder sb = new StringBuilder();
        int length = in.length();
        for (int i = 0; i < length; ++i) {
            char c = in.charAt(i);
            if (c == '\n') {
                modfied = true;
                sb.append("\\n");
                continue;
            }
            if (c == '\\') {
                modfied = true;
                sb.append("\\\\");
                continue;
            }
            if (c == '\"' && (mode == EscapeMode.most || mode == EscapeMode.quotes)) {
                modfied = true;
                sb.append("\\\"");
                continue;
            }
            if (c == '{' && (mode == EscapeMode.most || mode == EscapeMode.parenthesis)) {
                modfied = true;
                sb.append("\\{");
                continue;
            }
            if (c == ',' && (mode == EscapeMode.xref || mode == EscapeMode.xrefList)) {
                modfied = true;
                sb.append("\\,");
                continue;
            }
            if (c == ':' && (mode == EscapeMode.xref || mode == EscapeMode.xrefList)) {
                modfied = true;
                sb.append("\\:");
                continue;
            }
            if (c == ']' && mode == EscapeMode.xrefList) {
                modfied = true;
                sb.append("\\]");
                continue;
            }
            sb.append(c);
        }
        if (modfied) {
            return sb;
        }
        return in;
    }

    public static void sortTermClauses(@Nonnull List<Clause> clauses) {
        Collections.sort(clauses, ClauseListComparator.INSTANCE);
    }

    public static class OWLOntologyNameProvider
    implements NameProvider {
        @Nonnull
        private final OWLOntology ont;
        @Nullable
        private final String defaultOboNamespace;

        public OWLOntologyNameProvider(@Nonnull OWLOntology ont, String defaultOboNamespace) {
            this.ont = ont;
            this.defaultOboNamespace = defaultOboNamespace;
        }

        @Override
        public String getName(String id) {
            OWLAPIObo2Owl obo2owl = new OWLAPIObo2Owl(this.ont.getOWLOntologyManager());
            IRI iri = obo2owl.oboIdToIRI(id);
            Set axioms = this.ont.getAxioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)iri, Imports.INCLUDED, Navigation.IN_SUB_POSITION);
            for (OWLAnnotationAssertionAxiom axiom : axioms) {
                OWLAnnotationValue value;
                if (!axiom.getProperty().isLabel() || !((value = axiom.getValue()) instanceof OWLLiteral)) continue;
                return ((OWLLiteral)value).getLiteral();
            }
            return null;
        }

        @Override
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    public static class OBODocNameProvider
    implements NameProvider {
        @Nonnull
        private final OBODoc oboDoc;
        @Nullable
        private final String defaultOboNamespace;

        public OBODocNameProvider(@Nonnull OBODoc oboDoc) {
            this.oboDoc = oboDoc;
            Frame headerFrame = oboDoc.getHeaderFrame();
            this.defaultOboNamespace = headerFrame != null ? headerFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE, String.class) : null;
        }

        @Override
        @Nullable
        public String getName(String id) {
            Clause cl;
            String name = null;
            Frame frame = this.oboDoc.getTermFrame(id);
            if (frame == null) {
                frame = this.oboDoc.getTypedefFrame(id);
            }
            if (frame != null && (cl = frame.getClause(OBOFormatConstants.OboFormatTag.TAG_NAME)) != null) {
                name = cl.getValue(String.class);
            }
            return name;
        }

        @Override
        @Nullable
        public String getDefaultOboNamespace() {
            return this.defaultOboNamespace;
        }
    }

    public static interface NameProvider {
        @Nullable
        public String getName(@Nonnull String var1);

        @Nullable
        public String getDefaultOboNamespace();
    }

    private static class XrefComparator
    implements Comparator<Xref>,
    Serializable {
        static final XrefComparator INSTANCE = new XrefComparator();
        private static final long serialVersionUID = 40000L;

        private XrefComparator() {
        }

        @Override
        public int compare(Xref o1, Xref o2) {
            String idref1 = o1.getIdref();
            String idref2 = o2.getIdref();
            return idref1.compareToIgnoreCase(idref2);
        }
    }

    private static class ClauseComparator
    implements Comparator<Clause>,
    Serializable {
        static final ClauseComparator INSTANCE = new ClauseComparator();
        private static final long serialVersionUID = 40000L;

        private ClauseComparator() {
        }

        @Override
        public int compare(Clause o1, Clause o2) {
            int comp;
            String tag = o1.getTag();
            if (OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag().equals(tag)) {
                int s2;
                int s1 = o1.getValues().size();
                if (s1 < (s2 = o2.getValues().size())) {
                    return -1;
                }
                if (s1 > s2) {
                    return 1;
                }
            }
            if ((comp = ClauseComparator.compareValues(o1.getValue(), o2.getValue())) != 0) {
                return comp;
            }
            return ClauseComparator.compareValues(o1.getValue2(), o2.getValue2());
        }

        private static int compareValues(@Nullable Object o1, @Nullable Object o2) {
            String s2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String s1 = ClauseComparator.toStringRepresentation(o1);
            int comp = s1.compareToIgnoreCase(s2 = ClauseComparator.toStringRepresentation(o2));
            if (comp == 0) {
                comp = s1.compareTo(s2);
            }
            return comp;
        }

        @Nullable
        private static String toStringRepresentation(@Nullable Object obj) {
            String s = null;
            if (obj != null) {
                if (obj instanceof Xref) {
                    Xref xref = (Xref)obj;
                    s = xref.getIdref() + ' ' + xref.getAnnotation();
                } else {
                    s = obj instanceof String ? (String)obj : obj.toString();
                }
            }
            return s;
        }
    }

    private static class FramesComparator
    implements Comparator<Frame>,
    Serializable {
        static final FramesComparator INSTANCE = new FramesComparator();
        private static final long serialVersionUID = 40000L;

        private FramesComparator() {
        }

        @Override
        public int compare(Frame o1, Frame o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }

    private static class TypeDefTagsComparator
    implements StringComparator {
        static final TypeDefTagsComparator INSTANCE = new TypeDefTagsComparator();
        @Nonnull
        private static final Map<String, Integer> TAGSPRIORITIES = TypeDefTagsComparator.buildTagsPriorities();
        private static final long serialVersionUID = 40000L;

        private TypeDefTagsComparator() {
        }

        @Nonnull
        private static Map<String, Integer> buildTagsPriorities() {
            HashMap<String, Integer> table = new HashMap<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_ID.getTag(), 5);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEF.getTag(), 30);
            table.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSET.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DOMAIN.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RANGE.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_BUILTIN.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN.getTag(), 71);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANTI_SYMMETRIC.getTag(), 75);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_CYCLIC.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC.getTag(), 90);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE.getTag(), 100);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL.getTag(), 105);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL.getTag(), 110);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag(), 115);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag(), 120);
            table.put(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag(), 125);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag(), 130);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag(), 135);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF.getTag(), 140);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER.getTag(), 145);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN.getTag(), 155);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_OVER.getTag(), 160);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag(), 165);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), 169);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY.getTag(), 185);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CONSIDER.getTag(), 190);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATED_BY.getTag(), 191);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE.getTag(), 192);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EXPAND_ASSERTION_TO.getTag(), 195);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EXPAND_EXPRESSION_TO.getTag(), 200);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG.getTag(), 205);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG.getTag(), 210);
            return table;
        }

        public int compare(String o1, String o2) {
            Integer i1 = TAGSPRIORITIES.get(o1);
            Integer i2 = TAGSPRIORITIES.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static class ClauseListComparator
    implements Comparator<Clause>,
    Serializable {
        protected static final ClauseListComparator INSTANCE = new ClauseListComparator();
        private static final long serialVersionUID = 40000L;

        private ClauseListComparator() {
        }

        @Override
        public int compare(Clause o1, Clause o2) {
            String t2;
            String t1 = o1.getTag();
            int compare = TermsTagsComparator.INSTANCE.compare(t1, t2 = o2.getTag());
            if (compare == 0) {
                compare = ClauseComparator.INSTANCE.compare(o1, o2);
            }
            return compare;
        }
    }

    private static class TermsTagsComparator
    implements StringComparator {
        static final TermsTagsComparator INSTANCE = new TermsTagsComparator();
        @Nonnull
        private static final Map<String, Integer> TAGSPRIORITIES = TermsTagsComparator.buildTagsPriorities();
        private static final long serialVersionUID = 40000L;

        private TermsTagsComparator() {
        }

        @Nonnull
        private static Map<String, Integer> buildTagsPriorities() {
            HashMap<String, Integer> table = new HashMap<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_ID.getTag(), 5);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_ANONYMOUS.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEF.getTag(), 30);
            table.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSET.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYM.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_BUILTIN.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_A.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_UNION_OF.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM.getTag(), 90);
            table.put(OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP.getTag(), 95);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 98);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), 110);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REPLACED_BY.getTag(), 115);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CONSIDER.getTag(), 120);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATED_BY.getTag(), 130);
            table.put(OBOFormatConstants.OboFormatTag.TAG_CREATION_DATE.getTag(), 140);
            return table;
        }

        public int compare(String o1, String o2) {
            Integer i1 = TAGSPRIORITIES.get(o1);
            Integer i2 = TAGSPRIORITIES.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static class HeaderTagsComparator
    implements StringComparator {
        static final HeaderTagsComparator INSTANCE = new HeaderTagsComparator();
        @Nonnull
        private static final Map<String, Integer> TAGSPRIORITIES = HeaderTagsComparator.buildTagsPriorities();
        private static final long serialVersionUID = 40000L;

        private HeaderTagsComparator() {
        }

        @Nonnull
        private static Map<String, Integer> buildTagsPriorities() {
            HashMap<String, Integer> table = new HashMap<String, Integer>();
            table.put(OBOFormatConstants.OboFormatTag.TAG_FORMAT_VERSION.getTag(), 0);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION.getTag(), 10);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DATE.getTag(), 15);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SAVED_BY.getTag(), 20);
            table.put(OBOFormatConstants.OboFormatTag.TAG_AUTO_GENERATED_BY.getTag(), 25);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF.getTag(), 35);
            table.put(OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF.getTag(), 40);
            table.put(OBOFormatConstants.OboFormatTag.TAG_DEFAULT_NAMESPACE.getTag(), 45);
            table.put(OBOFormatConstants.OboFormatTag.TAG_NAMESPACE_ID_RULE.getTag(), 46);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IDSPACE.getTag(), 50);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_EQUIVALENT.getTag(), 55);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_GENUS_DIFFERENTIA.getTag(), 60);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_RELATIONSHIP.getTag(), 65);
            table.put(OBOFormatConstants.OboFormatTag.TAG_TREAT_XREFS_AS_IS_A.getTag(), 70);
            table.put(OBOFormatConstants.OboFormatTag.TAG_REMARK.getTag(), 75);
            table.put(OBOFormatConstants.OboFormatTag.TAG_IMPORT.getTag(), 80);
            table.put(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY.getTag(), 85);
            table.put(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE.getTag(), 100);
            table.put(OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS.getTag(), 110);
            return table;
        }

        public int compare(String o1, String o2) {
            Integer i1 = TAGSPRIORITIES.get(o1);
            Integer i2 = TAGSPRIORITIES.get(o2);
            if (i1 == null) {
                i1 = 10000;
            }
            if (i2 == null) {
                i2 = 10000;
            }
            return i1.compareTo(i2);
        }
    }

    private static enum EscapeMode {
        most,
        parenthesis,
        quotes,
        xref,
        xrefList,
        simple;

    }
}

