/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.jena;

import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.util.FileManager;
import org.mindswap.pellet.KBLoader;
import org.mindswap.pellet.KnowledgeBase;
import org.mindswap.pellet.jena.PelletInfGraph;
import org.mindswap.pellet.jena.PelletReasonerFactory;

public class JenaLoader
extends KBLoader {
    private static final FileManager manager = FileManager.get();
    private OntModel model;
    private PelletInfGraph pellet;

    public JenaLoader() {
        this.clear();
    }

    public PelletInfGraph getGraph() {
        return this.pellet;
    }

    public KnowledgeBase getKB() {
        return this.pellet.getKB();
    }

    public OntModel getModel() {
        return this.model;
    }

    public void load() {
        this.pellet.prepare(false);
    }

    protected void parseFile(String file) {
        manager.readModel((Model)this.model, file, this.inputFormat);
    }

    public void clear() {
        if (this.model != null) {
            this.model.close();
        }
        this.model = ModelFactory.createOntologyModel((OntModelSpec)PelletReasonerFactory.THE_SPEC);
        this.pellet = (PelletInfGraph)this.model.getGraph();
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat.toUpperCase();
    }

    public void setIgnoreImports(boolean ignoreImports) {
        this.model.getDocumentManager().setProcessImports(!ignoreImports);
    }
}

