/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.IDSpaceManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyID;

enum OBOIdType {
    URL_AS_ID(Pattern.compile("(http:|https:)[^\\s]*"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            return IRI.create((String)id);
        }
    }),
    UNPREFIXED_ID(Pattern.compile("[^\\s:]*"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            StringBuilder sb = new StringBuilder();
            if (!ontologyID.isAnonymous()) {
                sb.append(ontologyID.getOntologyIRI());
            } else {
                sb.append("anonymous");
            }
            sb.append("#");
            sb.append(id);
            return IRI.create((String)sb.toString());
        }
    }),
    CANONICAL_PREFIXED_ID(Pattern.compile("([A-Za-z][A-Za-z_]*):([0-9]*)"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            Matcher matcher = CANONICAL_PREFIXED_ID.getPattern().matcher(id);
            matcher.matches();
            String idspace = matcher.group(1);
            String localid = matcher.group(2);
            String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
            StringBuilder sb = new StringBuilder();
            sb.append(iriPrefix);
            sb.append(idspace);
            sb.append("_");
            sb.append(localid);
            return IRI.create((String)sb.toString());
        }
    }),
    NON_CANONICAL_PREFIXED_ID(Pattern.compile("([^\\s:]*):([^\\s]*)"), new OBOIIdTranslator(){

        @Override
        public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String id) {
            Matcher matcher = NON_CANONICAL_PREFIXED_ID.getPattern().matcher(id);
            matcher.matches();
            String idspace = matcher.group(1);
            String localid = matcher.group(2);
            String iriPrefix = idSpaceManager.getIRIPrefix(idspace);
            StringBuilder sb = new StringBuilder();
            sb.append(iriPrefix);
            sb.append(idspace);
            sb.append("#_");
            sb.append(localid);
            return IRI.create((String)sb.toString());
        }
    });

    private Pattern pattern;
    private OBOIIdTranslator translator;

    private OBOIdType(Pattern pattern, OBOIIdTranslator translator) {
        this.pattern = pattern;
        this.translator = translator;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Nonnull
    public IRI getIRIFromOBOId(OWLOntologyID ontologyID, IDSpaceManager idSpaceManager, String oboId) {
        return this.translator.getIRIFromOBOId(ontologyID, idSpaceManager, oboId);
    }

    public static OBOIdType getIdType(String oboId) {
        if (oboId == null) {
            throw new NullPointerException("oboId must not be null");
        }
        for (OBOIdType idType : OBOIdType.values()) {
            Pattern pattern = idType.getPattern();
            Matcher matcher = pattern.matcher(oboId);
            if (!matcher.matches()) continue;
            return idType;
        }
        return null;
    }

    private static interface OBOIIdTranslator {
        public IRI getIRIFromOBOId(OWLOntologyID var1, IDSpaceManager var2, String var3);
    }
}

