/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import com.google.common.base.Optional;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.coode.owlapi.obo12.parser.AltIdTagValueHandler;
import org.coode.owlapi.obo12.parser.AsymmetricHandler;
import org.coode.owlapi.obo12.parser.DataVersionTagValueHandler;
import org.coode.owlapi.obo12.parser.DefTagValueHandler;
import org.coode.owlapi.obo12.parser.DefaultNamespaceTagValueHandler;
import org.coode.owlapi.obo12.parser.DisjointFromHandler;
import org.coode.owlapi.obo12.parser.IDSpaceManager;
import org.coode.owlapi.obo12.parser.IDSpaceTagValueHandler;
import org.coode.owlapi.obo12.parser.IDTagValueHandler;
import org.coode.owlapi.obo12.parser.IntersectionOfHandler;
import org.coode.owlapi.obo12.parser.InverseHandler;
import org.coode.owlapi.obo12.parser.IsATagValueHandler;
import org.coode.owlapi.obo12.parser.IsObsoleteTagValueHandler;
import org.coode.owlapi.obo12.parser.NameTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOIdType;
import org.coode.owlapi.obo12.parser.OBOParserHandler;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.coode.owlapi.obo12.parser.OntologyTagValueHandler;
import org.coode.owlapi.obo12.parser.PartOfTagValueHandler;
import org.coode.owlapi.obo12.parser.ReflexiveHandler;
import org.coode.owlapi.obo12.parser.RelationshipTagValueHandler;
import org.coode.owlapi.obo12.parser.SymmetricTagValueHandler;
import org.coode.owlapi.obo12.parser.SynonymTagValueHandler;
import org.coode.owlapi.obo12.parser.SynonymTypeDefTagHandler;
import org.coode.owlapi.obo12.parser.TagValueHandler;
import org.coode.owlapi.obo12.parser.TransitiveOverHandler;
import org.coode.owlapi.obo12.parser.TransitiveTagValueHandler;
import org.coode.owlapi.obo12.parser.UnionOfHandler;
import org.coode.owlapi.obo12.parser.XRefTagHandler;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;

class OBOConsumer
implements OBOParserHandler {
    private static final Logger logger = Logger.getLogger(OBOConsumer.class.getName());
    private static final String IMPORT_TAG_NAME = "import";
    @Nonnull
    private OWLOntologyLoaderConfiguration configuration;
    private OWLOntologyManager owlOntologyManager;
    @Nonnull
    private OWLOntology ontology;
    private boolean inHeader;
    private String currentId;
    private Map<String, TagValueHandler> handlerMap;
    private String defaultNamespaceTagValue = OBOVocabulary.OBO_IRI_BASE;
    private String stanzaType;
    private boolean termType;
    private boolean typedefType;
    private boolean instanceType;
    @Nonnull
    private Set<OWLClassExpression> intersectionOfOperands;
    @Nonnull
    private final Set<OWLClassExpression> unionOfOperands = new HashSet<OWLClassExpression>();
    private Map<String, IRI> uriCache = new HashMap<String, IRI>();
    private Map<String, IRI> symbolicIdCache = new HashMap<String, IRI>();
    private Map<String, IRI> tagIRICache = new HashMap<String, IRI>();
    private IDSpaceManager idSpaceManager = new IDSpaceManager();
    private String ontologyTagValue = "";
    private String dataVersionTagValue = "";
    private static final Pattern XREF_PATTERN = Pattern.compile("([^\"]*)\\s*(\"((\\\"|[^\"])*)\")?");
    private static final int XREF_ID_GROUP = 1;
    private static final int XREF_QUOTED_STRING_GROUP = 3;

    public OBOConsumer(@Nonnull OWLOntology ontology, @Nonnull OWLOntologyLoaderConfiguration configuration, IRI baseIRI) {
        this.configuration = configuration;
        this.owlOntologyManager = ontology.getOWLOntologyManager();
        this.ontology = ontology;
        this.intersectionOfOperands = new HashSet<OWLClassExpression>();
        this.uriCache = new HashMap<String, IRI>();
        for (OBOVocabulary v : OBOVocabulary.values()) {
            this.tagIRICache.put(v.getName(), v.getIRI());
        }
        this.ontologyTagValue = OBOConsumer.getDefaultOntologyTagValue(baseIRI);
        this.loadBuiltinURIs();
        this.setupTagHandlers();
    }

    private static String getDefaultOntologyTagValue(IRI baseIRI) {
        URI baseURI = baseIRI.toURI();
        String baseURIPath = baseURI.getPath();
        if (baseURIPath == null) {
            return baseIRI.toString();
        }
        int lastSlashIndex = baseURIPath.lastIndexOf("/");
        if (lastSlashIndex == -1 || lastSlashIndex + 1 == baseURIPath.length()) {
            return baseURIPath;
        }
        return baseURIPath.substring(lastSlashIndex + 1);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.owlOntologyManager;
    }

    @Nonnull
    public OWLOntology getOntology() {
        return this.ontology;
    }

    public String getCurrentId() {
        return this.currentId;
    }

    public void addSymbolicIdMapping(String symbolicName, IRI fullIRI) {
        this.symbolicIdCache.put(symbolicName, fullIRI);
    }

    public void setDefaultNamespaceTagValue(String defaultNamespaceTagValue) {
        this.defaultNamespaceTagValue = defaultNamespaceTagValue;
    }

    public String getDefaultNamespaceTagValue() {
        return this.defaultNamespaceTagValue;
    }

    public void setOntologyTagValue(String ontologyTagValue) {
        this.ontologyTagValue = ontologyTagValue;
    }

    public void setDataVersionTagValue(String dataVersionTagValue) {
        this.dataVersionTagValue = dataVersionTagValue;
    }

    public void registerIdSpace(String idSpacePrefix, String iriPrefix) {
        this.idSpaceManager.setIRIPrefix(idSpacePrefix, iriPrefix);
    }

    public IDSpaceManager getIdSpaceManager() {
        return this.idSpaceManager;
    }

    public void setCurrentId(String currentId) {
        this.currentId = currentId;
    }

    public void addUnionOfOperand(OWLClassExpression classExpression) {
        this.unionOfOperands.add(classExpression);
    }

    public void addIntersectionOfOperand(OWLClassExpression classExpression) {
        this.intersectionOfOperands.add(classExpression);
    }

    public String getStanzaType() {
        return this.stanzaType;
    }

    public boolean isTerm() {
        return this.termType;
    }

    public boolean isTypedef() {
        return this.typedefType;
    }

    public boolean isInstanceType() {
        return this.instanceType;
    }

    private void loadBuiltinURIs() {
        for (OBOVocabulary v : OBOVocabulary.values()) {
            this.uriCache.put(v.getName(), v.getIRI());
        }
    }

    private void setupTagHandlers() {
        this.handlerMap = new HashMap<String, TagValueHandler>();
        this.addTagHandler(new OntologyTagValueHandler(this));
        this.addTagHandler(new IDTagValueHandler(this));
        this.addTagHandler(new NameTagValueHandler(this));
        this.addTagHandler(new IsATagValueHandler(this));
        this.addTagHandler(new PartOfTagValueHandler(this));
        this.addTagHandler(new TransitiveTagValueHandler(this));
        this.addTagHandler(new SymmetricTagValueHandler(this));
        this.addTagHandler(new RelationshipTagValueHandler(this));
        this.addTagHandler(new UnionOfHandler(this));
        this.addTagHandler(new IntersectionOfHandler(this));
        this.addTagHandler(new DisjointFromHandler(this));
        this.addTagHandler(new AsymmetricHandler(this));
        this.addTagHandler(new InverseHandler(this));
        this.addTagHandler(new ReflexiveHandler(this));
        this.addTagHandler(new TransitiveOverHandler(this));
        this.addTagHandler(new DefaultNamespaceTagValueHandler(this));
        this.addTagHandler(new SynonymTagValueHandler(this));
        this.addTagHandler(new XRefTagHandler(this));
        this.addTagHandler(new DefTagValueHandler(this));
        this.addTagHandler(new IsObsoleteTagValueHandler(this));
        this.addTagHandler(new IDSpaceTagValueHandler(this));
        this.addTagHandler(new DataVersionTagValueHandler(this));
        this.addTagHandler(new SynonymTypeDefTagHandler(this));
        this.addTagHandler(new AltIdTagValueHandler(this));
    }

    private void addTagHandler(TagValueHandler handler) {
        this.handlerMap.put(handler.getTagName(), handler);
    }

    @Override
    public void startHeader() {
        this.inHeader = true;
    }

    @Override
    public void endHeader() {
        this.inHeader = false;
        this.setOntologyId();
    }

    private void setOntologyId() {
        IRI ontologyIRI = IRI.create((String)(this.idSpaceManager.getIRIPrefix(this.ontologyTagValue) + this.ontologyTagValue));
        IRI versionIRI = null;
        if (this.dataVersionTagValue.length() > 0) {
            versionIRI = IRI.create((String)(ontologyIRI.toString() + "/" + this.dataVersionTagValue));
        }
        OWLOntologyID ontologyID = new OWLOntologyID(Optional.fromNullable((Object)ontologyIRI), Optional.fromNullable(versionIRI));
        this.ontology.getOWLOntologyManager().applyChange((OWLOntologyChange)new SetOntologyID(this.ontology, ontologyID));
    }

    @Override
    public void startFrame(String name) {
        this.currentId = null;
        this.defaultNamespaceTagValue = null;
        this.stanzaType = name;
        this.termType = this.stanzaType.equals(OBOVocabulary.TERM.getName());
        this.typedefType = false;
        this.instanceType = false;
        if (!this.termType) {
            this.typedefType = this.stanzaType.equals(OBOVocabulary.TYPEDEF.getName());
            if (!this.typedefType) {
                this.instanceType = this.stanzaType.equals(OBOVocabulary.INSTANCE.getName());
            }
        }
    }

    @Override
    public void endFrame() {
        if (!this.unionOfOperands.isEmpty()) {
            this.createUnionEquivalentClass();
            this.unionOfOperands.clear();
        }
        if (!this.intersectionOfOperands.isEmpty()) {
            this.createIntersectionEquivalentClass();
            this.intersectionOfOperands.clear();
        }
    }

    private void createUnionEquivalentClass() {
        Object equivalentClass = this.unionOfOperands.size() == 1 ? this.unionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectUnionOf(this.unionOfOperands);
        this.createEquivalentClass((OWLClassExpression)equivalentClass);
    }

    private void createIntersectionEquivalentClass() {
        Object equivalentClass = this.intersectionOfOperands.size() == 1 ? this.intersectionOfOperands.iterator().next() : this.getDataFactory().getOWLObjectIntersectionOf(this.intersectionOfOperands);
        this.createEquivalentClass((OWLClassExpression)equivalentClass);
    }

    private void createEquivalentClass(OWLClassExpression classExpression) {
        OWLEquivalentClassesAxiom ax = this.getDataFactory().getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{this.getCurrentClass(), classExpression}));
        this.getOWLOntologyManager().applyChange((OWLOntologyChange)new AddAxiom(this.ontology, (OWLAxiom)ax));
    }

    @Override
    public void handleTagValue(String tag, String value, String qualifierBlock, String comment) {
        try {
            TagValueHandler handler = this.handlerMap.get(tag);
            if (handler != null) {
                handler.handle(this.currentId, value, qualifierBlock, comment);
            } else if (this.inHeader) {
                if (tag.equals(IMPORT_TAG_NAME)) {
                    String trim = value.trim();
                    assert (trim != null);
                    IRI uri = IRI.create((String)trim);
                    OWLImportsDeclaration decl = this.owlOntologyManager.getOWLDataFactory().getOWLImportsDeclaration(uri);
                    this.owlOntologyManager.makeLoadImportRequest(decl, this.configuration);
                    this.owlOntologyManager.applyChange((OWLOntologyChange)new AddImport(this.ontology, decl));
                } else {
                    OWLLiteral con = this.getDataFactory().getOWLLiteral(this.unescapeTagValue(value));
                    OWLAnnotationProperty property = this.getDataFactory().getOWLAnnotationProperty(this.getIRIFromTagName(tag));
                    OWLAnnotation anno = this.getDataFactory().getOWLAnnotation(property, (OWLAnnotationValue)con);
                    this.owlOntologyManager.applyChange((OWLOntologyChange)new AddOntologyAnnotation(this.ontology, anno));
                }
            } else if (this.currentId != null && this.configuration.isLoadAnnotationAxioms()) {
                IRI subject = this.getIRI(this.currentId);
                OWLLiteral con = this.getDataFactory().getOWLLiteral(this.unescapeTagValue(value));
                IRI annotationPropertyIRI = this.getIRIFromTagName(tag);
                OWLAnnotationProperty property = this.getDataFactory().getOWLAnnotationProperty(annotationPropertyIRI);
                OWLAnnotation anno = this.getDataFactory().getOWLAnnotation(property, (OWLAnnotationValue)con);
                OWLAnnotationAssertionAxiom ax = this.getDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)subject, anno);
                this.owlOntologyManager.addAxiom(this.ontology, (OWLAxiom)ax);
                OWLDeclarationAxiom annotationPropertyDeclaration = this.getDataFactory().getOWLDeclarationAxiom((OWLEntity)property);
                this.owlOntologyManager.addAxiom(this.ontology, (OWLAxiom)annotationPropertyDeclaration);
            }
        }
        catch (UnloadableImportException e) {
            logger.severe(e.getMessage());
        }
    }

    @Nonnull
    public String unescapeTagValue(String value) {
        String unquoted = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < unquoted.length(); ++i) {
            char ch = unquoted.charAt(i);
            if (ch == '\\') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    private OWLDataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    public OWLClass getCurrentClass() {
        return this.getDataFactory().getOWLClass(this.getIRI(this.currentId));
    }

    public OWLEntity getCurrentEntity() {
        if (this.isTerm()) {
            return this.getCurrentClass();
        }
        if (this.isTypedef()) {
            IRI propertyIRI = this.getRelationIRIFromSymbolicIdOrOBOId(this.currentId);
            return this.getDataFactory().getOWLObjectProperty(propertyIRI);
        }
        return this.getDataFactory().getOWLNamedIndividual(this.getIRI(this.currentId));
    }

    @Nonnull
    public IRI getIRIFromTagName(String tagName) {
        if (tagName == null) {
            throw new NullPointerException("tagName must not be null");
        }
        IRI tagIRI = this.tagIRICache.get(tagName);
        if (tagIRI != null) {
            return tagIRI;
        }
        IRI freshTagIRI = IRI.create((String)(OBOVocabulary.OBO_IRI_BASE + tagName));
        this.tagIRICache.put(tagName, freshTagIRI);
        return freshTagIRI;
    }

    @Nonnull
    public IRI getIRIFromOBOId(String oboId) {
        if (oboId == null) {
            throw new NullPointerException("oboId must not be null.");
        }
        return this.getIRI(oboId);
    }

    @Nonnull
    public IRI getRelationIRIFromSymbolicIdOrOBOId(String symbolicIdOrOBOId) {
        IRI fullIRI = this.symbolicIdCache.get(symbolicIdOrOBOId);
        if (fullIRI != null) {
            return fullIRI;
        }
        OBOIdType idType = OBOIdType.getIdType(symbolicIdOrOBOId);
        if (idType == null) {
            throw new OWLRuntimeException("Invalid ID: " + symbolicIdOrOBOId + " in frame " + this.currentId);
        }
        return idType.getIRIFromOBOId(this.ontology.getOntologyID(), this.idSpaceManager, symbolicIdOrOBOId);
    }

    @Nonnull
    private IRI getIRI(String s) {
        String trimmed = s.trim();
        IRI iri = this.uriCache.get(trimmed);
        if (iri != null) {
            return iri;
        }
        OWLOntologyID ontologyID = this.getOntology().getOntologyID();
        OBOIdType type = OBOIdType.getIdType(trimmed);
        if (type == null) {
            throw new OWLRuntimeException("Not a valid OBO ID: " + s);
        }
        IRI freshIRI = type.getIRIFromOBOId(ontologyID, this.idSpaceManager, trimmed);
        this.uriCache.put(trimmed, freshIRI);
        return freshIRI;
    }

    public OWLAnnotation parseXRef(@Nonnull String xref) {
        Matcher matcher = XREF_PATTERN.matcher(xref);
        if (matcher.matches()) {
            OWLDataFactory df = this.getDataFactory();
            String xrefQuotedString = matcher.group(3);
            HashSet<OWLAnnotation> xrefDescriptions = new HashSet<OWLAnnotation>();
            if (xrefQuotedString != null) {
                xrefDescriptions.add(df.getOWLAnnotation(df.getRDFSComment(), (OWLAnnotationValue)df.getOWLLiteral(xrefQuotedString)));
            }
            String xrefId = matcher.group(1).trim();
            assert (xrefId != null);
            OBOIdType idType = OBOIdType.getIdType(xrefId);
            Object annotationValue = idType != null ? this.getIRIFromOBOId(xrefId) : this.getDataFactory().getOWLLiteral(xrefId);
            OWLAnnotationProperty xrefProperty = df.getOWLAnnotationProperty(OBOVocabulary.XREF.getIRI());
            return df.getOWLAnnotation(xrefProperty, (OWLAnnotationValue)annotationValue, xrefDescriptions);
        }
        OWLDataFactory df = this.getDataFactory();
        OWLAnnotationProperty xrefProperty = df.getOWLAnnotationProperty(OBOVocabulary.XREF.getIRI());
        return df.getOWLAnnotation(xrefProperty, (OWLAnnotationValue)df.getOWLLiteral(xref));
    }
}

