/*
 * Decompiled with CFR 0.152.
 */
package jjtraveler;

import java.util.Collection;
import java.util.HashSet;
import jjtraveler.All;
import jjtraveler.GuaranteeSuccess;
import jjtraveler.TopDown;
import jjtraveler.Try;
import jjtraveler.VisitFailure;
import jjtraveler.Visitable;
import jjtraveler.Visitor;

public class Collect
implements Visitor {
    private Collection collection;
    private Visitor visitor;

    public Collect(Visitor v, Collection c) {
        this.collection = c;
        this.visitor = v;
    }

    public Collect(Visitor v) {
        this(v, new HashSet());
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Visitable visit(Visitable x) throws VisitFailure {
        Visitable result = this.visitor.visit(x);
        this.collection.add(result);
        return result;
    }

    public static GuaranteeSuccess topdown(Visitor v, Collection c) {
        return new GuaranteeSuccess(new TopDown(new Try(new Collect(v, c))));
    }

    public static GuaranteeSuccess all(Visitor v, Collection c) {
        return new GuaranteeSuccess(new All(new Try(new Collect(v, c))));
    }
}

