/*
 * Decompiled with CFR 0.152.
 */
package org.mindswap.pellet.taxonomy;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TaxonomyNode<T> {
    private Map<Object, Object> dataMap = new HashMap<Object, Object>();
    private Set<T> equivalents;
    private boolean hidden;
    protected Boolean mark;
    private T name;
    protected short depth = 0;
    private Set<TaxonomyNode<T>> subs = new HashSet<TaxonomyNode<T>>(2);
    private Set<TaxonomyNode<T>> supers = new HashSet<TaxonomyNode<T>>();

    public TaxonomyNode(T name, boolean hidden) {
        this.name = name;
        this.hidden = hidden;
        this.equivalents = name == null ? Collections.emptySet() : Collections.singleton(name);
    }

    public TaxonomyNode(Collection<T> equivalents, boolean hidden) {
        if (equivalents == null || equivalents.isEmpty()) {
            this.name = null;
            this.equivalents = Collections.emptySet();
        } else {
            this.name = equivalents.iterator().next();
            this.equivalents = new HashSet<T>(equivalents);
        }
        this.hidden = hidden;
    }

    public void addEquivalent(T t) {
        if (this.equivalents.size() < 2) {
            this.equivalents = new HashSet<T>(this.equivalents);
        }
        this.equivalents.add(t);
    }

    public void addSub(TaxonomyNode<T> other) {
        if (this.equals(other) || this.subs.contains(other)) {
            return;
        }
        this.subs.add(other);
        if (!this.hidden) {
            other.supers.add(this);
        }
    }

    public void addSubs(Collection<TaxonomyNode<T>> others) {
        for (TaxonomyNode<T> t : others) {
            this.addSub(t);
        }
    }

    public void addSupers(Collection<TaxonomyNode<T>> others) {
        this.supers.addAll(others);
        if (!this.hidden) {
            for (TaxonomyNode<T> other : others) {
                other.subs.add(this);
            }
        }
    }

    public void clearData() {
        this.dataMap.clear();
    }

    public boolean contains(T t) {
        return this.equivalents.contains(t);
    }

    public void disconnect() {
        Iterator<TaxonomyNode<T>> j = this.subs.iterator();
        while (j.hasNext()) {
            TaxonomyNode<T> sub = j.next();
            j.remove();
            sub.supers.remove(this);
        }
        j = this.supers.iterator();
        while (j.hasNext()) {
            TaxonomyNode<T> sup = j.next();
            j.remove();
            sup.subs.remove(this);
        }
    }

    public Object getDatum(Object key) {
        return this.dataMap.get(key);
    }

    public Set<T> getEquivalents() {
        return this.equivalents;
    }

    public T getName() {
        return this.name;
    }

    public Collection<TaxonomyNode<T>> getSubs() {
        return this.subs;
    }

    public Collection<TaxonomyNode<T>> getSupers() {
        return this.supers;
    }

    public boolean isBottom() {
        return this.subs.isEmpty();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isLeaf() {
        return this.subs.size() == 1 && this.subs.iterator().next().isBottom();
    }

    public boolean isTop() {
        return this.supers.isEmpty();
    }

    public void print() {
        this.print("");
    }

    public void print(String indent) {
        if (this.subs.isEmpty()) {
            return;
        }
        System.out.print(indent);
        Iterator<T> i = this.equivalents.iterator();
        while (i.hasNext()) {
            System.out.print(i.next());
            if (!i.hasNext()) continue;
            System.out.print(" = ");
        }
        System.out.println();
        indent = indent + "  ";
        for (TaxonomyNode<T> sub : this.subs) {
            sub.print(indent);
        }
    }

    public Object putDatum(Object key, Object value) {
        return this.dataMap.put(key, value);
    }

    public Object removeDatum(Object key) {
        return this.dataMap.remove(key);
    }

    public void removeMultiplePaths() {
        if (!this.hidden) {
            for (TaxonomyNode<T> sup : this.supers) {
                for (TaxonomyNode<T> sub : this.subs) {
                    sup.removeSub(sub);
                }
            }
        }
    }

    public void removeEquivalent(T t) {
        this.equivalents.remove(t);
        if (this.name != null && this.name.equals(t)) {
            this.name = this.equivalents.iterator().next();
        }
    }

    public void removeSub(TaxonomyNode<T> other) {
        this.subs.remove(other);
        other.supers.remove(this);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Deprecated
    public void setSubs(Set<TaxonomyNode<T>> subs) {
        this.subs = subs;
    }

    @Deprecated
    public void setSupers(Set<TaxonomyNode<T>> supers) {
        this.supers = supers;
    }

    public String toString() {
        return this.name.toString();
    }
}

