/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.rules.rete;

import com.clarkparsia.pellet.rules.builtins.BuiltIn;
import com.clarkparsia.pellet.rules.rete.FilterCondition;
import com.clarkparsia.pellet.rules.rete.NodeProvider;
import com.clarkparsia.pellet.rules.rete.Token;
import com.clarkparsia.pellet.rules.rete.WME;
import java.util.Arrays;
import org.mindswap.pellet.ABox;
import org.mindswap.pellet.Literal;
import org.mindswap.pellet.utils.ATermUtils;

public class BuiltInCondition
implements FilterCondition {
    private final ABox abox;
    private final String name;
    private final BuiltIn builtin;
    private final NodeProvider[] args;

    public BuiltInCondition(ABox abox, String name, BuiltIn builtin, NodeProvider[] args) {
        this.abox = abox;
        this.name = name;
        this.builtin = builtin;
        this.args = args;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] != null) continue;
            throw new NullPointerException();
        }
    }

    @Override
    public boolean test(WME wme, Token token) {
        Literal[] literals = new Literal[this.args.length];
        for (int i = 0; i < literals.length; ++i) {
            literals[i] = (Literal)this.args[i].getNode(wme, token);
        }
        return this.builtin.apply(this.abox, literals);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.args);
        result = 31 * result + this.builtin.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuiltInCondition)) {
            return false;
        }
        BuiltInCondition other = (BuiltInCondition)obj;
        return this.builtin.equals(other.builtin) && Arrays.equals(this.args, other.args);
    }

    public String toString() {
        return ATermUtils.toString(ATermUtils.makeTermAppl(this.name)) + Arrays.toString(this.args);
    }
}

