/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithEntityAndAnonCaching;

public class OWLLiteralImplString
implements OWLLiteral {
    private static final long serialVersionUID = 30406L;
    @Nonnull
    private static final OWLDatatype XSD_STRING = new OWL2DatatypeImpl(OWL2Datatype.XSD_STRING);
    @Nonnull
    private final String literal;
    private final int hashCode;

    public OWLLiteralImplString(@Nonnull String literal) {
        this.literal = literal;
        this.hashCode = this.getHashCode(literal);
    }

    private static int index() {
        return 4008;
    }

    public String getLiteral() {
        return this.literal;
    }

    public boolean hasLang() {
        return false;
    }

    public int parseInteger() throws NumberFormatException {
        return Integer.parseInt(this.getLiteral());
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isDouble() {
        return false;
    }

    public boolean isFloat() {
        return false;
    }

    public boolean parseBoolean() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a boolean value");
    }

    public double parseDouble() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a double value");
    }

    public float parseFloat() {
        throw new OWLRuntimeException(this.getClass().getName() + " does not have a float value");
    }

    public String getLang() {
        return "";
    }

    public boolean hasLang(String l) {
        return false;
    }

    public OWLDatatype getDatatype() {
        return XSD_STRING;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode(String lit) {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code = code * 37 + lit.hashCode() * 65536;
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        return this.getLiteral().equals(other.getLiteral()) && this.getDatatype().equals(other.getDatatype()) && this.getLang().equals(other.getLang());
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.getDatatype().compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.getLang().compareTo(other.getLang());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Set<OWLEntity> getSignature() {
        return Collections.singleton(XSD_STRING);
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLClass> getClassesInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return CollectionFactory.emptySet();
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return CollectionFactory.emptySet();
    }

    public boolean isTopEntity() {
        return false;
    }

    public boolean isBottomEntity() {
        return false;
    }

    public int compareTo(OWLObject o) {
        int thisTypeIndex = OWLLiteralImplString.index();
        int otherTypeIndex = 0;
        otherTypeIndex = o instanceof OWLObjectImplWithEntityAndAnonCaching ? ((OWLObjectImplWithEntityAndAnonCaching)o).index() : OWLObjectImplWithEntityAndAnonCaching.OWLOBJECT_TYPEINDEX_PROVIDER.getTypeIndex(o);
        int diff = thisTypeIndex - otherTypeIndex;
        if (diff == 0) {
            return this.compareObjectOfSameType(o);
        }
        return diff;
    }

    public boolean containsEntityInSignature(OWLEntity owlEntity) {
        return false;
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

