/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.pellet.owlapiv3;

import com.clarkparsia.pellet.owlapiv3.PelletReasoner;
import com.clarkparsia.pellet.owlapiv3.PelletReasonerConfiguration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class PelletReasonerFactory
implements OWLReasonerFactory {
    private static final PelletReasonerFactory INSTANCE = new PelletReasonerFactory();

    public static PelletReasonerFactory getInstance() {
        return INSTANCE;
    }

    public String getReasonerName() {
        return "Pellet";
    }

    public String toString() {
        return this.getReasonerName();
    }

    public PelletReasoner createReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, new PelletReasonerConfiguration());
    }

    public PelletReasoner createReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, this.config(config).buffering(true));
    }

    public PelletReasoner createNonBufferingReasoner(OWLOntology ontology) {
        return new PelletReasoner(ontology, new PelletReasonerConfiguration().buffering(false));
    }

    public PelletReasoner createNonBufferingReasoner(OWLOntology ontology, OWLReasonerConfiguration config) throws IllegalConfigurationException {
        return new PelletReasoner(ontology, this.config(config).buffering(false));
    }

    private PelletReasonerConfiguration config(OWLReasonerConfiguration config) {
        return config instanceof PelletReasonerConfiguration ? (PelletReasonerConfiguration)config : new PelletReasonerConfiguration(config);
    }
}

