/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure.binary;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermAppl;
import aterm.ATermBlob;
import aterm.ATermInt;
import aterm.ATermList;
import aterm.ATermLong;
import aterm.ATermPlaceholder;
import aterm.ATermReal;
import aterm.pure.PureFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;

public class BinaryReader {
    private static final int ISSHAREDFLAG = 128;
    private static final int TYPEMASK = 15;
    private static final int ANNOSFLAG = 16;
    private static final int ISFUNSHARED = 64;
    private static final int APPLQUOTED = 32;
    private static final int INITIALSHAREDTERMSARRAYSIZE = 1024;
    private static final int STACKSIZE = 256;
    private final PureFactory factory;
    private int sharedTermIndex;
    private ATerm[] sharedTerms;
    private List<AFun> applSignatures;
    private ATermConstruct[] stack;
    private int stackPosition;
    private int tempType = -1;
    private byte[] tempBytes = null;
    private int tempBytesIndex = 0;
    private int tempArity = -1;
    private boolean tempIsQuoted = false;
    private ByteBuffer currentBuffer;
    private boolean isDone = false;
    private static final int SEVENBITS = 127;
    private static final int SIGNBIT = 128;
    private static final int BYTEMASK = 255;
    private static final int BYTEBITS = 8;
    private static final int LONGBITS = 8;

    public BinaryReader(PureFactory factory) {
        this.factory = factory;
        this.sharedTerms = new ATerm[1024];
        this.applSignatures = new ArrayList<AFun>();
        this.sharedTermIndex = 0;
        this.stack = new ATermConstruct[256];
        this.stackPosition = -1;
    }

    private void ensureSharedTermsCapacity() {
        int sharedTermsArraySize = this.sharedTerms.length;
        if (this.sharedTermIndex + 1 >= sharedTermsArraySize) {
            ATerm[] newSharedTermsArray = new ATerm[sharedTermsArraySize << 1];
            System.arraycopy(this.sharedTerms, 0, newSharedTermsArray, 0, sharedTermsArraySize);
            this.sharedTerms = newSharedTermsArray;
        }
    }

    public void deserialize(ByteBuffer buffer) {
        this.currentBuffer = buffer;
        if (this.tempType != -1) {
            this.readData();
        }
        while (buffer.hasRemaining()) {
            byte header = buffer.get();
            if ((header & 0x80) == 128) {
                int index = this.readInt();
                ATerm term = this.sharedTerms[index];
                ++this.stackPosition;
                this.linkTerm(term);
            } else {
                int type = header & 0xF;
                ATermConstruct ac = new ATermConstruct();
                ac.type = type;
                ac.hasAnnos = (header & 0x10) == 16;
                ++this.sharedTermIndex;
                ac.termIndex = ac.termIndex;
                this.ensureSharedTermsCapacity();
                this.stack[++this.stackPosition] = ac;
                switch (type) {
                    case 1: {
                        this.touchAppl(header);
                        break;
                    }
                    case 4: {
                        this.touchList();
                        break;
                    }
                    case 2: {
                        this.touchInt();
                        break;
                    }
                    case 3: {
                        this.touchReal();
                        break;
                    }
                    case 8: {
                        this.touchLong();
                        break;
                    }
                    case 6: {
                        this.touchBlob();
                        break;
                    }
                    case 5: {
                        this.touchPlaceholder();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown type id: " + type + ". Current buffer position: " + this.currentBuffer.position());
                    }
                }
            }
            this.ensureStackCapacity();
        }
    }

    private void ensureStackCapacity() {
        int stackSize = this.stack.length;
        if (this.stackPosition + 1 >= stackSize) {
            ATermConstruct[] newStack = new ATermConstruct[stackSize << 1];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
    }

    public boolean isDone() {
        return this.isDone;
    }

    public ATerm getRoot() {
        if (!this.isDone) {
            throw new RuntimeException("Can't retrieve the root of the tree while it's still being constructed.");
        }
        return this.sharedTerms[0];
    }

    private void resetTemp() {
        this.tempType = -1;
        this.tempBytes = null;
        this.tempBytesIndex = 0;
    }

    private void readData() {
        int length = this.tempBytes.length;
        int bytesToRead = length - this.tempBytesIndex;
        int remaining = this.currentBuffer.remaining();
        if (remaining < bytesToRead) {
            bytesToRead = remaining;
        }
        this.currentBuffer.get(this.tempBytes, this.tempBytesIndex, bytesToRead);
        this.tempBytesIndex += bytesToRead;
        if (this.tempBytesIndex == length) {
            if (this.tempType == 1) {
                AFun fun = this.factory.makeAFun(new String(this.tempBytes), this.tempArity, this.tempIsQuoted);
                this.applSignatures.add(fun);
                ATermConstruct ac = this.stack[this.stackPosition];
                if (this.tempArity == 0 && !ac.hasAnnos) {
                    ATermAppl term = this.factory.makeAppl(fun);
                    this.sharedTerms[ac.termIndex] = term;
                    this.linkTerm(term);
                } else {
                    ac.tempTerm = fun;
                    ac.subTerms = new ATerm[this.tempArity];
                }
            } else if (this.tempType == 6) {
                ATermConstruct ac = this.stack[this.stackPosition];
                ATermBlob term = this.factory.makeBlob(this.tempBytes);
                if (!ac.hasAnnos) {
                    this.sharedTerms[ac.termIndex] = term;
                    this.linkTerm(term);
                } else {
                    ac.tempTerm = term;
                }
            } else {
                throw new RuntimeException("Unsupported chunkified type: " + this.tempType);
            }
            this.resetTemp();
        }
    }

    private void touchAppl(byte header) {
        if ((header & 0x40) == 64) {
            int key = this.readInt();
            AFun fun = this.applSignatures.get(key);
            int arity = fun.getArity();
            ATermConstruct ac = this.stack[this.stackPosition];
            if (arity == 0 && !ac.hasAnnos) {
                ATermAppl term = this.factory.makeAppl(fun);
                this.sharedTerms[ac.termIndex] = term;
                this.linkTerm(term);
            } else {
                ac.tempTerm = fun;
                ac.subTerms = new ATerm[arity];
            }
        } else {
            this.tempIsQuoted = (header & 0x20) == 32;
            this.tempArity = this.readInt();
            int nameLength = this.readInt();
            this.tempType = 1;
            this.tempBytes = new byte[nameLength];
            this.tempBytesIndex = 0;
            this.readData();
        }
    }

    private void touchList() {
        int size = this.readInt();
        ATermConstruct ac = this.stack[this.stackPosition];
        ac.subTerms = new ATerm[size];
        if (size == 0) {
            ATermList term = this.factory.makeList();
            if (!ac.hasAnnos) {
                this.sharedTerms[ac.termIndex] = term;
                this.linkTerm(term);
            } else {
                ac.tempTerm = term;
            }
        }
    }

    private void touchInt() {
        int value = this.readInt();
        ATermConstruct ac = this.stack[this.stackPosition];
        ATermInt term = this.factory.makeInt(value);
        if (!ac.hasAnnos) {
            this.sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        } else {
            ac.tempTerm = term;
        }
    }

    private void touchReal() {
        double value = this.readDouble();
        ATermConstruct ac = this.stack[this.stackPosition];
        ATermReal term = this.factory.makeReal(value);
        if (!ac.hasAnnos) {
            this.sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        } else {
            ac.tempTerm = term;
        }
    }

    private void touchLong() {
        long value = this.readLong();
        ATermConstruct ac = this.stack[this.stackPosition];
        ATermLong term = this.factory.makeLong(value);
        if (!ac.hasAnnos) {
            this.sharedTerms[ac.termIndex] = term;
            this.linkTerm(term);
        } else {
            ac.tempTerm = term;
        }
    }

    private void touchBlob() {
        int length = this.readInt();
        this.tempType = 6;
        this.tempBytes = new byte[length];
        this.tempBytesIndex = 0;
        this.readData();
    }

    private void touchPlaceholder() {
        ATermConstruct ac = this.stack[this.stackPosition];
        ac.subTerms = new ATerm[1];
    }

    private ATerm buildTerm(ATermConstruct ac) {
        ATerm constructedTerm;
        ATerm[] subTerms = ac.subTerms;
        int type = ac.type;
        if (type == 1) {
            AFun fun = (AFun)ac.tempTerm;
            constructedTerm = this.factory.makeAppl(fun, subTerms, ac.annos);
        } else if (type == 4) {
            ATermList list = this.factory.makeList();
            for (int i = subTerms.length - 1; i >= 0; --i) {
                list = this.factory.makeList(subTerms[i], list);
            }
            if (ac.hasAnnos) {
                list = (ATermList)list.setAnnotations(ac.annos);
            }
            constructedTerm = list;
        } else if (type == 5) {
            ATermPlaceholder placeholder = this.factory.makePlaceholder(subTerms[0]);
            constructedTerm = placeholder;
        } else if (ac.hasAnnos) {
            constructedTerm = ac.tempTerm.setAnnotations(ac.annos);
        } else {
            throw new RuntimeException("Unable to construct term.\n");
        }
        return constructedTerm;
    }

    private void linkTerm(ATerm aTerm) {
        ATerm term = aTerm;
        while (this.stackPosition != 0) {
            ATermConstruct parent = this.stack[--this.stackPosition];
            ATerm[] subTerms = parent.subTerms;
            boolean hasAnnos = parent.hasAnnos;
            if (subTerms != null && subTerms.length > parent.subTermIndex) {
                subTerms[parent.subTermIndex++] = term;
                if (parent.subTerms.length != parent.subTermIndex || hasAnnos) {
                    return;
                }
                if (!hasAnnos) {
                    parent.annos = this.factory.makeList();
                }
            } else if (hasAnnos && term instanceof ATermList) {
                parent.annos = (ATermList)term;
            } else {
                throw new RuntimeException("Encountered a term that didn't fit anywhere. Type: " + term.getType());
            }
            this.sharedTerms[parent.termIndex] = term = this.buildTerm(parent);
        }
        if (this.stackPosition == 0) {
            this.isDone = true;
        }
    }

    private int readInt() {
        byte part = this.currentBuffer.get();
        int result = part & 0x7F;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 7;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 14;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        result |= (part & 0x7F) << 21;
        if ((part & 0x80) == 0) {
            return result;
        }
        part = this.currentBuffer.get();
        return result |= (part & 0x7F) << 28;
    }

    private double readDouble() {
        long result = this.readLong();
        return Double.longBitsToDouble(result);
    }

    private long readLong() {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result |= ((long)this.currentBuffer.get() & 0xFFL) << i * 8;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ATerm readTermFromSAFFile(PureFactory pureFactory, File file) throws IOException {
        BinaryReader binaryReader = new BinaryReader(pureFactory);
        ByteBuffer byteBuffer = ByteBuffer.allocate(65536);
        ByteBuffer sizeBuffer = ByteBuffer.allocate(2);
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(file);
            fc = fis.getChannel();
            byteBuffer.limit(1);
            int bytesRead = ((FileChannel)fc).read(byteBuffer);
            if (bytesRead != 1) {
                throw new IOException("Unable to read SAF identification token.\n");
            }
            do {
                sizeBuffer.clear();
                bytesRead = ((FileChannel)fc).read(sizeBuffer);
                if (bytesRead <= 0) break;
                if (bytesRead != 2) {
                    throw new IOException("Unable to read block size bytes from file: " + bytesRead + ".\n");
                }
                sizeBuffer.flip();
                int blockSize = (sizeBuffer.get() & 0xFF) + ((sizeBuffer.get() & 0xFF) << 8);
                if (blockSize == 0) {
                    blockSize = 65536;
                }
                byteBuffer.clear();
                byteBuffer.limit(blockSize);
                bytesRead = ((FileChannel)fc).read(byteBuffer);
                byteBuffer.flip();
                if (bytesRead != blockSize) {
                    throw new IOException("Unable to read bytes from file " + bytesRead + " vs " + blockSize + ".");
                }
                binaryReader.deserialize(byteBuffer);
            } while (bytesRead > 0);
            if (!binaryReader.isDone()) {
                throw new RuntimeException("Term incomplete, missing data.\n");
            }
        }
        finally {
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return binaryReader.getRoot();
    }

    public static ATerm readTermFromSAFString(PureFactory pureFactory, byte[] data) {
        int blockSize;
        BinaryReader binaryReader = new BinaryReader(pureFactory);
        int length = data.length;
        int position = 0;
        do {
            blockSize = data[position++] & 0xFF;
            if ((blockSize += (data[position++] & 0xFF) << 8) == 0) {
                blockSize = 65536;
            }
            ByteBuffer byteBuffer = ByteBuffer.allocate(blockSize);
            byteBuffer.put(data, position, blockSize);
            byteBuffer.flip();
            binaryReader.deserialize(byteBuffer);
        } while ((position += blockSize) < length);
        if (!binaryReader.isDone()) {
            throw new RuntimeException("Term incomplete, missing data.\n");
        }
        return binaryReader.getRoot();
    }

    private static class ATermConstruct {
        public int type;
        public int termIndex = 0;
        public ATerm tempTerm = null;
        public int subTermIndex = 0;
        public ATerm[] subTerms = null;
        public boolean hasAnnos;
        public ATermList annos;

        private ATermConstruct() {
        }
    }
}

