/*
 * Decompiled with CFR 0.152.
 */
package aterm.pure.binary;

import aterm.AFun;
import aterm.ATerm;
import aterm.ATermList;
import aterm.ParseError;
import aterm.pure.PureFactory;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class BAFReader {
    private static final int BAF_MAGIC = 2991;
    private static final int BAF_VERSION = 768;
    private static final int HEADER_BITS = 32;
    private BitStream reader;
    private int nrUniqueSymbols = -1;
    private SymEntry[] symbols;
    private PureFactory factory;
    public static boolean isDebugging = false;
    int level = 0;

    public BAFReader(PureFactory factory, InputStream inputStream) {
        this.factory = factory;
        this.reader = new BitStream(inputStream);
    }

    public ATerm readFromBinaryFile(boolean headerAlreadyRead) throws ParseError, IOException {
        if (!headerAlreadyRead && !BAFReader.isBinaryATerm(this.reader)) {
            throw new ParseError("Input is not a BAF file");
        }
        int val = this.reader.readInt();
        if (val != 768) {
            throw new ParseError("Wrong BAF version (wanted 768, got " + val + "), giving up");
        }
        this.nrUniqueSymbols = this.reader.readInt();
        int nrUniqueTerms = this.reader.readInt();
        if (this.isDebugging()) {
            this.debug("" + this.nrUniqueSymbols + " unique symbols");
            this.debug("" + nrUniqueTerms + " unique terms");
        }
        this.symbols = new SymEntry[this.nrUniqueSymbols];
        this.readAllSymbols();
        int i = this.reader.readInt();
        return this.readTerm(this.symbols[i]);
    }

    private boolean isDebugging() {
        return isDebugging;
    }

    public static boolean isBinaryATerm(BufferedInputStream in) throws IOException {
        return BAFReader.isBinaryATerm(new BitStream(in));
    }

    private static boolean isBinaryATerm(BitStream in) throws IOException {
        try {
            int w1 = in.readInt();
            return w1 == 2991;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    private void debug(String s) {
        System.err.println(s);
    }

    private ATerm readTerm(SymEntry e) throws ParseError, IOException {
        int i;
        int val;
        int arity = e.arity;
        ATerm[] args = new ATerm[arity];
        ++this.level;
        if (this.isDebugging()) {
            this.debug("readTerm()/" + this.level + " - " + e.fun.getName() + "[" + arity + "]");
        }
        for (int i2 = 0; i2 < arity; ++i2) {
            val = this.reader.readBits(e.symWidth[i2]);
            if (this.isDebugging()) {
                this.debug(" [" + i2 + "] - " + val);
                this.debug(" [" + i2 + "] - " + e.topSyms[i2].length);
            }
            SymEntry argSym = this.symbols[e.topSyms[i2][val]];
            val = this.reader.readBits(argSym.termWidth);
            if (argSym.terms[val] == null) {
                if (this.isDebugging()) {
                    this.debug(" [" + i2 + "] - recurse");
                }
                argSym.terms[val] = this.readTerm(argSym);
            }
            if (argSym.terms[val] == null) {
                throw new ParseError("Cannot be null");
            }
            args[i2] = argSym.terms[val];
        }
        String name = e.fun.getName();
        if (name.equals("<int>")) {
            val = this.reader.readBits(32);
            --this.level;
            return this.factory.makeInt(val);
        }
        if (name.equals("<real>")) {
            this.reader.flushBitsFromReader();
            String s = this.reader.readString();
            --this.level;
            return this.factory.makeReal(new Double(s));
        }
        if (name.equals("[_,_]")) {
            if (this.isDebugging()) {
                this.debug("--");
                for (i = 0; i < args.length; ++i) {
                    this.debug(" + " + args[i].getClass());
                }
            }
            --this.level;
            return ((ATermList)args[1]).insert(args[0]);
        }
        if (name.equals("[]")) {
            --this.level;
            return this.factory.makeList();
        }
        if (name.equals("{_}")) {
            return args[0].setAnnotations((ATermList)args[1]);
        }
        if (name.equals("<_>")) {
            return this.factory.makePlaceholder(args[0]);
        }
        if (this.isDebugging()) {
            this.debug(e.fun + " / " + args);
            for (i = 0; i < args.length; ++i) {
                this.debug("" + args[i]);
            }
        }
        --this.level;
        return this.factory.makeAppl(e.fun, args);
    }

    private void readAllSymbols() throws IOException {
        for (int i = 0; i < this.nrUniqueSymbols; ++i) {
            int v;
            AFun fun;
            SymEntry e;
            this.symbols[i] = e = new SymEntry();
            e.fun = fun = this.readSymbol();
            int arity = e.arity = fun.getArity();
            e.nrTerms = v = this.reader.readInt();
            e.termWidth = this.bitWidth(v);
            ATerm[] aTermArray = e.terms = v == 0 ? null : new ATerm[v];
            if (arity == 0) {
                e.nrTopSyms = null;
                e.symWidth = null;
                e.topSyms = null;
            } else {
                e.nrTopSyms = new int[arity];
                e.symWidth = new int[arity];
                e.topSyms = new int[arity][];
            }
            for (int j = 0; j < arity; ++j) {
                e.nrTopSyms[j] = v = this.reader.readInt();
                e.symWidth[j] = this.bitWidth(v);
                e.topSyms[j] = new int[v];
                for (int k = 0; k < e.nrTopSyms[j]; ++k) {
                    e.topSyms[j][k] = v = this.reader.readInt();
                }
            }
        }
    }

    private int bitWidth(int v) {
        int nrBits = 0;
        if (v <= 1) {
            return 0;
        }
        while (v != 0) {
            v >>= 1;
            ++nrBits;
        }
        return nrBits;
    }

    private AFun readSymbol() throws IOException {
        String s = this.reader.readString();
        int arity = this.reader.readInt();
        int quoted = this.reader.readInt();
        if (this.isDebugging()) {
            this.debug(s + " / " + arity + " / " + quoted);
        }
        return this.factory.makeAFun(s, arity, quoted != 0);
    }

    public static class BitStream {
        InputStream stream;
        private int bitsInBuffer;
        private int bitBuffer;

        public BitStream(InputStream inputStream) {
            this.stream = inputStream;
        }

        public int readInt() throws IOException {
            int[] buf = new int[5];
            buf[0] = this.readByte();
            if ((buf[0] & 0x80) == 0) {
                return buf[0];
            }
            buf[1] = this.readByte();
            if ((buf[0] & 0x40) == 0) {
                return buf[1] + ((buf[0] & 0xFFFFFF3F) << 8);
            }
            buf[2] = this.readByte();
            if ((buf[0] & 0x20) == 0) {
                return buf[2] + (buf[1] << 8) + ((buf[0] & 0xFFFFFF1F) << 16);
            }
            buf[3] = this.readByte();
            if ((buf[0] & 0x10) == 0) {
                return buf[3] + (buf[2] << 8) + (buf[1] << 16) + ((buf[0] & 0xFFFFFF0F) << 24);
            }
            buf[4] = this.readByte();
            return buf[4] + (buf[3] << 8) + (buf[2] << 16) + (buf[1] << 24);
        }

        private int readByte() throws IOException {
            int c = this.stream.read();
            if (c == -1) {
                throw new EOFException();
            }
            return c;
        }

        public String readString() throws IOException {
            int l = this.readInt();
            byte[] b = new byte[l];
            for (int v = 0; v < b.length; v += this.stream.read(b, v, b.length - v)) {
            }
            return new String(b);
        }

        public int readBits(int nrBits) throws IOException {
            int mask = 1;
            int val = 0;
            for (int i = 0; i < nrBits; ++i) {
                if (this.bitsInBuffer == 0) {
                    int v = this.readByte();
                    if (v == -1) {
                        return -1;
                    }
                    this.bitBuffer = v;
                    this.bitsInBuffer = 8;
                }
                val |= (this.bitBuffer & 0x80) != 0 ? mask : 0;
                mask <<= 1;
                this.bitBuffer <<= 1;
                --this.bitsInBuffer;
            }
            return val;
        }

        public void flushBitsFromReader() {
            this.bitsInBuffer = 0;
        }
    }

    private static class SymEntry {
        public AFun fun;
        public int arity;
        public int nrTerms;
        public int termWidth;
        public ATerm[] terms;
        public int[] nrTopSyms;
        public int[] symWidth;
        public int[][] topSyms;

        private SymEntry() {
        }
    }
}

